
























var _virtualizedTable = require("components/virtualized-table");var _virtualizedTable2 = _interopRequireDefault(_virtualizedTable);
var _react = require("react");var _react2 = _interopRequireDefault(_react);
var _reactDom = require("react-dom");var _reactDom2 = _interopRequireDefault(_reactDom);function _interopRequireDefault(obj) {return obj && obj.__esModule ? obj : { default: obj };} /*
	***** BEGIN LICENSE BLOCK *****
	
	Copyright © 2020 Corporation for Digital Scholarship
                     Vienna, Virginia, USA
					http://zotero.org
	
	This file is part of Zotero.
	
	Zotero is free software: you can redistribute it and/or modify
	it under the terms of the GNU Affero General Public License as published by
	the Free Software Foundation, either version 3 of the License, or
	(at your option) any later version.
	
	Zotero is distributed in the hope that it will be useful,
	but WITHOUT ANY WARRANTY; without even the implied warranty of
	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
	GNU Affero General Public License for more details.

	You should have received a copy of the GNU Affero General Public License
	along with Zotero.  If not, see <http://www.gnu.org/licenses/>.
	
	***** END LICENSE BLOCK *****
*/var tree;var engines;const columns = [{ dataKey: 'visible', type: 'checkbox', fixedWidth: true, width: 28 }, { dataKey: 'name', label: "zotero.preferences.locate.name" }, { dataKey: 'description', label: "zotero.preferences.locate.description" }];function init() {engines = Zotero.LocateManager.getEngines();const domEl = document.querySelector('#locateManager-tree');let elem = /*#__PURE__*/_react2.default.createElement(_virtualizedTable2.default, { getRowCount: () => engines.length, id: "locateManager-table", ref: (ref) => tree = ref, renderItem: _virtualizedTable2.default.makeRowRenderer(getRowData), showHeader: true, multiSelect: true, columns: columns, disableFontSizeScaling: true,
    getRowString: (index) => getRowData(index).name,
    onActivate: handleActivate });


  return new Promise((resolve) => _reactDom2.default.render(elem, domEl, resolve));
}

function getRowData(index) {
  var data = {};
  columns.forEach((column) => {
    if (column.dataKey == 'visible') {
      var value = !engines[index].hidden;
    } else
    {
      value = engines[index][column.dataKey];
    }
    data[column.dataKey] = value;
  });
  return data;
}

/**
 * Refreshes the list of locate engines in the locate pane
 * @param {String} name of locate engine to select
 */
function updateTree() {
  if (!tree) return;
  tree.forceUpdate(tree.invalidate);
}

function handleActivate(event, indices) {
  // Ignore Enter, only run on dblclick
  if (event.key) return;
  indices.forEach((index) => engines[index].hidden = !engines[index].hidden);
  updateTree();
}

/**
 * Adds a new Locate Engine to the locate pane
 **/
/*
function addLocateEngine() {
	// alert(Zotero.LocateManager.activeLocateEngines.join(" || "));
	var textbox = document.getElementById('locate-add-textbox');
	Zotero.LocateManager.addLocateEngine(textbox.value);

	refreshLocateEnginesList();
}
*/

function toggleLocateEngines() {
  if (!tree) return;
  const numSelected = tree.selection.count;
  const numVisible = engines.filter((_, index) => tree.selection.isSelected(index)).
  reduce((acc, engine) => acc + (engine.hidden ? 0 : 1), 0);

  // Make all visible, unless all selected are already visible
  var hideAll = numVisible == numSelected;

  engines.forEach((engine, index) => {
    if (tree.selection.isSelected(index)) {
      engine.hidden = hideAll;
    }
  });
  updateTree();
}

/**
 * Deletes selected Locate Engines from the locate pane
 **/
function deleteLocateEngine() {
  engines.forEach((engine, index) => {
    if (tree.selection.isSelected(index)) {
      Zotero.LocateManager.removeLocateEngine(engine);
    }
  });

  tree.selection.clearSelection();
  updateTree();
}

/**
 * Restores Default Locate Engines
 **/
function restoreDefaultLocateEngines() {
  Zotero.LocateManager.restoreDefaultEngines();
  engines = Zotero.LocateManager.getEngines();
  updateTree();
}