/*
    ***** BEGIN LICENSE BLOCK *****
    
    Copyright © 2019 Corporation for Digital Scholarship
                     Vienna, Virginia, USA
                     https://digitalscholar.org
    
    This file is part of Zotero.
    
    Zotero is free software: you can redistribute it and/or modify
    it under the terms of the GNU Affero General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.
    
    Zotero is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU Affero General Public License for more details.
    
    You should have received a copy of the GNU Affero General Public License
    along with Zotero.  If not, see <http://www.gnu.org/licenses/>.
    
    ***** END LICENSE BLOCK *****
*/

'use strict';function _defineProperty(obj, key, value) {if (key in obj) {Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true });} else {obj[key] = value;}return obj;}

const React = require('react');
const { PureComponent, createElement: create } = React;
const { IconDownChevron } = require('./icons');
const cx = require('classnames');
const {
  bool, element, func, node, number, oneOf, string } =
require('prop-types');


const ButtonGroup = ({ children }) => /*#__PURE__*/
React.createElement("div", { className: "btn-group" }, children);


ButtonGroup.propTypes = {
  children: node };


class Button extends PureComponent {constructor(...args) {super(...args);_defineProperty(this, "setContainer",






































































    (container) => {
      this.container = container;
    });_defineProperty(this, "handleClick",

    (event) => {
      event.preventDefault();

      if (!this.props.isDisabled && this.props.onClick) {
        this.props.onClick(event);
      }
    });_defineProperty(this, "handleMouseDown",

    (event) => {
      event.preventDefault();

      if (!this.props.isDisabled && this.props.onMouseDown) {
        this.props.onMouseDown(event);
      }
    });}get classes() {return ['btn', this.props.className, `btn-${this.props.size}`, { 'btn-icon': this.props.icon != null, 'active': this.props.isActive, 'btn-flat': this.props.isFlat, 'btn-menu': this.props.isMenu, 'disabled': this.props.isDisabled }];}get node() {return 'button';}get text() {const { text } = this.props;return text ? Zotero.getString(text) : null;}get title() {const { title } = this.props;return title ? Zotero.getString(title) : null;}get menuMarker() {if (!Zotero.isNode && Zotero.isLinux) {return this.props.isMenu && /*#__PURE__*/React.createElement("span", { className: "menu-marker" });}return this.props.isMenu && /*#__PURE__*/React.createElement(IconDownChevron, { className: "menu-marker" });}get attributes() {const attr = { className: cx(...this.classes), disabled: !this.props.noFocus && this.props.isDisabled, onBlur: this.handleBlur, onFocus: this.props.onFocus, ref: this.setContainer, title: this.title };if (!this.props.isDisabled) {attr.onMouseDown = (event) => {// Hide tooltip on mousedown
        if (this.title) {window.Zotero_Tooltip.stop();}return this.handleMouseDown(event);};attr.onClick = this.handleClick; // Fake tooltip behavior as long as 'title' doesn't work for HTML-in-XUL elements
      if (this.title) {attr.onMouseOver = () => {window.Zotero_Tooltip.start(this.title);};attr.onMouseOut = () => {window.Zotero_Tooltip.stop();};}}return attr;}render() {
    return create(this.node, this.attributes, this.props.icon, this.text, this.menuMarker);
  }}_defineProperty(Button, "propTypes",

{
  className: string,
  icon: element,
  isActive: bool,
  isDisabled: bool,
  isMenu: bool,
  size: oneOf(['sm', 'md', 'lg']),
  title: string,
  text: string,
  onClick: func,
  onMouseDown: func });_defineProperty(Button, "defaultProps",


{
  size: 'md' });




module.exports = {
  ButtonGroup,
  Button };