(function webpackUniversalModuleDefinition(root, factory) {
	if(typeof exports === 'object' && typeof module === 'object')
		module.exports = factory(require("React"), require("ReactIntl"), require("ReactDOM"));
	else if(typeof define === 'function' && define.amd)
		define("pdf-reader", ["React", "ReactIntl", "ReactDOM"], factory);
	else if(typeof exports === 'object')
		exports["pdf-reader"] = factory(require("React"), require("ReactIntl"), require("ReactDOM"));
	else
		root["pdf-reader"] = factory(root["React"], root["ReactIntl"], root["ReactDOM"]);
})(window, function(__WEBPACK_EXTERNAL_MODULE__0__, __WEBPACK_EXTERNAL_MODULE__3__, __WEBPACK_EXTERNAL_MODULE__4__) {
return /******/ (function(modules) { // webpackBootstrap
/******/ 	// The module cache
/******/ 	var installedModules = {};
/******/
/******/ 	// The require function
/******/ 	function __webpack_require__(moduleId) {
/******/
/******/ 		// Check if module is in cache
/******/ 		if(installedModules[moduleId]) {
/******/ 			return installedModules[moduleId].exports;
/******/ 		}
/******/ 		// Create a new module (and put it into the cache)
/******/ 		var module = installedModules[moduleId] = {
/******/ 			i: moduleId,
/******/ 			l: false,
/******/ 			exports: {}
/******/ 		};
/******/
/******/ 		// Execute the module function
/******/ 		modules[moduleId].call(module.exports, module, module.exports, __webpack_require__);
/******/
/******/ 		// Flag the module as loaded
/******/ 		module.l = true;
/******/
/******/ 		// Return the exports of the module
/******/ 		return module.exports;
/******/ 	}
/******/
/******/
/******/ 	// expose the modules object (__webpack_modules__)
/******/ 	__webpack_require__.m = modules;
/******/
/******/ 	// expose the module cache
/******/ 	__webpack_require__.c = installedModules;
/******/
/******/ 	// define getter function for harmony exports
/******/ 	__webpack_require__.d = function(exports, name, getter) {
/******/ 		if(!__webpack_require__.o(exports, name)) {
/******/ 			Object.defineProperty(exports, name, { enumerable: true, get: getter });
/******/ 		}
/******/ 	};
/******/
/******/ 	// define __esModule on exports
/******/ 	__webpack_require__.r = function(exports) {
/******/ 		if(typeof Symbol !== 'undefined' && Symbol.toStringTag) {
/******/ 			Object.defineProperty(exports, Symbol.toStringTag, { value: 'Module' });
/******/ 		}
/******/ 		Object.defineProperty(exports, '__esModule', { value: true });
/******/ 	};
/******/
/******/ 	// create a fake namespace object
/******/ 	// mode & 1: value is a module id, require it
/******/ 	// mode & 2: merge all properties of value into the ns
/******/ 	// mode & 4: return value when already ns object
/******/ 	// mode & 8|1: behave like require
/******/ 	__webpack_require__.t = function(value, mode) {
/******/ 		if(mode & 1) value = __webpack_require__(value);
/******/ 		if(mode & 8) return value;
/******/ 		if((mode & 4) && typeof value === 'object' && value && value.__esModule) return value;
/******/ 		var ns = Object.create(null);
/******/ 		__webpack_require__.r(ns);
/******/ 		Object.defineProperty(ns, 'default', { enumerable: true, value: value });
/******/ 		if(mode & 2 && typeof value != 'string') for(var key in value) __webpack_require__.d(ns, key, function(key) { return value[key]; }.bind(null, key));
/******/ 		return ns;
/******/ 	};
/******/
/******/ 	// getDefaultExport function for compatibility with non-harmony modules
/******/ 	__webpack_require__.n = function(module) {
/******/ 		var getter = module && module.__esModule ?
/******/ 			function getDefault() { return module['default']; } :
/******/ 			function getModuleExports() { return module; };
/******/ 		__webpack_require__.d(getter, 'a', getter);
/******/ 		return getter;
/******/ 	};
/******/
/******/ 	// Object.prototype.hasOwnProperty.call
/******/ 	__webpack_require__.o = function(object, property) { return Object.prototype.hasOwnProperty.call(object, property); };
/******/
/******/ 	// __webpack_public_path__
/******/ 	__webpack_require__.p = "/";
/******/
/******/
/******/ 	// Load entry module and return exports
/******/ 	return __webpack_require__(__webpack_require__.s = 7);
/******/ })
/************************************************************************/
/******/ ([
/* 0 */
/***/ (function(module, exports) {

module.exports = __WEBPACK_EXTERNAL_MODULE__0__;

/***/ }),
/* 1 */
/***/ (function(module, exports) {

function _defineProperty(obj, key, value) {
  if (key in obj) {
    Object.defineProperty(obj, key, {
      value: value,
      enumerable: true,
      configurable: true,
      writable: true
    });
  } else {
    obj[key] = value;
  }

  return obj;
}

module.exports = _defineProperty, module.exports.__esModule = true, module.exports["default"] = module.exports;

/***/ }),
/* 2 */
/***/ (function(module, exports, __webpack_require__) {

var __WEBPACK_AMD_DEFINE_ARRAY__, __WEBPACK_AMD_DEFINE_RESULT__;/*!
  Copyright (c) 2018 Jed Watson.
  Licensed under the MIT License (MIT), see
  http://jedwatson.github.io/classnames
*/
/* global define */

(function () {
	'use strict';

	var hasOwn = {}.hasOwnProperty;

	function classNames() {
		var classes = [];

		for (var i = 0; i < arguments.length; i++) {
			var arg = arguments[i];
			if (!arg) continue;

			var argType = typeof arg;

			if (argType === 'string' || argType === 'number') {
				classes.push(arg);
			} else if (Array.isArray(arg)) {
				if (arg.length) {
					var inner = classNames.apply(null, arg);
					if (inner) {
						classes.push(inner);
					}
				}
			} else if (argType === 'object') {
				if (arg.toString === Object.prototype.toString) {
					for (var key in arg) {
						if (hasOwn.call(arg, key) && arg[key]) {
							classes.push(key);
						}
					}
				} else {
					classes.push(arg.toString());
				}
			}
		}

		return classes.join(' ');
	}

	if ( true && module.exports) {
		classNames.default = classNames;
		module.exports = classNames;
	} else if (true) {
		// register as 'classnames', consistent with npm package name
		!(__WEBPACK_AMD_DEFINE_ARRAY__ = [], __WEBPACK_AMD_DEFINE_RESULT__ = (function () {
			return classNames;
		}).apply(exports, __WEBPACK_AMD_DEFINE_ARRAY__),
				__WEBPACK_AMD_DEFINE_RESULT__ !== undefined && (module.exports = __WEBPACK_AMD_DEFINE_RESULT__));
	} else {}
}());


/***/ }),
/* 3 */
/***/ (function(module, exports) {

module.exports = __WEBPACK_EXTERNAL_MODULE__3__;

/***/ }),
/* 4 */
/***/ (function(module, exports) {

module.exports = __WEBPACK_EXTERNAL_MODULE__4__;

/***/ }),
/* 5 */
/***/ (function(module, exports) {

function _extends() {
  module.exports = _extends = Object.assign || function (target) {
    for (var i = 1; i < arguments.length; i++) {
      var source = arguments[i];

      for (var key in source) {
        if (Object.prototype.hasOwnProperty.call(source, key)) {
          target[key] = source[key];
        }
      }
    }

    return target;
  }, module.exports.__esModule = true, module.exports["default"] = module.exports;
  return _extends.apply(this, arguments);
}

module.exports = _extends, module.exports.__esModule = true, module.exports["default"] = module.exports;

/***/ }),
/* 6 */
/***/ (function(module, exports, __webpack_require__) {

var inherits = __webpack_require__(8)
var EventEmitter = __webpack_require__(9).EventEmitter

module.exports = Queue
module.exports.default = Queue

function Queue (options) {
  if (!(this instanceof Queue)) {
    return new Queue(options)
  }

  EventEmitter.call(this)
  options = options || {}
  this.concurrency = options.concurrency || Infinity
  this.timeout = options.timeout || 0
  this.autostart = options.autostart || false
  this.results = options.results || null
  this.pending = 0
  this.session = 0
  this.running = false
  this.jobs = []
  this.timers = {}
}
inherits(Queue, EventEmitter)

var arrayMethods = [
  'pop',
  'shift',
  'indexOf',
  'lastIndexOf'
]

arrayMethods.forEach(function (method) {
  Queue.prototype[method] = function () {
    return Array.prototype[method].apply(this.jobs, arguments)
  }
})

Queue.prototype.slice = function (begin, end) {
  this.jobs = this.jobs.slice(begin, end)
  return this
}

Queue.prototype.reverse = function () {
  this.jobs.reverse()
  return this
}

var arrayAddMethods = [
  'push',
  'unshift',
  'splice'
]

arrayAddMethods.forEach(function (method) {
  Queue.prototype[method] = function () {
    var methodResult = Array.prototype[method].apply(this.jobs, arguments)
    if (this.autostart) {
      this.start()
    }
    return methodResult
  }
})

Object.defineProperty(Queue.prototype, 'length', {
  get: function () {
    return this.pending + this.jobs.length
  }
})

Queue.prototype.start = function (cb) {
  if (cb) {
    callOnErrorOrEnd.call(this, cb)
  }

  this.running = true

  if (this.pending >= this.concurrency) {
    return
  }

  if (this.jobs.length === 0) {
    if (this.pending === 0) {
      done.call(this)
    }
    return
  }

  var self = this
  var job = this.jobs.shift()
  var once = true
  var session = this.session
  var timeoutId = null
  var didTimeout = false
  var resultIndex = null
  var timeout = job.hasOwnProperty('timeout') ? job.timeout : this.timeout

  function next (err, result) {
    if (once && self.session === session) {
      once = false
      self.pending--
      if (timeoutId !== null) {
        delete self.timers[timeoutId]
        clearTimeout(timeoutId)
      }

      if (err) {
        self.emit('error', err, job)
      } else if (didTimeout === false) {
        if (resultIndex !== null) {
          self.results[resultIndex] = Array.prototype.slice.call(arguments, 1)
        }
        self.emit('success', result, job)
      }

      if (self.session === session) {
        if (self.pending === 0 && self.jobs.length === 0) {
          done.call(self)
        } else if (self.running) {
          self.start()
        }
      }
    }
  }

  if (timeout) {
    timeoutId = setTimeout(function () {
      didTimeout = true
      if (self.listeners('timeout').length > 0) {
        self.emit('timeout', next, job)
      } else {
        next()
      }
    }, timeout)
    this.timers[timeoutId] = timeoutId
  }

  if (this.results) {
    resultIndex = this.results.length
    this.results[resultIndex] = null
  }

  this.pending++
  self.emit('start', job)
  var promise = job(next)
  if (promise && promise.then && typeof promise.then === 'function') {
    promise.then(function (result) {
      return next(null, result)
    }).catch(function (err) {
      return next(err || true)
    })
  }

  if (this.running && this.jobs.length > 0) {
    this.start()
  }
}

Queue.prototype.stop = function () {
  this.running = false
}

Queue.prototype.end = function (err) {
  clearTimers.call(this)
  this.jobs.length = 0
  this.pending = 0
  done.call(this, err)
}

function clearTimers () {
  for (var key in this.timers) {
    var timeoutId = this.timers[key]
    delete this.timers[key]
    clearTimeout(timeoutId)
  }
}

function callOnErrorOrEnd (cb) {
  var self = this
  this.on('error', onerror)
  this.on('end', onend)

  function onerror (err) { self.end(err) }
  function onend (err) {
    self.removeListener('error', onerror)
    self.removeListener('end', onend)
    cb(err, this.results)
  }
}

function done (err) {
  this.session++
  this.running = false
  this.emit('end', err)
}


/***/ }),
/* 7 */
/***/ (function(module, exports, __webpack_require__) {

__webpack_require__(11);
module.exports = __webpack_require__(10);


/***/ }),
/* 8 */
/***/ (function(module, exports) {

if (typeof Object.create === 'function') {
  // implementation from standard node.js 'util' module
  module.exports = function inherits(ctor, superCtor) {
    ctor.super_ = superCtor
    ctor.prototype = Object.create(superCtor.prototype, {
      constructor: {
        value: ctor,
        enumerable: false,
        writable: true,
        configurable: true
      }
    });
  };
} else {
  // old school shim for old browsers
  module.exports = function inherits(ctor, superCtor) {
    ctor.super_ = superCtor
    var TempCtor = function () {}
    TempCtor.prototype = superCtor.prototype
    ctor.prototype = new TempCtor()
    ctor.prototype.constructor = ctor
  }
}


/***/ }),
/* 9 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";
// Copyright Joyent, Inc. and other Node contributors.
//
// Permission is hereby granted, free of charge, to any person obtaining a
// copy of this software and associated documentation files (the
// "Software"), to deal in the Software without restriction, including
// without limitation the rights to use, copy, modify, merge, publish,
// distribute, sublicense, and/or sell copies of the Software, and to permit
// persons to whom the Software is furnished to do so, subject to the
// following conditions:
//
// The above copyright notice and this permission notice shall be included
// in all copies or substantial portions of the Software.
//
// THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS
// OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
// MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN
// NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM,
// DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR
// OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE
// USE OR OTHER DEALINGS IN THE SOFTWARE.



var R = typeof Reflect === 'object' ? Reflect : null
var ReflectApply = R && typeof R.apply === 'function'
  ? R.apply
  : function ReflectApply(target, receiver, args) {
    return Function.prototype.apply.call(target, receiver, args);
  }

var ReflectOwnKeys
if (R && typeof R.ownKeys === 'function') {
  ReflectOwnKeys = R.ownKeys
} else if (Object.getOwnPropertySymbols) {
  ReflectOwnKeys = function ReflectOwnKeys(target) {
    return Object.getOwnPropertyNames(target)
      .concat(Object.getOwnPropertySymbols(target));
  };
} else {
  ReflectOwnKeys = function ReflectOwnKeys(target) {
    return Object.getOwnPropertyNames(target);
  };
}

function ProcessEmitWarning(warning) {
  if (console && console.warn) console.warn(warning);
}

var NumberIsNaN = Number.isNaN || function NumberIsNaN(value) {
  return value !== value;
}

function EventEmitter() {
  EventEmitter.init.call(this);
}
module.exports = EventEmitter;
module.exports.once = once;

// Backwards-compat with node 0.10.x
EventEmitter.EventEmitter = EventEmitter;

EventEmitter.prototype._events = undefined;
EventEmitter.prototype._eventsCount = 0;
EventEmitter.prototype._maxListeners = undefined;

// By default EventEmitters will print a warning if more than 10 listeners are
// added to it. This is a useful default which helps finding memory leaks.
var defaultMaxListeners = 10;

function checkListener(listener) {
  if (typeof listener !== 'function') {
    throw new TypeError('The "listener" argument must be of type Function. Received type ' + typeof listener);
  }
}

Object.defineProperty(EventEmitter, 'defaultMaxListeners', {
  enumerable: true,
  get: function() {
    return defaultMaxListeners;
  },
  set: function(arg) {
    if (typeof arg !== 'number' || arg < 0 || NumberIsNaN(arg)) {
      throw new RangeError('The value of "defaultMaxListeners" is out of range. It must be a non-negative number. Received ' + arg + '.');
    }
    defaultMaxListeners = arg;
  }
});

EventEmitter.init = function() {

  if (this._events === undefined ||
      this._events === Object.getPrototypeOf(this)._events) {
    this._events = Object.create(null);
    this._eventsCount = 0;
  }

  this._maxListeners = this._maxListeners || undefined;
};

// Obviously not all Emitters should be limited to 10. This function allows
// that to be increased. Set to zero for unlimited.
EventEmitter.prototype.setMaxListeners = function setMaxListeners(n) {
  if (typeof n !== 'number' || n < 0 || NumberIsNaN(n)) {
    throw new RangeError('The value of "n" is out of range. It must be a non-negative number. Received ' + n + '.');
  }
  this._maxListeners = n;
  return this;
};

function _getMaxListeners(that) {
  if (that._maxListeners === undefined)
    return EventEmitter.defaultMaxListeners;
  return that._maxListeners;
}

EventEmitter.prototype.getMaxListeners = function getMaxListeners() {
  return _getMaxListeners(this);
};

EventEmitter.prototype.emit = function emit(type) {
  var args = [];
  for (var i = 1; i < arguments.length; i++) args.push(arguments[i]);
  var doError = (type === 'error');

  var events = this._events;
  if (events !== undefined)
    doError = (doError && events.error === undefined);
  else if (!doError)
    return false;

  // If there is no 'error' event listener then throw.
  if (doError) {
    var er;
    if (args.length > 0)
      er = args[0];
    if (er instanceof Error) {
      // Note: The comments on the `throw` lines are intentional, they show
      // up in Node's output if this results in an unhandled exception.
      throw er; // Unhandled 'error' event
    }
    // At least give some kind of context to the user
    var err = new Error('Unhandled error.' + (er ? ' (' + er.message + ')' : ''));
    err.context = er;
    throw err; // Unhandled 'error' event
  }

  var handler = events[type];

  if (handler === undefined)
    return false;

  if (typeof handler === 'function') {
    ReflectApply(handler, this, args);
  } else {
    var len = handler.length;
    var listeners = arrayClone(handler, len);
    for (var i = 0; i < len; ++i)
      ReflectApply(listeners[i], this, args);
  }

  return true;
};

function _addListener(target, type, listener, prepend) {
  var m;
  var events;
  var existing;

  checkListener(listener);

  events = target._events;
  if (events === undefined) {
    events = target._events = Object.create(null);
    target._eventsCount = 0;
  } else {
    // To avoid recursion in the case that type === "newListener"! Before
    // adding it to the listeners, first emit "newListener".
    if (events.newListener !== undefined) {
      target.emit('newListener', type,
                  listener.listener ? listener.listener : listener);

      // Re-assign `events` because a newListener handler could have caused the
      // this._events to be assigned to a new object
      events = target._events;
    }
    existing = events[type];
  }

  if (existing === undefined) {
    // Optimize the case of one listener. Don't need the extra array object.
    existing = events[type] = listener;
    ++target._eventsCount;
  } else {
    if (typeof existing === 'function') {
      // Adding the second element, need to change to array.
      existing = events[type] =
        prepend ? [listener, existing] : [existing, listener];
      // If we've already got an array, just append.
    } else if (prepend) {
      existing.unshift(listener);
    } else {
      existing.push(listener);
    }

    // Check for listener leak
    m = _getMaxListeners(target);
    if (m > 0 && existing.length > m && !existing.warned) {
      existing.warned = true;
      // No error code for this since it is a Warning
      // eslint-disable-next-line no-restricted-syntax
      var w = new Error('Possible EventEmitter memory leak detected. ' +
                          existing.length + ' ' + String(type) + ' listeners ' +
                          'added. Use emitter.setMaxListeners() to ' +
                          'increase limit');
      w.name = 'MaxListenersExceededWarning';
      w.emitter = target;
      w.type = type;
      w.count = existing.length;
      ProcessEmitWarning(w);
    }
  }

  return target;
}

EventEmitter.prototype.addListener = function addListener(type, listener) {
  return _addListener(this, type, listener, false);
};

EventEmitter.prototype.on = EventEmitter.prototype.addListener;

EventEmitter.prototype.prependListener =
    function prependListener(type, listener) {
      return _addListener(this, type, listener, true);
    };

function onceWrapper() {
  if (!this.fired) {
    this.target.removeListener(this.type, this.wrapFn);
    this.fired = true;
    if (arguments.length === 0)
      return this.listener.call(this.target);
    return this.listener.apply(this.target, arguments);
  }
}

function _onceWrap(target, type, listener) {
  var state = { fired: false, wrapFn: undefined, target: target, type: type, listener: listener };
  var wrapped = onceWrapper.bind(state);
  wrapped.listener = listener;
  state.wrapFn = wrapped;
  return wrapped;
}

EventEmitter.prototype.once = function once(type, listener) {
  checkListener(listener);
  this.on(type, _onceWrap(this, type, listener));
  return this;
};

EventEmitter.prototype.prependOnceListener =
    function prependOnceListener(type, listener) {
      checkListener(listener);
      this.prependListener(type, _onceWrap(this, type, listener));
      return this;
    };

// Emits a 'removeListener' event if and only if the listener was removed.
EventEmitter.prototype.removeListener =
    function removeListener(type, listener) {
      var list, events, position, i, originalListener;

      checkListener(listener);

      events = this._events;
      if (events === undefined)
        return this;

      list = events[type];
      if (list === undefined)
        return this;

      if (list === listener || list.listener === listener) {
        if (--this._eventsCount === 0)
          this._events = Object.create(null);
        else {
          delete events[type];
          if (events.removeListener)
            this.emit('removeListener', type, list.listener || listener);
        }
      } else if (typeof list !== 'function') {
        position = -1;

        for (i = list.length - 1; i >= 0; i--) {
          if (list[i] === listener || list[i].listener === listener) {
            originalListener = list[i].listener;
            position = i;
            break;
          }
        }

        if (position < 0)
          return this;

        if (position === 0)
          list.shift();
        else {
          spliceOne(list, position);
        }

        if (list.length === 1)
          events[type] = list[0];

        if (events.removeListener !== undefined)
          this.emit('removeListener', type, originalListener || listener);
      }

      return this;
    };

EventEmitter.prototype.off = EventEmitter.prototype.removeListener;

EventEmitter.prototype.removeAllListeners =
    function removeAllListeners(type) {
      var listeners, events, i;

      events = this._events;
      if (events === undefined)
        return this;

      // not listening for removeListener, no need to emit
      if (events.removeListener === undefined) {
        if (arguments.length === 0) {
          this._events = Object.create(null);
          this._eventsCount = 0;
        } else if (events[type] !== undefined) {
          if (--this._eventsCount === 0)
            this._events = Object.create(null);
          else
            delete events[type];
        }
        return this;
      }

      // emit removeListener for all listeners on all events
      if (arguments.length === 0) {
        var keys = Object.keys(events);
        var key;
        for (i = 0; i < keys.length; ++i) {
          key = keys[i];
          if (key === 'removeListener') continue;
          this.removeAllListeners(key);
        }
        this.removeAllListeners('removeListener');
        this._events = Object.create(null);
        this._eventsCount = 0;
        return this;
      }

      listeners = events[type];

      if (typeof listeners === 'function') {
        this.removeListener(type, listeners);
      } else if (listeners !== undefined) {
        // LIFO order
        for (i = listeners.length - 1; i >= 0; i--) {
          this.removeListener(type, listeners[i]);
        }
      }

      return this;
    };

function _listeners(target, type, unwrap) {
  var events = target._events;

  if (events === undefined)
    return [];

  var evlistener = events[type];
  if (evlistener === undefined)
    return [];

  if (typeof evlistener === 'function')
    return unwrap ? [evlistener.listener || evlistener] : [evlistener];

  return unwrap ?
    unwrapListeners(evlistener) : arrayClone(evlistener, evlistener.length);
}

EventEmitter.prototype.listeners = function listeners(type) {
  return _listeners(this, type, true);
};

EventEmitter.prototype.rawListeners = function rawListeners(type) {
  return _listeners(this, type, false);
};

EventEmitter.listenerCount = function(emitter, type) {
  if (typeof emitter.listenerCount === 'function') {
    return emitter.listenerCount(type);
  } else {
    return listenerCount.call(emitter, type);
  }
};

EventEmitter.prototype.listenerCount = listenerCount;
function listenerCount(type) {
  var events = this._events;

  if (events !== undefined) {
    var evlistener = events[type];

    if (typeof evlistener === 'function') {
      return 1;
    } else if (evlistener !== undefined) {
      return evlistener.length;
    }
  }

  return 0;
}

EventEmitter.prototype.eventNames = function eventNames() {
  return this._eventsCount > 0 ? ReflectOwnKeys(this._events) : [];
};

function arrayClone(arr, n) {
  var copy = new Array(n);
  for (var i = 0; i < n; ++i)
    copy[i] = arr[i];
  return copy;
}

function spliceOne(list, index) {
  for (; index + 1 < list.length; index++)
    list[index] = list[index + 1];
  list.pop();
}

function unwrapListeners(arr) {
  var ret = new Array(arr.length);
  for (var i = 0; i < ret.length; ++i) {
    ret[i] = arr[i].listener || arr[i];
  }
  return ret;
}

function once(emitter, name) {
  return new Promise(function (resolve, reject) {
    function errorListener(err) {
      emitter.removeListener(name, resolver);
      reject(err);
    }

    function resolver() {
      if (typeof emitter.removeListener === 'function') {
        emitter.removeListener('error', errorListener);
      }
      resolve([].slice.call(arguments));
    };

    eventTargetAgnosticAddListener(emitter, name, resolver, { once: true });
    if (name !== 'error') {
      addErrorHandlerIfEventEmitter(emitter, errorListener, { once: true });
    }
  });
}

function addErrorHandlerIfEventEmitter(emitter, handler, flags) {
  if (typeof emitter.on === 'function') {
    eventTargetAgnosticAddListener(emitter, 'error', handler, flags);
  }
}

function eventTargetAgnosticAddListener(emitter, name, listener, flags) {
  if (typeof emitter.on === 'function') {
    if (flags.once) {
      emitter.once(name, listener);
    } else {
      emitter.on(name, listener);
    }
  } else if (typeof emitter.addEventListener === 'function') {
    // EventTarget does not have `error` event semantics like Node
    // EventEmitters, we do not listen for `error` events here.
    emitter.addEventListener(name, function wrapListener(arg) {
      // IE does not have builtin `{ once: true }` support so we
      // have to do it manually.
      if (flags.once) {
        emitter.removeEventListener(name, wrapListener);
      }
      listener(arg);
    });
  } else {
    throw new TypeError('The "emitter" argument must be of type EventEmitter. Received type ' + typeof emitter);
  }
}


/***/ }),
/* 10 */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony default export */ __webpack_exports__["default"] = (__webpack_require__.p + "viewer.css");

/***/ }),
/* 11 */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
// ESM COMPAT FLAG
__webpack_require__.r(__webpack_exports__);

// EXTERNAL MODULE: ./node_modules/@babel/runtime/helpers/defineProperty.js
var defineProperty = __webpack_require__(1);
var defineProperty_default = /*#__PURE__*/__webpack_require__.n(defineProperty);

// EXTERNAL MODULE: external "React"
var external_React_ = __webpack_require__(0);
var external_React_default = /*#__PURE__*/__webpack_require__.n(external_React_);

// EXTERNAL MODULE: external "ReactDOM"
var external_ReactDOM_ = __webpack_require__(4);
var external_ReactDOM_default = /*#__PURE__*/__webpack_require__.n(external_ReactDOM_);

// EXTERNAL MODULE: external "ReactIntl"
var external_ReactIntl_ = __webpack_require__(3);

// EXTERNAL MODULE: ./node_modules/classnames/index.js
var classnames = __webpack_require__(2);
var classnames_default = /*#__PURE__*/__webpack_require__.n(classnames);

// CONCATENATED MODULE: ./src/components/highlight.js






class highlight_Highlight extends external_React_default.a.Component {
  constructor(...args) {
    super(...args);

    defineProperty_default()(this, "draggableRef", /*#__PURE__*/external_React_default.a.createRef());
  }

  render() {
    let {
      annotation,
      isSelected
    } = this.props;
    let rects = annotation.position.rects;
    let padding = 5;
    let squareRect = [Math.min(...rects.map(x => x[0])) - padding, Math.min(...rects.map(x => x[1])) - padding, Math.max(...rects.map(x => x[2])) + padding, Math.max(...rects.map(x => x[3])) + padding];
    return /*#__PURE__*/external_React_default.a.createElement("div", {
      id: 'annotation-' + annotation.id,
      className: classnames_default()('highlight-annotation', {
        selected: isSelected
      })
    }, /*#__PURE__*/external_React_default.a.createElement("div", {
      ref: this.draggableRef,
      className: "square",
      style: {
        left: squareRect[0],
        top: squareRect[1],
        width: squareRect[2] - squareRect[0],
        height: squareRect[3] - squareRect[1]
      } // draggable={true}
      // onDragStart={this.props.onDragStart}
      // onDragEnd={this.props.onDragEnd}

    }), annotation.position.rects.map((rect, index) => /*#__PURE__*/external_React_default.a.createElement("div", {
      key: index,
      style: {
        left: rect[0],
        top: rect[1],
        width: rect[2] - rect[0],
        height: rect[3] - rect[1],
        backgroundColor: annotation.color
      },
      className: "rect"
    })));
  }

}

/* harmony default export */ var highlight = (highlight_Highlight);
// CONCATENATED MODULE: ./src/lib/coordinates.js


function coordinates_p2v(position, viewport) {
  if (position.rects) {
    return {
      pageIndex: position.pageIndex,
      rects: position.rects.map(rect => {
        let [x1, y2] = viewport.convertToViewportPoint(rect[0], rect[1]);
        let [x2, y1] = viewport.convertToViewportPoint(rect[2], rect[3]);
        return [Math.min(x1, x2), Math.min(y1, y2), Math.max(x1, x2), Math.max(y1, y2)];
      })
    };
  } else if (position.paths) {
    return {
      pageIndex: position.pageIndex,
      width: position.width * viewport.scale,
      paths: position.paths.map(path => {
        let vpath = [];

        for (let i = 0; i < path.length - 1; i += 2) {
          let x = path[i];
          let y = path[i + 1];
          vpath.push(...viewport.convertToViewportPoint(x, y));
        }

        return vpath;
      })
    };
  }
}
function coordinates_v2p(position, viewport) {
  return {
    pageIndex: position.pageIndex,
    rects: position.rects.map(rect => {
      let [x1, y2] = viewport.convertToPdfPoint(rect[0], rect[1]);
      let [x2, y1] = viewport.convertToPdfPoint(rect[2], rect[3]);
      return [Math.min(x1, x2), Math.min(y1, y2), Math.max(x1, x2), Math.max(y1, y2)];
    })
  };
}
function wx(rect) {
  return rect[2] - rect[0];
}
function hy(rect) {
  return rect[3] - rect[1];
}
// CONCATENATED MODULE: ./src/components/icons.js



function IconHighlight() {
  return /*#__PURE__*/external_React_default.a.createElement("svg", {
    width: "12",
    height: "12",
    viewBox: "0 0 12 12"
  }, /*#__PURE__*/external_React_default.a.createElement("path", {
    fill: "currentColor",
    d: "M12,5H0V3H12Zm0,1H0V8H12ZM9,9H0v2H9Zm3-9H3V2h9Z"
  }));
}
function IconNote() {
  return /*#__PURE__*/external_React_default.a.createElement("svg", {
    width: "12",
    height: "12",
    viewBox: "0 0 12 12"
  }, /*#__PURE__*/external_React_default.a.createElement("path", {
    fill: "currentColor",
    d: "M0,7H5v5ZM0,0V6H6v6h6V0Z"
  }));
}
function IconArea() {
  return /*#__PURE__*/external_React_default.a.createElement("svg", {
    width: "12",
    height: "12",
    viewBox: "0 0 12 12"
  }, /*#__PURE__*/external_React_default.a.createElement("path", {
    fill: "currentColor",
    d: "M2,7V2H7V7Zm8,2V7H9V9H7v1H9v2h1V10h2V9ZM1,1H9V6h1V0H0V10H6V9H1Z"
  }));
}
function IconInk() {
  return /*#__PURE__*/external_React_default.a.createElement("svg", {
    width: "12",
    height: "12",
    viewBox: "0 0 12 12"
  }, /*#__PURE__*/external_React_default.a.createElement("path", {
    strokeWidth: "1.8",
    strokeLinecap: "round",
    strokeLinejoin: "round",
    strokeMiterlimit: "4",
    stroke: "currentColor",
    fill: "none",
    d: "M 11.075423,10.940982 C 2.1007834,10.74643 3.2046232,-0.13478446 9,1.2287624 11.152259,2.2537259 10.06085,4.0872195 9,4.5910025 6.1497195,6 2.0752684,4.9659656 0.95896126,1.3633774"
  }));
}
function IconNoteLarge() {
  return /*#__PURE__*/external_React_default.a.createElement("svg", {
    width: "24",
    height: "24",
    viewBox: "0 0 24 24"
  }, /*#__PURE__*/external_React_default.a.createElement("polygon", {
    fill: "currentColor",
    points: "0.5 0.5 23.5 0.5 23.5 23.5 11.5 23.5 0.5 12.5 0.5 0.5"
  }), /*#__PURE__*/external_React_default.a.createElement("polygon", {
    points: "0.5 12.5 11.5 12.5 11.5 23.5 0.5 12.5",
    fill: "#fff",
    opacity: "0.4"
  }), /*#__PURE__*/external_React_default.a.createElement("path", {
    d: "M0,0V12.707L11.293,24H24V0ZM11,22.293,1.707,13H11ZM23,23H12V12H1V1H23Z"
  }));
}
function IconColor({
  color
}) {
  return /*#__PURE__*/external_React_default.a.createElement("svg", {
    width: "16",
    height: "16",
    viewBox: "0 0 16 16"
  }, /*#__PURE__*/external_React_default.a.createElement("rect", {
    shapeRendering: "geometricPrecision",
    fill: color,
    strokeWidth: "1",
    x: "2",
    y: "2",
    stroke: "rgba(0, 0, 0, 0.08)",
    width: "12",
    height: "12",
    rx: "3"
  }));
} // https://raw.githubusercontent.com/FortAwesome/Font-Awesome/6.x/svgs/solid/user.svg

function IconUser() {
  return /*#__PURE__*/external_React_default.a.createElement("svg", {
    width: "8",
    viewBox: "0 0 448 512"
  }, /*#__PURE__*/external_React_default.a.createElement("path", {
    fill: "currentColor",
    d: "M224 256c70.7 0 128-57.31 128-128s-57.3-128-128-128C153.3 0 96 57.31 96 128S153.3 256 224 256zM274.7 304H173.3C77.61 304 0 381.6 0 477.3c0 19.14 15.52 34.67 34.66 34.67h378.7C432.5 512 448 496.5 448 477.3C448 381.6 370.4 304 274.7 304z"
  }));
}
// CONCATENATED MODULE: ./src/components/note.js






const PADDING = 5;
const PADDING_LEFT = PADDING * 2 - 1;
const PADDING_TOP = PADDING * 2 - 1;

function Note({
  annotation,
  isSelected,
  enableMoving,
  onDragStart,
  onDragEnd,
  onChangePosition
}) {
  const draggableRef = Object(external_React_["useRef"])(null);
  let width = wx(annotation.position.rects[0]);
  let height = hy(annotation.position.rects[0]);
  const container = Object(external_React_["useRef"])();
  const viewerContainer = Object(external_React_["useRef"])(document.getElementById('viewerContainer'));
  const dragging = Object(external_React_["useRef"])(false);
  const visible = Object(external_React_["useRef"])();
  const pageRect = Object(external_React_["useRef"])();
  const boxRect = Object(external_React_["useRef"])();
  const cursorPoint = Object(external_React_["useRef"])();
  const handleDragLeaveCallback = Object(external_React_["useCallback"])(handleDragLeave, []);
  const handleDragOverCallback = Object(external_React_["useCallback"])(handleDragOver, []);
  const handleScrollCallback = Object(external_React_["useCallback"])(handleScroll, []);
  Object(external_React_["useLayoutEffect"])(() => {
    container.current = getDragContainer();
    window.addEventListener('dragleave', handleDragLeaveCallback);
    window.addEventListener('dragover', handleDragOverCallback);
    viewerContainer.current.addEventListener('scroll', handleScrollCallback);
    return () => {
      window.removeEventListener('dragleave', handleDragLeaveCallback);
      window.removeEventListener('dragover', handleDragOverCallback);
      viewerContainer.current.removeEventListener('scroll', handleScrollCallback);
      dragging.current = false;
      container.current.style.opacity = 0;
    };
  }, [handleDragLeaveCallback, handleDragOverCallback, handleScrollCallback, enableMoving]);

  function getDragContainer() {
    let page = document.querySelector('div.page[data-page-number="' + (annotation.position.pageIndex + 1) + '"]');
    let container = page.querySelector('.draggableNoteBox');

    if (!container) {
      container = document.createElement('div');
      container.className = 'draggableNoteBox';
      container.style.width = width + PADDING * 2 + 'px';
      container.style.height = height + PADDING * 2 + 'px';
      container.style.opacity = 0;
      page.insertBefore(container, page.firstChild);
    }

    return container;
  }

  function updatePage() {
    let page = document.querySelector('div.page[data-page-number="' + (annotation.position.pageIndex + 1) + '"]');
    let rect = page.getBoundingClientRect();
    pageRect.current = [rect.left, rect.top, rect.right, rect.bottom];
  }

  function handleScroll(event) {
    if (!dragging.current) return;
    updatePage();
  }

  function handleDragStart(event) {
    onDragStart(event);

    if (!enableMoving || annotation.readOnly) {
      return;
    }

    updatePage();
    cursorPoint.current = [event.offsetX, event.offsetY];
    let clientRect = draggableRef.current.getBoundingClientRect();
    boxRect.current = [0, 0, clientRect.width, clientRect.height];
    cursorPoint.current = [clientRect.width / 2, clientRect.height / 2]; // There is a Chrome anomaly - even though the drag event is already shoot,
    // disabling pointer events still cancels the drag event
    // TODO: Move this into annotator.js

    setTimeout(() => {
      if (dragging.current) {
        document.getElementById('viewer').classList.add('disable-pointer-events');
      }
    }, 0);
    updatePosition(event.clientX, event.clientY);
    dragging.current = true;
  }

  function handleDragEnd(event) {
    document.getElementById('viewer').classList.remove('disable-pointer-events');
    onDragEnd(); // This seems to only have an effect in Firefox

    let isCancelled = event.dataTransfer.dropEffect === 'none';

    if (!enableMoving) {
      return;
    }

    dragging.current = false;
    container.current.style.opacity = 0;

    if (visible.current && !isCancelled) {
      let rect = boxRect.current.slice();
      let left = rect[0] + PADDING;
      let top = rect[1] + PADDING;
      rect = [left, top, left + width, top + height];
      onChangePosition({ ...annotation.position,
        rects: [rect]
      });
    }
  }

  function handleDragLeave(event) {
    if (!dragging.current) return; // Delay the event to allow `dragend` shoot first

    setTimeout(() => {
      if (!dragging.current) return;
      visible.current = false;
      container.current.style.opacity = 0;
    }, 0);
  }

  function handleDragOver(event) {
    if (!dragging.current) return;
    updatePosition(event.clientX, event.clientY);
  }

  function updatePosition(clientX, clientY) {
    let x = clientX - pageRect.current[0] - cursorPoint.current[0] - PADDING_LEFT;
    let y = clientY - pageRect.current[1] - cursorPoint.current[1] - PADDING_TOP;
    if (x < 0) x = 0;
    if (y < 0) y = 0;

    if (x + wx(boxRect.current) > wx(pageRect.current) - PADDING_LEFT * 2) {
      x = wx(pageRect.current) - wx(boxRect.current) - PADDING_LEFT * 2;
    }

    if (y + hy(boxRect.current) > hy(pageRect.current) - PADDING_TOP * 2) {
      y = hy(pageRect.current) - hy(boxRect.current) - PADDING_TOP * 2;
    }

    boxRect.current = [x, y, x + wx(boxRect.current), y + hy(boxRect.current)];
    container.current.style.transform = 'translate(' + x + 'px,' + y + 'px)';
    visible.current = clientX >= pageRect.current[0] + PADDING_LEFT && clientX <= pageRect.current[2] - PADDING_LEFT;
    container.current.style.opacity = visible.current ? 1 : 0;
  }

  return /*#__PURE__*/external_React_default.a.createElement("div", {
    className: classnames_default()('note-annotation', {
      selected: isSelected
    }),
    style: {
      color: annotation.color,
      left: Math.round(annotation.position.rects[0][0]),
      top: Math.round(annotation.position.rects[0][1]),
      width: width,
      height: height
    }
  }, /*#__PURE__*/external_React_default.a.createElement(IconNoteLarge, null), /*#__PURE__*/external_React_default.a.createElement("div", {
    ref: draggableRef,
    className: "square",
    style: {
      left: -PADDING,
      top: -PADDING,
      width: width + PADDING * 2,
      height: height + PADDING * 2
    },
    draggable: true,
    onDragStart: handleDragStart,
    onDragEnd: handleDragEnd
  }));
}

/* harmony default export */ var components_note = (Note);
// CONCATENATED MODULE: ./src/components/area.js





const area_PADDING_LEFT = 9;
const area_PADDING_TOP = 9;
const MIN_WIDTH = 20;
const MIN_HEIGHT = 20;

function Area({
  annotation,
  move,
  isSelected,
  onResizeStart,
  onDragStart,
  onDragEnd,
  onChangePosition
}) {
  const [resizingRect, setResizingRect] = Object(external_React_["useState"])();
  const draggableRef = Object(external_React_["useRef"])();
  const resizingDirections = Object(external_React_["useRef"])();
  const container = Object(external_React_["useRef"])(document.querySelector('div.page[data-page-number="' + (annotation.position.pageIndex + 1) + '"]')); // TODO: Fix `annotation` triggering useEffect on each render

  const handlePointerMoveCallback = Object(external_React_["useCallback"])(handlePointerMove, [annotation]);
  const handlePointerUpCallback = Object(external_React_["useCallback"])(handlePointerUp, [annotation]);
  const handleKeyDownCallback = Object(external_React_["useCallback"])(handleKeyDown, []);
  Object(external_React_["useEffect"])(() => {
    window.addEventListener('mousemove', handlePointerMoveCallback);
    window.addEventListener('mouseup', handlePointerUpCallback);
    document.getElementById('viewerContainer').addEventListener('keydown', handleKeyDownCallback);
    return () => {
      window.removeEventListener('mousemove', handlePointerMoveCallback);
      window.removeEventListener('mouseup', handlePointerUpCallback);
      document.getElementById('viewerContainer').removeEventListener('keydown', handleKeyDownCallback);
    };
  }, [handlePointerMoveCallback, handlePointerUpCallback, handleKeyDownCallback]);

  function getResizedRect(rect, clientX, clientY) {
    let clientRect = container.current.getBoundingClientRect();
    let pageWidth = clientRect.width;
    let pageHeight = clientRect.height;
    let x = clientX - clientRect.left - area_PADDING_LEFT;
    let y = clientY - clientRect.top - area_PADDING_TOP;
    rect = rect.slice();
    let scale = PDFViewerApplication.pdfViewer._currentScale;

    if (resizingDirections.current.includes('left')) {
      rect[0] = x > rect[2] - MIN_WIDTH * scale && rect[2] - MIN_WIDTH * scale || x > 0 && x || 0;
    } else if (resizingDirections.current.includes('right')) {
      rect[2] = x < rect[0] + MIN_WIDTH * scale && rect[0] + MIN_WIDTH * scale || x < pageWidth - area_PADDING_LEFT * 2 && x || pageWidth - area_PADDING_LEFT * 2;
    }

    if (resizingDirections.current.includes('top')) {
      rect[1] = y > rect[3] - MIN_HEIGHT * scale && rect[3] - MIN_HEIGHT * scale || y > 0 && y || 0;
    } else if (resizingDirections.current.includes('bottom')) {
      rect[3] = y < rect[1] + MIN_HEIGHT * scale && rect[1] + MIN_HEIGHT * scale || y < pageHeight - area_PADDING_TOP * 2 && y || pageHeight - area_PADDING_TOP * 2;
    }

    return rect;
  }

  function handleResizeStart(directions) {
    resizingDirections.current = directions;
    onResizeStart();
  }

  function handlePointerMove(event) {
    if (!resizingDirections.current) return;
    let rect = getResizedRect(annotation.position.rects[0], event.clientX, event.clientY);
    setResizingRect(rect);
  }

  function handlePointerUp(event) {
    if (!resizingDirections.current) return;
    let rect = getResizedRect(annotation.position.rects[0], event.clientX, event.clientY);
    onChangePosition({ ...annotation.position,
      rects: [rect]
    });
    resizingDirections.current = null;
    setResizingRect();
  }

  function handleKeyDown(event) {
    if (!resizingDirections.current) {
      return;
    }

    if (event.key === 'Escape') {
      resizingDirections.current = null;
      setResizingRect();
    }
  }

  let rect = resizingRect || annotation.position.rects[0];
  return /*#__PURE__*/external_React_default.a.createElement(external_React_["Fragment"], null, /*#__PURE__*/external_React_default.a.createElement("div", {
    ref: draggableRef // draggable={true}
    ,
    className: classnames_default()('area-annotation', {
      selected: isSelected,
      comment: !!annotation.comment
    }),
    style: {
      borderColor: annotation.color,
      left: Math.round(rect[0]),
      top: Math.round(rect[1]),
      width: wx(rect),
      height: hy(rect)
    } // onDragStart={onDragStart}
    // onDragEnd={onDragEnd}

  }, !annotation.readOnly && /*#__PURE__*/external_React_default.a.createElement("div", {
    className: "resizer",
    onMouseDown: event => event.preventDefault()
  }, /*#__PURE__*/external_React_default.a.createElement("div", {
    className: "line top",
    onMouseDown: event => handleResizeStart(['top'])
  }), /*#__PURE__*/external_React_default.a.createElement("div", {
    className: "line right",
    onMouseDown: event => handleResizeStart(['right'])
  }), /*#__PURE__*/external_React_default.a.createElement("div", {
    className: "line bottom",
    onMouseDown: event => handleResizeStart(['bottom'])
  }), /*#__PURE__*/external_React_default.a.createElement("div", {
    className: "line left",
    onMouseDown: event => handleResizeStart(['left'])
  }), /*#__PURE__*/external_React_default.a.createElement("div", {
    className: "edge top-right",
    onMouseDown: event => handleResizeStart(['top', 'right'])
  }), /*#__PURE__*/external_React_default.a.createElement("div", {
    className: "edge bottom-right",
    onMouseDown: event => handleResizeStart(['bottom', 'right'])
  }), /*#__PURE__*/external_React_default.a.createElement("div", {
    className: "edge bottom-left",
    onMouseDown: event => handleResizeStart(['bottom', 'left'])
  }), /*#__PURE__*/external_React_default.a.createElement("div", {
    className: "edge top-left",
    onMouseDown: event => handleResizeStart(['top', 'left'])
  }))));
}

/* harmony default export */ var components_area = (Area);
// CONCATENATED MODULE: ./src/lib/utilities.js


function isMac() {
  return !!navigator && /Mac/.test(navigator.platform);
}
function isLinux() {
  return !!navigator && /Linux/.test(navigator.platform);
}
function isWin() {
  return !!navigator && /Win/.test(navigator.platform);
}
function copyToClipboard(str) {
  let el = document.createElement('textarea');
  el.value = str;
  document.body.appendChild(el);
  el.select();
  document.execCommand('copy');
  document.body.removeChild(el);
}
function deselect() {
  let selection = window.getSelection ? window.getSelection() : document.selection ? document.selection : null;
  if (selection) selection.empty ? selection.empty() : selection.removeAllRanges();
}
function getClientRects(range, containerEl) {
  let clientRects = Array.from(range.getClientRects());
  let offset = containerEl.getBoundingClientRect();
  let rects = clientRects.map(rect => {
    return {
      top: rect.top + containerEl.scrollTop - offset.top - 10,
      left: rect.left + containerEl.scrollLeft - offset.left - 9,
      width: rect.width,
      height: rect.height
    };
  });
  rects = rects.map(rect => {
    return [rect.left, rect.top, rect.left + rect.width, rect.top + rect.height];
  });
  return rects;
} // https://github.com/jashkenas/underscore/blob/master/underscore.js
// (c) 2009-2018 Jeremy Ashkenas, DocumentCloud and Investigative Reporters & Editors
// Underscore may be freely distributed under the MIT license.
// Returns a function, that, when invoked, will only be triggered at most once
// during a given window of time. Normally, the throttled function will run
// as much as it can, without ever going more than once per `wait` duration;
// but if you'd like to disable the execution on the leading edge, pass
// `{leading: false}`. To disable execution on the trailing edge, ditto.

function throttle(func, wait, options) {
  var context, args, result;
  var timeout = null;
  var previous = 0;
  if (!options) options = {};

  var later = function () {
    previous = options.leading === false ? 0 : Date.now();
    timeout = null;
    result = func.apply(context, args);
    if (!timeout) context = args = null;
  };

  return function () {
    var now = Date.now();
    if (!previous && options.leading === false) previous = now;
    var remaining = wait - (now - previous);
    context = this;
    args = arguments;

    if (remaining <= 0 || remaining > wait) {
      if (timeout) {
        clearTimeout(timeout);
        timeout = null;
      }

      previous = now;
      result = func.apply(context, args);
      if (!timeout) context = args = null;
    } else if (!timeout && options.trailing !== false) {
      timeout = setTimeout(later, remaining);
    }

    return result;
  };
}
function setCaretToEnd(target) {
  const range = document.createRange();
  const sel = window.getSelection();
  range.selectNodeContents(target);
  range.collapse(false);
  sel.removeAllRanges();
  sel.addRange(range);
  target.focus();
  range.detach();
}
function clearSelection() {
  let selection = window.getSelection ? window.getSelection() : document.selection ? document.selection : null;
  if (selection) selection.empty ? selection.empty() : selection.removeAllRanges();
}
function getPageFromElement(target) {
  let node = target.closest('#viewer > .page') || target.closest('#viewer > .spread > .page');

  if (!node) {
    return null;
  }

  let number = parseInt(node.dataset.pageNumber);
  return {
    node,
    number
  };
}
function fitRectIntoRect(rect, containingRect) {
  return [Math.max(rect[0], containingRect[0]), Math.max(rect[1], containingRect[1]), Math.min(rect[2], containingRect[2]), Math.min(rect[3], containingRect[3])];
}
function findOrCreateContainerLayer(container, className) {
  let layer = container.querySelector('.' + className);

  if (!layer) {
    layer = document.createElement('div');
    layer.className = className;
    container.appendChild(layer);
  }

  return layer;
}
function pointerEventToPosition(event) {
  let page = getPageFromElement(event.target);

  if (!page) {
    return null;
  }

  let rect = page.node.getBoundingClientRect();
  let x = event.clientX + page.node.scrollLeft - rect.left - 9;
  let y = event.clientY + page.node.scrollTop - rect.top - 10;
  return {
    pageIndex: page.number - 1,
    rects: [[x, y, x, y]]
  };
}
function getPositionBoundingRect(position) {
  if (position.rects) {
    return [Math.min(...position.rects.map(x => x[0])), Math.min(...position.rects.map(x => x[1])), Math.max(...position.rects.map(x => x[2])), Math.max(...position.rects.map(x => x[3]))];
  } else if (position.paths) {
    let x = position.paths[0][0];
    let y = position.paths[0][1];
    let rect = [x, y, x, y];

    for (let path of position.paths) {
      for (let i = 0; i < path.length - 1; i += 2) {
        let x = path[i];
        let y = path[i + 1];
        rect[0] = Math.min(rect[0], x);
        rect[1] = Math.min(rect[1], y);
        rect[2] = Math.max(rect[2], x);
        rect[3] = Math.max(rect[3], y);
      }
    }

    return rect;
  }
}
function positionsEqual(p1, p2) {
  if (Array.isArray(p1.rects) !== Array.isArray(p2.rects) || Array.isArray(p1.paths) !== Array.isArray(p2.paths)) {
    return false;
  }

  if (p1.pageIndex !== p2.pageIndex) {
    return false;
  }

  if (p1.rects) {
    return JSON.stringify(p1.rects) === JSON.stringify(p2.rects);
  } else if (p1.paths) {
    return JSON.stringify(p1.paths) === JSON.stringify(p2.paths);
  }

  return false;
}
function intersectAnnotationWithPoint(selectionPosition, pointPosition) {
  if (selectionPosition.pageIndex !== pointPosition.pageIndex) {
    return false;
  }

  let [x, y] = pointPosition.rects[0];

  if (selectionPosition.rects) {
    for (let i = 0; i < selectionPosition.rects.length; i++) {
      let [r1, r2] = selectionPosition.rects.slice(i, i + 2);

      if (!(x > r1[2] || x < r1[0] || y > r1[3] || y < r1[1])) {
        return true;
      }

      if (!r2) {
        continue;
      }

      if (x > r1[0] && x > r2[0] && x < r1[2] && x < r2[2] && y < r1[3] && y > r2[1] && r1[1] - r2[3] < Math.min(r1[3] - r1[1], r2[3] - r2[1])) {
        return true;
      }
    }
  } else if (selectionPosition.paths) {
    let maxDistance = Math.max(7, selectionPosition.width);

    for (let path of selectionPosition.paths) {
      for (let i = 0; i < path.length - 1; i += 2) {
        let ax = path[i];
        let ay = path[i + 1];

        if (Math.hypot(ax - x, ay - y) < maxDistance) {
          return true;
        }
      }
    }
  }

  return false;
}

/**
 * Synchronously sets ref value and asynchronously sets state value
 * @param initialValue
 * @returns {[]}
 */

function useRefState(initialValue) {
  const [state, setState] = Object(external_React_["useState"])(initialValue);
  const stateRef = Object(external_React_["useRef"])(state);

  function _setState(value) {
    stateRef.current = value;
    setState(value);
  }

  return [state, stateRef, _setState];
}
function getAnnotationsFromSelectionRanges(selectionRanges) {
  let annotations = [];

  for (let selectionRange of selectionRanges) {
    let pageIndex = selectionRange.position.pageIndex;
    annotations.push({
      type: 'highlight',
      fromText: true,
      text: selectionRange.text,
      position: selectionRange.position,
      pageLabel: window.extractor.getCachedPageLabel(pageIndex) || '-'
    });
  }

  return annotations;
}
function getImageDataURL(img) {
  var canvas = document.createElement('canvas');
  canvas.width = img.naturalWidth;
  canvas.height = img.naturalHeight;
  var ctx = canvas.getContext('2d');
  ctx.drawImage(img, 0, 0, img.naturalWidth, img.naturalHeight);
  return canvas.toDataURL('image/png');
}
function setDataTransferAnnotations(dataTransfer, annotations) {
  let text = annotations.map(annotation => {
    let formatted = '';

    if (annotation.text) {
      let text = annotation.text.trim();

      if (annotation.fromText) {
        formatted = text;
      } else {
        formatted = '“' + text + '”';
      }
    }

    let comment = annotation.comment && annotation.comment.trim();

    if (comment) {
      if (formatted) {
        formatted += comment.includes('\n') ? '\n' : ' ';
      }

      formatted += comment;
    }

    return formatted;
  }).filter(x => x).join('\n\n');
  let fromText = annotations.some(x => x.fromText);
  annotations = annotations.map(({
    id,
    type,
    text,
    color,
    comment,
    image,
    position,
    pageLabel,
    tags
  }) => {
    if (image) {
      let img = document.querySelector(`[data-sidebar-annotation-id="${id}"] img`);

      if (img) {
        image = getImageDataURL(img);
      }
    }

    return {
      id,
      type,
      attachmentItemID: window.itemID,
      text: text ? text.trim() : text,
      color,
      comment: comment ? comment.trim() : comment,
      image,
      position,
      pageLabel,
      tags
    };
  }); // Clear image data set on some untested type (when drag is initiated on img),
  // which also prevents word processors from using `text/plain`, and
  // results to dumped base64 content (LibreOffice) or image (Google Docs)

  dataTransfer.clearData();
  dataTransfer.setData('zotero/annotation', JSON.stringify(annotations)); // Don't use Note translators if copying text from a PDF page

  if (fromText) {
    dataTransfer.setData('text/plain', text);
  } else {
    zoteroSetDataTransferAnnotations(dataTransfer, annotations);
  }
}
// CONCATENATED MODULE: ./src/components/area-selector.js




const area_selector_PADDING_LEFT = 9;
const area_selector_PADDING_TOP = 9;
const area_selector_MIN_WIDTH = 20;
const area_selector_MIN_HEIGHT = 20;

function pointsToRect(startPoint, endPoint) {
  let left = Math.min(endPoint[0], startPoint[0]);
  let top = Math.min(endPoint[1], startPoint[1]);
  let right = left + Math.abs(endPoint[0] - startPoint[0]);
  let bottom = top + Math.abs(endPoint[1] - startPoint[1]);
  return [left, top, right, bottom];
}

function getPageRestrictedPoint(point, pageRect) {
  return [point[0] < pageRect[0] && pageRect[0] || point[0] > pageRect[2] && pageRect[2] || point[0], point[1] < pageRect[1] && pageRect[1] || point[1] > pageRect[3] && pageRect[3] || point[1]];
} //{ color, shouldStart, onSelection }
// TODO: Consider to move area selection logic into annotator.js and just use react for rendering


function AreaSelector(props) {
  const [areaStyle, setAreaStyle] = Object(external_React_["useState"])(null);
  const container = Object(external_React_["useRef"])(document.getElementById('viewerContainer'));
  const startPoint = Object(external_React_["useRef"])(null);
  const endPoint = Object(external_React_["useRef"])(null);
  const pageRect = Object(external_React_["useRef"])(null);
  const pageIndex = Object(external_React_["useRef"])(null);
  const scrollTimeout = Object(external_React_["useRef"])(null);
  const isSelectionStartCalled = Object(external_React_["useRef"])(false);
  const handlePointerDownCallback = Object(external_React_["useCallback"])(handlePointerDown, [props.shouldStart]);
  const handlePointerMoveCallback = Object(external_React_["useCallback"])(handlePointerMove, []);
  const handlePointerUpCallback = Object(external_React_["useCallback"])(handlePointerUp, []);
  const handleKeyDownCallback = Object(external_React_["useCallback"])(handleKeyDown, []);
  Object(external_React_["useEffect"])(() => {
    container.current.addEventListener('mousedown', handlePointerDownCallback);
    window.addEventListener('mousemove', handlePointerMoveCallback);
    window.addEventListener('mouseup', handlePointerUpCallback);
    document.getElementById('viewerContainer').addEventListener('keydown', handleKeyDownCallback);
    return () => {
      container.current.removeEventListener('mousedown', handlePointerDownCallback);
      window.removeEventListener('mousemove', handlePointerMoveCallback);
      window.removeEventListener('mouseup', handlePointerUpCallback);
      document.getElementById('viewerContainer').removeEventListener('keydown', handleKeyDownCallback);
    };
  }, [handlePointerDownCallback, handlePointerMoveCallback, handlePointerUpCallback, handleKeyDownCallback]);

  const clientToContainerPoint = (clientX, clientY) => {
    let containerBoundingRect = container.current.getBoundingClientRect(); // Scrollbar width in RTL mode

    let viewerLeft = document.getElementById('viewer').offsetLeft;
    return [clientX - containerBoundingRect.left + container.current.scrollLeft - viewerLeft, clientY - containerBoundingRect.top + container.current.scrollTop];
  };

  function reset() {
    window.cancelAnimationFrame(scrollTimeout.current);
    startPoint.current = null;
    isSelectionStartCalled.current = false;
    setAreaStyle(null);
  }

  function scroll(x, y) {
    let br = container.current.getBoundingClientRect();
    let scrolled = false;
    let v = null;
    let h = null;

    if (y < br.y && pageRect.current[1] < container.current.scrollTop) {
      v = 'top';
    } else if (y > br.y + br.height && pageRect.current[3] > container.current.scrollTop + document.body.offsetHeight) {
      v = 'bottom';
    }

    if (x < br.x && pageRect.current[0] < container.current.scrollLeft) {
      h = 'left';
    } else if (x > br.x + br.width && pageRect.current[2] > container.current.scrollLeft + container.current.offsetWidth) {
      h = 'right';
    }

    if (v === 'top') {
      container.current.scrollTop -= 1;
      scrolled = true;
    } else if (v === 'bottom') {
      container.current.scrollTop += 1;
      scrolled = true;
    }

    if (h === 'left') {
      container.current.scrollLeft -= 1;
      scrolled = true;
    } else if (h === 'right') {
      container.current.scrollLeft += 1;
      scrolled = true;
    }

    if (scrolled) {
      scrollTimeout.current = window.requestAnimationFrame(() => {
        scroll(x, y);
      });
    }
  }

  function handlePointerMove(event) {
    if (!startPoint.current) {
      return;
    }

    deselect();
    window.cancelAnimationFrame(scrollTimeout.current);
    scroll(event.clientX, event.clientY);
    let point = clientToContainerPoint(event.clientX, event.clientY);
    endPoint.current = getPageRestrictedPoint(point, pageRect.current);
    let rect = pointsToRect(startPoint.current, endPoint.current);
    setAreaStyle({
      left: rect[0],
      top: rect[1],
      width: rect[2] - rect[0],
      height: rect[3] - rect[1]
    });

    if (!isSelectionStartCalled.current) {
      isSelectionStartCalled.current = true;
      props.onSelectionStart();
    }
  }

  function handlePointerDown(event) {
    let isLeft = event.button === 0;

    if (!isLeft || !props.shouldStart) {
      return;
    }

    window.cancelAnimationFrame(scrollTimeout.current);
    let page = getPageFromElement(event.target);
    if (!page) return;
    let {
      node,
      number
    } = page; // Sidebar width in RTL mode

    let viewerLeft = document.getElementById('viewer').offsetLeft;
    pageRect.current = [node.offsetLeft + area_selector_PADDING_LEFT - viewerLeft, node.offsetTop + area_selector_PADDING_TOP, node.offsetLeft + node.offsetWidth - area_selector_PADDING_LEFT - viewerLeft, node.offsetTop + node.offsetHeight - area_selector_PADDING_TOP];
    let point = clientToContainerPoint(event.clientX, event.clientY);
    let restrictedStartPoint = getPageRestrictedPoint(point, pageRect.current);

    if (JSON.stringify(point) !== JSON.stringify(restrictedStartPoint)) {
      return;
    }

    startPoint.current = point;
    pageIndex.current = number - 1;
  }

  function handlePointerUp(event) {
    if (!startPoint.current) return;
    let endPoint = clientToContainerPoint(event.clientX, event.clientY);
    endPoint = getPageRestrictedPoint(endPoint, pageRect.current);
    let areaRect = pointsToRect(startPoint.current, endPoint);
    let scale = PDFViewerApplication.pdfViewer._currentScale; // If area size is more than zero

    if (Math.abs(areaRect[0] - areaRect[2]) * scale >= area_selector_MIN_WIDTH && Math.abs(areaRect[1] - areaRect[3]) * scale >= area_selector_MIN_HEIGHT) {
      let position = {
        rects: [[areaRect[0] - pageRect.current[0], areaRect[1] - pageRect.current[1], areaRect[2] - pageRect.current[0], areaRect[3] - pageRect.current[1]]],
        pageIndex: pageIndex.current
      };
      props.onSelection(position);
    }

    reset();
  }

  function handleKeyDown(event) {
    if (!startPoint.current) {
      return;
    }

    if (event.key === 'Escape') {
      reset();
    }
  }

  if (!areaStyle) return null;
  return /*#__PURE__*/external_React_default.a.createElement("div", {
    className: "area-selector",
    style: { ...areaStyle,
      borderColor: props.color
    }
  });
}

/* harmony default export */ var area_selector = (AreaSelector);
// CONCATENATED MODULE: ./src/lib/colors.js


let annotationColors = [['general.yellow', '#ffd400'], ['general.red', '#ff6666'], ['general.green', '#5fb236'], ['general.blue', '#2ea8e5'], ['general.purple', '#a28ae5']];
let selectionColor = navigator.platform.includes('Mac') ? '#71ADFD' : 'Highlight';
// CONCATENATED MODULE: ./src/components/selection-menu.js






function SelectionMenu(props) {
  const intl = Object(external_ReactIntl_["useIntl"])();

  function handleColorPick(color) {
    props.onHighlight(color);
  }

  return /*#__PURE__*/external_React_default.a.createElement("div", {
    id: "selection-menu",
    className: "selection-menu"
  }, /*#__PURE__*/external_React_default.a.createElement("div", {
    className: "colors"
  }, annotationColors.map((color, index) => /*#__PURE__*/external_React_default.a.createElement("button", {
    key: index,
    tabIndex: -1,
    className: "toolbarButton global-color",
    style: {
      color: color[1]
    },
    title: intl.formatMessage({
      id: color[0]
    }),
    onClick: () => handleColorPick(color[1])
  }))), props.enableAddToNote && /*#__PURE__*/external_React_default.a.createElement("div", {
    className: "wide-button",
    onClick: props.onAddToNote
  }, /*#__PURE__*/external_React_default.a.createElement(external_ReactIntl_["FormattedMessage"], {
    id: "pdfReader.addToNote"
  })));
}

/* harmony default export */ var selection_menu = (SelectionMenu);
// CONCATENATED MODULE: ./src/components/page-popup.js







function PagePopup({
  id,
  position,
  updateOnPositionChange,
  className,
  children
}) {
  const [popupPosition, setPopupPosition] = Object(external_React_["useState"])(null);
  const [update, setUpdate] = Object(external_React_["useState"])();
  const containerRef = Object(external_React_["useRef"])();
  Object(external_React_["useEffect"])(() => {
    setUpdate({});
  }, [id]);
  Object(external_React_["useEffect"])(() => {
    if (updateOnPositionChange) {
      setUpdate({});
    }
  }, [position]);
  Object(external_React_["useLayoutEffect"])(() => {
    if (update) {
      updatePopupPosition();
    }
  }, [update]);

  function getContainer() {
    let popupContainer = document.getElementById('pagePopupContainer');

    if (!popupContainer) {
      let viewerContainer = document.getElementById('viewerContainer');
      if (!viewerContainer) return;
      popupContainer = document.createElement('div');
      popupContainer.className = 'page-popup-container';
      popupContainer.dir = document.documentElement.dir;
      popupContainer.id = 'pagePopupContainer';
      viewerContainer.insertBefore(popupContainer, viewerContainer.firstChild);
    }

    return popupContainer;
  }

  function updatePopupPosition() {
    let dimensions = {
      width: containerRef.current.offsetWidth,
      height: containerRef.current.offsetHeight
    };
    let annotationPosition = position;
    let node = PDFViewerApplication.pdfViewer.getPageView(annotationPosition.pageIndex).div;
    let left;
    let top;
    let rectMax = getPositionBoundingRect(annotationPosition);
    let viewerScrollLeft = PDFViewerApplication.pdfViewer.container.scrollLeft;
    let viewerScrollTop = PDFViewerApplication.pdfViewer.container.scrollTop;
    let viewerWidth = PDFViewerApplication.pdfViewer.container.offsetWidth;
    let viewerHeight = PDFViewerApplication.pdfViewer.container.offsetHeight;
    let visibleRect = [viewerScrollLeft, viewerScrollTop, viewerScrollLeft + viewerWidth, viewerScrollTop + viewerHeight]; // Sidebar width in RTL mode

    let viewerLeft = document.getElementById('viewer').offsetLeft;
    let annotationCenterLeft = node.offsetLeft + 9 - viewerLeft + rectMax[0] + (rectMax[2] - rectMax[0]) / 2;
    left = annotationCenterLeft - dimensions.width / 2;
    let isTop = true;

    if (node.offsetTop + 10 + rectMax[3] + 20 + dimensions.height <= visibleRect[3]) {
      top = node.offsetTop + 10 + rectMax[3] + 20;
      isTop = false;
    } else if (node.offsetTop + 10 + rectMax[1] - visibleRect[1] > dimensions.height) {
      top = node.offsetTop + 10 + rectMax[1] - dimensions.height - 20;
    } else {
      top = visibleRect[3] - dimensions.height;
    }

    setPopupPosition({
      top,
      left,
      isTop
    });
  }

  let topBottom = {};

  if (popupPosition) {
    topBottom['page-popup-' + (popupPosition.isTop ? 'top' : 'bottom')] = true;
  }

  return /*#__PURE__*/external_ReactDOM_default.a.createPortal( /*#__PURE__*/external_React_default.a.createElement("div", {
    ref: containerRef,
    className: classnames_default()('page-popup', className, { ...topBottom
    }),
    style: popupPosition && { ...popupPosition
    }
  }, children), getContainer());
}

/* harmony default export */ var page_popup = (PagePopup);
// CONCATENATED MODULE: ./src/components/editor.js




 // TODO: Avoid resetting cursor and losing the recently typed text
//  when a new annotation is synced

const supportedFormats = ['i', 'b', 'sub', 'sup'];
const multiline = true;

function getFormatter(str) {
  let results = supportedFormats.map(format => str.toLowerCase().indexOf('<' + format + '>'));
  results = results.map((offset, idx) => [supportedFormats[idx], offset]);
  results.sort((a, b) => a[1] - b[1]);

  for (let result of results) {
    let format = result[0];
    let offset = result[1];
    if (offset < 0) continue;
    let lastIndex = str.toLowerCase().indexOf('</' + format + '>', offset);

    if (lastIndex >= 0) {
      let parts = [];
      parts.push(str.slice(0, offset));
      parts.push(str.slice(offset + format.length + 2, lastIndex));
      parts.push(str.slice(lastIndex + format.length + 3));
      return {
        format,
        parts
      };
    }
  }

  return null;
}

function walkFormat(parent) {
  let child = parent.firstChild;

  while (child) {
    if (child.nodeType === 3) {
      let text = child.nodeValue;
      let formatter = getFormatter(text);

      if (formatter) {
        let nodes = [];
        nodes.push(document.createTextNode(formatter.parts[0]));
        let midNode = document.createElement(formatter.format);
        midNode.appendChild(document.createTextNode(formatter.parts[1]));
        nodes.push(midNode);
        nodes.push(document.createTextNode(formatter.parts[2]));
        child.replaceWith(...nodes);
        child = midNode;
      }
    }

    walkFormat(child);
    child = child.nextSibling;
  }
}

function walkUnformat(parent) {
  let child = parent.firstChild;

  while (child) {
    let name = child.nodeName.toLowerCase();

    if (child.nodeType === 1 && supportedFormats.includes(name)) {
      if (child.innerText.trim().length) {
        let all = [];
        all.push(document.createTextNode('<' + name + '>'));
        all.push(...child.childNodes);
        all.push(document.createTextNode('</' + name + '>'));
        child.replaceWith(...all);
        child = all[0];
      }
    } // Unwrap <div><br></div> and some <div>...</div> to avoid doubled line breaks in innerText


    if (child.nodeName === 'DIV' && (child.firstChild && child.firstChild.nodeName === 'BR' || child.nodeName === 'DIV' && child.nextSibling && child.nextSibling.nodeName === 'DIV' && child.nextSibling.firstChild && child.nextSibling.firstChild.nodeName === 'BR')) {
      let firstNode = child.firstChild;
      child.replaceWith(...child.childNodes);
      child = firstNode;
    }

    walkUnformat(child);
    child = child.nextSibling;
  }
}

function clean(parent) {
  let map = {
    strong: 'b'
  };
  let child = parent.firstChild;

  while (child) {
    if (child.nodeType === 1) {
      for (let el in map) {
        if (child.nodeName.toLowerCase() === el) {
          let children = child.childNodes;
          let aa = document.createElement(map[el]);
          aa.append(...children);
          child.replaceWith(aa);
          child = aa;
          continue;
        }
      }

      let multilineFormats = multiline ? ['br', 'div'] : [];

      if (!supportedFormats.concat(multilineFormats).includes(child.nodeName.toLowerCase())) {
        let first = child.firstChild;
        let next = child.nextSibling;
        child.replaceWith(...child.childNodes);

        if (first) {
          child = first;
        } else {
          child = next;
        }

        continue;
      } else {
        while (child.attributes.length > 0) {
          child.removeAttribute(child.attributes[0].name);
        }
      }
    } else if (child.nodeType === 3) {// Keep the text
    } else {
      parent.removeChild(child);
    }

    clean(child);
    child = child.nextSibling;
  }
}

var actions = [{
  icon: '<b>B</b>',
  title: 'Bold',
  command: 'bold'
}, {
  icon: '<i>I</i>',
  title: 'Italic',
  command: 'italic'
}, {
  icon: 'X<sub>2</sub>',
  title: 'Subscript',
  command: 'subscript'
}, {
  icon: 'X<sup>2</sup>',
  title: 'Superscript',
  command: 'superscript'
}, {
  icon: 'T<sub>x</sub>',
  title: 'Remove Format',
  command: 'removeformat'
}];

class editor_BubbleButton extends external_React_default.a.Component {
  constructor(...args) {
    super(...args);

    defineProperty_default()(this, "handleClick", event => {
      event.preventDefault();
      this.props.onCommand(this.props.action.command);
    });
  }

  render() {
    return /*#__PURE__*/external_React_default.a.createElement("button", {
      className: classnames_default()('button', 'icon-' + this.props.action.command),
      dangerouslySetInnerHTML: {
        __html: this.props.action.icon
      },
      onPointerDown: this.handleClick
    });
  }

}

class editor_Bubble extends external_React_default.a.Component {
  render() {
    return /*#__PURE__*/external_React_default.a.createElement("div", {
      className: "bubble",
      style: {
        top: this.props.top
      }
    }, actions.map((action, idx) => /*#__PURE__*/external_React_default.a.createElement(editor_BubbleButton, {
      key: idx,
      action: action,
      onCommand: this.props.onCommand
    })));
  }

}

class editor_Content extends external_React_default.a.Component {
  constructor(props) {
    super(props);

    defineProperty_default()(this, "currentText", null);

    defineProperty_default()(this, "onSelectionChange", () => {
      let {
        innerRef
      } = this.props;
      let selection = window.getSelection();
      let node = selection.anchorNode;
      let isSelected = false; // Using try … catch to avoid `Error: Permission denied to access property "nodeType"`

      try {
        isSelected = !selection.isCollapsed && innerRef.current.contains(node.nodeType === Node.TEXT_NODE ? node.parentNode : node);
      } catch (e) {}

      this.props.onSelectionChange(isSelected);
    });

    defineProperty_default()(this, "handleChange", html => {
      this.refs.renderer.innerHTML = html;
      walkUnformat(this.refs.renderer);
      let text = this.refs.renderer.innerText;
      text = text.replace(/\n<\//g, '<\/');
      text = text.trim();
      this.currentText = text;
      this.props.onChange(text);
    });
  }

  componentDidMount() {
    document.addEventListener('selectionchange', this.onSelectionChange);
    this.props.innerRef.current.innerText = this.props.text;
    walkFormat(this.props.innerRef.current);
    this.currentText = this.props.text;
  }

  componentWillUnmount() {
    document.removeEventListener('selectionchange', this.onSelectionChange);
  }

  componentDidUpdate(prevProps) {
    if (this.props.id !== prevProps.id || this.currentText !== prevProps.text) {
      this.props.innerRef.current.innerText = this.props.text;
      walkFormat(this.props.innerRef.current);
      this.currentText = this.props.text;
    }
  }

  shouldComponentUpdate(nextProps) {
    if (this.props.id !== nextProps.id || this.currentText !== nextProps.text || this.props.isReadOnly !== nextProps.isReadOnly) {
      return true;
    }

    return false;
  }

  clearSelection() {
    let selection = window.getSelection ? window.getSelection() : document.selection ? document.selection : null;
    if (selection) selection.empty ? selection.empty() : selection.removeAllRanges();
  }

  render() {
    let {
      plainTextOnly,
      text,
      placeholder,
      onChange,
      innerRef,
      onBlur
    } = this.props;
    return /*#__PURE__*/external_React_default.a.createElement(external_React_default.a.Fragment, null, /*#__PURE__*/external_React_default.a.createElement("div", {
      ref: innerRef,
      suppressContentEditableWarning: true,
      className: "content",
      contentEditable: !this.props.isReadOnly,
      dir: "auto",
      onInput: () => {
        clean(innerRef.current);
        this.handleChange(innerRef.current.innerHTML);
      },
      placeholder: placeholder,
      onKeyDown: event => {
        event.stopPropagation();

        if (event.key === 'Escape') {
          this.clearSelection();
          innerRef.current.blur();
          this.props.onBlur();
        }
      },
      onScroll: this.props.onScroll
    }), /*#__PURE__*/external_React_default.a.createElement("div", {
      className: "renderer",
      ref: "renderer"
    }));
  }

}

class editor_Editor extends external_React_default.a.Component {
  constructor(props) {
    super(props);

    defineProperty_default()(this, "contentRef", /*#__PURE__*/external_React_default.a.createRef());

    defineProperty_default()(this, "state", {
      isSelected: false,
      bubbleTop: null
    });

    defineProperty_default()(this, "handleSelection", () => {
      if (!this._isMounted) return;
      let top = this.getSelectionTop();

      if (this.state.bubbleTop !== top) {
        this.setState({
          bubbleTop: top
        });
      }
    });

    defineProperty_default()(this, "handleScroll", () => {
      this.setState({
        bubbleTop: this.getSelectionTop()
      });
    });

    defineProperty_default()(this, "handleBalloonCommand", command => {
      this.contentRef.current.focus();
      document.execCommand(command, false, null);
    });
  }

  componentDidMount() {
    this._isMounted = true;
  }

  componentWillUnmount() {
    this._isMounted = false;
  }

  getSelectionTop() {
    let selection = window.getSelection();
    if (!selection || selection.isCollapsed) return null;
    let range = selection.getRangeAt(0);
    let selectionRect = range.getBoundingClientRect();
    let editorNode = range.startContainer.parentNode.closest('.editor');
    if (editorNode !== this.refs.editor) return null;
    let editorRect = editorNode.getBoundingClientRect();
    return selectionRect.y - editorRect.y;
  }

  render() {
    return /*#__PURE__*/external_React_default.a.createElement("div", {
      ref: "editor",
      className: classnames_default()('editor', {
        'read-only': this.props.isReadOnly
      })
    }, !this.props.isPlainText && !this.props.isReadOnly && this.state.bubbleTop !== null && /*#__PURE__*/external_React_default.a.createElement(editor_Bubble, {
      top: this.state.bubbleTop,
      onCommand: this.handleBalloonCommand
    }), /*#__PURE__*/external_React_default.a.createElement(editor_Content, {
      id: this.props.id,
      text: this.props.text,
      onChange: this.props.onChange,
      innerRef: this.contentRef,
      isReadOnly: this.props.isReadOnly,
      onSelectionChange: this.handleSelection,
      onBlur: this.props.onBlur,
      placeholder: this.props.placeholder,
      onScroll: this.handleScroll
    }));
  }

}

/* harmony default export */ var editor = (editor_Editor);
// EXTERNAL MODULE: ./node_modules/@babel/runtime/helpers/extends.js
var helpers_extends = __webpack_require__(5);
var extends_default = /*#__PURE__*/__webpack_require__.n(helpers_extends);

// CONCATENATED MODULE: ./src/lib/clamp.js
let cache = {};

function htmlSlice(node, data) {
  for (let i = 0; i < node.childNodes.length; i++) {
    let childNode = node.childNodes[i];

    if (childNode.nodeType === Node.ELEMENT_NODE) {
      if (childNode.nodeName === 'BR') {
        data.length += 1;

        if (data.length >= data.maxLength) {
          node.removeChild(childNode);
          i--;
        }

        continue;
      }

      htmlSlice(childNode, data);
    } else if (childNode.nodeType === Node.TEXT_NODE) {
      if (data.maxLength && data.length >= data.maxLength) {
        node.removeChild(childNode);
        i--;
      } else {
        data.length += childNode.textContent.length;
        let diffLength = data.length - data.maxLength;

        if (diffLength > 0) {
          childNode.textContent = childNode.textContent.slice(0, childNode.textContent.length - diffLength);

          if (!childNode.textContent.length) {
            node.removeChild(childNode);
            i--;
          }
        }
      }
    }
  }
}

async function lineClamp(html, container) {
  return new Promise(function (resolve) {
    requestAnimationFrame(function () {
      setTimeout(function () {
        let lineHeight = parseFloat(window.getComputedStyle(container).lineHeight);
        let width = parseFloat(window.getComputedStyle(container).width);
        let height = parseFloat(window.getComputedStyle(container).height);
        let linesNum = height / lineHeight;
        if (cache[width + html]) return resolve(cache[width + html]);
        requestAnimationFrame(function write() {
          let outer = document.createElement('div');
          outer.className = 'outer';
          let rootElement = document.createElement('div');
          rootElement.className = 'inner';
          rootElement.innerHTML = html;
          outer.appendChild(rootElement);
          container.appendChild(outer);
          let data = {
            length: 0,
            maxLength: Math.floor(width / 2 * linesNum)
          };
          htmlSlice(rootElement, data);
          let originalHTML = rootElement.innerHTML;
          let start = 1;
          let end = data.length;
          let mid = null;
          let longestLength = 0;
          let longestHTML = null;

          function read() {
            if (mid) {
              if (Math.abs(rootElement.offsetHeight - outer.offsetHeight) <= 1) {
                if (mid > longestLength) {
                  longestLength = mid;
                  longestHTML = rootElement.innerHTML;
                }

                start = mid + 1;
              } else {
                end = mid - 1;
              }
            } else if (Math.abs(rootElement.offsetHeight - outer.offsetHeight) <= 1) {
              let clampedHTML = rootElement.innerHTML;
              cache[width + html] = clampedHTML;
              container.removeChild(outer);
              return resolve(html);
            }

            if (start > end) {
              return requestAnimationFrame(function write() {
                rootElement.innerHTML = longestHTML;
                let text = rootElement.textContent;
                let truncatedText = text.replace(/[ .,;!?'‘’“”\-–—\u2026]+$/, '');
                let diff = text.length - truncatedText.length - 1;

                if (diff) {
                  rootElement.innerHTML = originalHTML;
                  htmlSlice(rootElement, {
                    length: 0,
                    maxLength: longestLength - diff
                  });
                  rootElement.appendChild(document.createTextNode('\u2026'));
                }

                let clampedHTML = rootElement.innerHTML;
                cache[width + html] = clampedHTML;
                container.removeChild(outer);
                resolve(clampedHTML);
              });
            }

            mid = parseInt((start + end) / 2);
            window.requestAnimationFrame(function write() {
              rootElement.innerHTML = originalHTML;
              htmlSlice(rootElement, {
                length: 0,
                maxLength: mid
              });
              rootElement.appendChild(document.createTextNode('\u2026'));
              setTimeout(read, 0);
            });
          }

          setTimeout(read, 0);
        });
      }, 0);
    });
  });
}
// CONCATENATED MODULE: ./src/lib/debounce.js
/**
 * https://github.com/lodash/lodash/blob/master/debounce.js
 * Creates a debounced function that delays invoking `func` until after `wait`
 * milliseconds have elapsed since the last time the debounced function was
 * invoked, or until the next browser frame is drawn. The debounced function
 * comes with a `cancel` method to cancel delayed `func` invocations and a
 * `flush` method to immediately invoke them. Provide `options` to indicate
 * whether `func` should be invoked on the leading and/or trailing edge of the
 * `wait` timeout. The `func` is invoked with the last arguments provided to the
 * debounced function. Subsequent calls to the debounced function return the
 * result of the last `func` invocation.
 *
 * **Note:** If `leading` and `trailing` options are `true`, `func` is
 * invoked on the trailing edge of the timeout only if the debounced function
 * is invoked more than once during the `wait` timeout.
 *
 * If `wait` is `0` and `leading` is `false`, `func` invocation is deferred
 * until the next tick, similar to `setTimeout` with a timeout of `0`.
 *
 * If `wait` is omitted in an environment with `requestAnimationFrame`, `func`
 * invocation will be deferred until the next frame is drawn (typically about
 * 16ms).
 *
 * See [David Corbacho's article](https://css-tricks.com/debouncing-throttling-explained-examples/)
 * for details over the differences between `debounce` and `throttle`.
 *
 * @since 0.1.0
 * @category Function
 * @param {Function} func The function to debounce.
 * @param {number} [wait=0]
 *  The number of milliseconds to delay; if omitted, `requestAnimationFrame` is
 *  used (if available).
 * @param {Object} [options={}] The options object.
 * @param {boolean} [options.leading=false]
 *  Specify invoking on the leading edge of the timeout.
 * @param {number} [options.maxWait]
 *  The maximum time `func` is allowed to be delayed before it's invoked.
 * @param {boolean} [options.trailing=true]
 *  Specify invoking on the trailing edge of the timeout.
 * @returns {Function} Returns the new debounced function.
 * @example
 *
 * // Avoid costly calculations while the window size is in flux.
 * jQuery(window).on('resize', debounce(calculateLayout, 150))
 *
 * // Invoke `sendMail` when clicked, debouncing subsequent calls.
 * jQuery(element).on('click', debounce(sendMail, 300, {
 *   'leading': true,
 *   'trailing': false
 * }))
 *
 * // Ensure `batchLog` is invoked once after 1 second of debounced calls.
 * const debounced = debounce(batchLog, 250, { 'maxWait': 1000 })
 * const source = new EventSource('/stream')
 * jQuery(source).on('message', debounced)
 *
 * // Cancel the trailing debounced invocation.
 * jQuery(window).on('popstate', debounced.cancel)
 *
 * // Check for pending invocations.
 * const status = debounced.pending() ? "Pending..." : "Ready"
 */
function debounce(func, wait, options) {
  let root = window;
  let lastArgs, lastThis, maxWait, result, timerID, lastCallTime;
  let lastInvokeTime = 0;
  let leading = false;
  let maxing = false;
  let trailing = true; // Bypass `requestAnimationFrame` by explicitly setting `wait=0`.

  const useRAF = !wait && wait !== 0 && typeof root.requestAnimationFrame === 'function';

  if (typeof func !== 'function') {
    throw new TypeError('Expected a function');
  }

  wait = +wait || 0;

  if (isObject(options)) {
    leading = !!options.leading;
    maxing = 'maxWait' in options;
    maxWait = maxing ? Math.max(+options.maxWait || 0, wait) : maxWait;
    trailing = 'trailing' in options ? !!options.trailing : trailing;
  }

  function isObject(value) {
    const type = typeof value;
    return value != null && (type === 'object' || type === 'function');
  }

  function invokeFunc(time) {
    const args = lastArgs;
    const thisArg = lastThis;
    lastArgs = lastThis = undefined;
    lastInvokeTime = time;
    result = func.apply(thisArg, args);
    return result;
  }

  function startTimer(pendingFunc, wait) {
    if (useRAF) {
      root.cancelAnimationFrame(timerID);
      return root.requestAnimationFrame(pendingFunc);
    }

    return setTimeout(pendingFunc, wait);
  }

  function cancelTimer(id) {
    if (useRAF) {
      return root.cancelAnimationFrame(id);
    }

    clearTimeout(id);
  }

  function leadingEdge(time) {
    // Reset any `maxWait` timer.
    lastInvokeTime = time; // Start the timer for the trailing edge.

    timerID = startTimer(timerExpired, wait); // Invoke the leading edge.

    return leading ? invokeFunc(time) : result;
  }

  function remainingWait(time) {
    const timeSinceLastCall = time - lastCallTime;
    const timeSinceLastInvoke = time - lastInvokeTime;
    const timeWaiting = wait - timeSinceLastCall;
    return maxing ? Math.min(timeWaiting, maxWait - timeSinceLastInvoke) : timeWaiting;
  }

  function shouldInvoke(time) {
    const timeSinceLastCall = time - lastCallTime;
    const timeSinceLastInvoke = time - lastInvokeTime; // Either this is the first call, activity has stopped and we're at the
    // trailing edge, the system time has gone backwards and we're treating
    // it as the trailing edge, or we've hit the `maxWait` limit.

    return lastCallTime === undefined || timeSinceLastCall >= wait || timeSinceLastCall < 0 || maxing && timeSinceLastInvoke >= maxWait;
  }

  function timerExpired() {
    const time = Date.now();

    if (shouldInvoke(time)) {
      return trailingEdge(time);
    } // Restart the timer.


    timerID = startTimer(timerExpired, remainingWait(time));
  }

  function trailingEdge(time) {
    timerID = undefined; // Only invoke if we have `lastArgs` which means `func` has been
    // debounced at least once.

    if (trailing && lastArgs) {
      return invokeFunc(time);
    }

    lastArgs = lastThis = undefined;
    return result;
  }

  function cancel() {
    if (timerID !== undefined) {
      cancelTimer(timerID);
    }

    lastInvokeTime = 0;
    lastArgs = lastCallTime = lastThis = timerID = undefined;
  }

  function flush() {
    return timerID === undefined ? result : trailingEdge(Date.now());
  }

  function pending() {
    return timerID !== undefined;
  }

  function debounced(...args) {
    const time = Date.now();
    const isInvoking = shouldInvoke(time);
    lastArgs = args;
    lastThis = this;
    lastCallTime = time;

    if (isInvoking) {
      if (timerID === undefined) {
        return leadingEdge(lastCallTime);
      }

      if (maxing) {
        // Handle invocations in a tight loop.
        timerID = startTimer(timerExpired, wait);
        return invokeFunc(lastCallTime);
      }
    }

    if (timerID === undefined) {
      timerID = startTimer(timerExpired, wait);
    }

    return result;
  }

  debounced.cancel = cancel;
  debounced.flush = flush;
  debounced.pending = pending;
  return debounced;
}
// CONCATENATED MODULE: ./src/components/expandable-editor.js








class expandable_editor_ExpandableEditor extends external_React_default.a.Component {
  constructor(...args) {
    super(...args);

    defineProperty_default()(this, "state", {
      isResizing: false,
      clampedHTML: null
    });

    defineProperty_default()(this, "debounceUpdate", debounce(this.update, 1000));

    defineProperty_default()(this, "initialized", false);

    defineProperty_default()(this, "handleResizerDown", event => {
      this.setState({
        isResizing: true
      });
    });

    defineProperty_default()(this, "handleResizerUp", event => {
      if (this.state.isResizing) {
        this.setState({
          isResizing: false
        });
        this.update();
      }
    });

    defineProperty_default()(this, "handleBlur", () => {
      this.setState({
        isExpanded: false
      });
    });

    defineProperty_default()(this, "handleChange", text => {
      this.props.onChange(text);
    });
  }

  getAllClampsContainer() {
    let container = document.getElementById('clamps');

    if (!container) {
      container = document.createElement('div');
      container.id = 'clamps';
      document.body.appendChild(container);
    }

    return container;
  }

  getClampContainer(clampID) {
    let container = document.getElementById(clampID);

    if (!container) {
      container = document.createElement('div');
      container.id = clampID;
      container.className = 'clamp';
      let allClampsContainer = this.getAllClampsContainer();
      allClampsContainer.appendChild(container);
    }

    return container;
  }

  componentDidMount() {
    document.getElementById('sidebarResizer').addEventListener('mousedown', this.handleResizerDown);
    window.addEventListener('mouseup', this.handleResizerUp);
  }

  componentWillUnmount() {
    // this.observer.disconnect();
    // document
    //   .getElementById('viewer')
    //   .removeEventListener('pointerdown', this.handleBlur);
    document.getElementById('sidebarResizer').removeEventListener('mousedown', this.handleResizerDown);
    window.removeEventListener('mouseup', this.handleResizerUp);
    this.unmounted = true;
  }

  componentDidUpdate(prevProps, prevState) {
    if (!this.initialized) {
      this.initialized = true;
      setTimeout(() => {
        this.update();
      }, 100);
    } else if (prevProps.text !== this.props.text) {
      this.setState({
        clampedHTML: null
      });
      this.debounceUpdate();
    }
  }

  async update() {
    if (this.unmounted) return;
    this.setState({
      clampedHTML: null
    });
    let node = this.refs.editorView.querySelector('.content');
    if (!node) return;
    let renderedEditorHTML = node.innerHTML;
    let clampedHTML = await lineClamp(renderedEditorHTML, this.getClampContainer(this.props.clampID));
    if (!this.unmounted) this.setState({
      clampedHTML
    });
  }

  setCaretToEnd(target) {
    const range = document.createRange();
    const sel = window.getSelection();
    range.selectNodeContents(target);
    range.collapse(false);
    sel.removeAllRanges();
    sel.addRange(range);
    target.focus();
    range.detach();
  }

  render() {
    let showClampedEditor = !this.props.isExpanded && !this.state.isResizing && this.state.clampedHTML;
    return /*#__PURE__*/external_React_default.a.createElement("div", {
      className: classnames_default()('expandable-editor', {
        expanded: this.props.isExpanded,
        editable: !this.props.isReadOnly && this.props.isEditable
      }),
      ref: "ex"
    }, /*#__PURE__*/external_React_default.a.createElement("div", {
      ref: "editorView",
      className: classnames_default()('editor-view'),
      style: {
        display: showClampedEditor ? 'none' : 'block'
      }
    }, /*#__PURE__*/external_React_default.a.createElement(editor, extends_default()({}, this.props, {
      onChange: this.handleChange,
      isReadOnly: this.props.isReadOnly || !this.props.isEditable
    }))), showClampedEditor && /*#__PURE__*/external_React_default.a.createElement("div", {
      className: "clamped-view"
    }, /*#__PURE__*/external_React_default.a.createElement("div", {
      className: classnames_default()('editor', {
        'read-only': this.props.isReadOnly || !this.props.isEditable
      })
    }, /*#__PURE__*/external_React_default.a.createElement("div", {
      className: "content",
      dir: "auto",
      dangerouslySetInnerHTML: {
        __html: this.state.clampedHTML
      }
    }))));
  }

}

/* harmony default export */ var expandable_editor = (expandable_editor_ExpandableEditor);
// CONCATENATED MODULE: ./src/components/preview.js







 // TODO: Don't allow to select UI text in popup header and footer

function PopupPreview(props) {
  const intl = Object(external_ReactIntl_["useIntl"])();

  function handlePageLabelDoubleClick() {
    props.onDoubleClickPageLabel(annotation.id);
  }

  function handleTagsClick(event) {
    if (props.annotation.readOnly) {
      return;
    }

    props.onClickTags(props.annotation.id, event);
  }

  function handleCommentChange(text) {
    props.onChange({
      id: props.annotation.id,
      comment: text,
      onlyTextOrComment: true
    });
  }

  function handleClickMore(event) {
    if (!props.annotation.readOnly) {
      event.stopPropagation();
      props.onMoreMenu({
        id: props.annotation.id,
        // button: true,
        screenX: event.screenX,
        screenY: event.screenY,
        selector: `#viewerContainer .preview .more`
      });
    }
  }

  let {
    annotation
  } = props;
  return /*#__PURE__*/external_React_default.a.createElement("div", {
    className: classnames_default()('preview', {
      'read-only': annotation.readOnly
    })
  }, /*#__PURE__*/external_React_default.a.createElement("header", {
    title: intl.formatDate(new Date(annotation.dateModified)) + ' ' + intl.formatTime(new Date(annotation.dateModified)) + (annotation.lastModifiedByUser ? ' (' + annotation.lastModifiedByUser + ')' : '')
  }, /*#__PURE__*/external_React_default.a.createElement("div", {
    className: "left"
  }, /*#__PURE__*/external_React_default.a.createElement("div", {
    className: classnames_default()('icon', 'icon-' + annotation.type),
    style: {
      color: annotation.color
    }
  }, annotation.type === 'highlight' && /*#__PURE__*/external_React_default.a.createElement(IconHighlight, null) || annotation.type === 'note' && /*#__PURE__*/external_React_default.a.createElement(IconNote, null) || annotation.type === 'image' && /*#__PURE__*/external_React_default.a.createElement(IconArea, null) || annotation.type === 'ink' && /*#__PURE__*/external_React_default.a.createElement(IconInk, null)), /*#__PURE__*/external_React_default.a.createElement("div", {
    className: "page",
    onDoubleClick: handlePageLabelDoubleClick
  }, /*#__PURE__*/external_React_default.a.createElement("div", null, /*#__PURE__*/external_React_default.a.createElement(external_ReactIntl_["FormattedMessage"], {
    id: "pdfReader.page"
  })), /*#__PURE__*/external_React_default.a.createElement("div", {
    className: "label"
  }, annotation.pageLabel))), /*#__PURE__*/external_React_default.a.createElement("div", {
    className: "right"
  }, annotation.authorName && /*#__PURE__*/external_React_default.a.createElement("div", {
    className: classnames_default()('author', {
      'non-authoritative': !annotation.isAuthorNameAuthoritative
    })
  }, annotation.authorName), /*#__PURE__*/external_React_default.a.createElement("button", {
    tabIndex: -1,
    className: "more",
    onClick: handleClickMore
  }))), annotation.type !== 'ink' && /*#__PURE__*/external_React_default.a.createElement("div", {
    className: "comment"
  }, /*#__PURE__*/external_React_default.a.createElement(editor, {
    id: annotation.id,
    text: annotation.comment,
    placeholder: annotation.readOnly ? intl.formatMessage({
      id: 'pdfReader.readOnly'
    }) : intl.formatMessage({
      id: 'pdfReader.addComment'
    }),
    isPlainText: false,
    isReadOnly: annotation.readOnly,
    onChange: handleCommentChange
  })), (!annotation.readOnly || !!annotation.tags.length) && /*#__PURE__*/external_React_default.a.createElement("button", {
    tabIndex: -1,
    className: "tags",
    onClick: handleTagsClick
  }, annotation.tags.length ? annotation.tags.map((tag, index) => /*#__PURE__*/external_React_default.a.createElement("span", {
    className: "tag",
    key: index,
    style: {
      color: tag.color
    }
  }, tag.name)) : /*#__PURE__*/external_React_default.a.createElement(external_ReactIntl_["FormattedMessage"], {
    id: "pdfReader.addTags"
  })));
}
function SidebarPreview(props) {
  const intl = Object(external_ReactIntl_["useIntl"])();

  function handlePageLabelClick(event) {
    event.stopPropagation();
  }

  function handlePageLabelDoubleClick() {
    props.onDoubleClickPageLabel(annotation.id);
  }

  function handleSectionClick(event, section) {
    props.onClickSection(props.annotation.id, section, event);
  }

  function handleTextChange(text) {
    props.onChange({
      id: props.annotation.id,
      text,
      onlyTextOrComment: true
    });
  }

  function handleCommentChange(text) {
    props.onChange({
      id: props.annotation.id,
      comment: text,
      onlyTextOrComment: true
    });
  }

  function handleClickMore(event) {
    if (!props.annotation.readOnly) {
      event.stopPropagation();
      props.onMenu({
        id: props.annotation.id,
        button: true,
        screenX: event.screenX,
        screenY: event.screenY,
        selector: `[data-sidebar-annotation-id="${props.annotation.id}"] .more`
      });
    }
  }

  function handleDragStart(event) {
    if (!event.target.getAttribute('draggable')) return;
    props.onDragStart(event, props.annotation.id);
  }

  function handleEditorBlur() {
    props.onEditorBlur(props.annotation.id);
  }

  function handleHighlightDoubleClick() {
    props.onDoubleClickHighlight(props.annotation.id);
  }

  function handlePointerDown(event) {
    let editorNode = event.target.closest('div[contenteditable="true"]');

    if (event.button === 2 && (!editorNode || document.activeElement !== editorNode)) {
      event.stopPropagation();
      event.preventDefault();
      props.onMenu({
        id: props.annotation.id,
        screenX: event.screenX,
        screenY: event.screenY
      });
    }
  }

  let {
    annotation,
    state
  } = props;
  let text = annotation.type === 'highlight' && /*#__PURE__*/external_React_default.a.createElement("div", {
    className: "highlight",
    onClick: e => handleSectionClick(e, 'highlight'),
    onDoubleClick: handleHighlightDoubleClick,
    draggable: state !== 3 || annotation.readOnly,
    onDragStart: handleDragStart
  }, /*#__PURE__*/external_React_default.a.createElement("div", {
    className: "blockquote-border",
    style: {
      backgroundColor: annotation.color
    }
  }), /*#__PURE__*/external_React_default.a.createElement(expandable_editor, {
    id: annotation.id,
    clampID: "highlight-clamp",
    text: annotation.text,
    placeholder: intl.formatMessage({
      id: 'pdfReader.noExtractedText'
    }),
    isReadOnly: annotation.readOnly,
    isExpanded: props.state >= 2,
    isEditable: state === 3,
    onChange: handleTextChange,
    onBlur: handleEditorBlur
  }));
  let comment = (state >= 1 || annotation.comment) && annotation.type !== 'ink' && !(annotation.readOnly && !annotation.comment) && /*#__PURE__*/external_React_default.a.createElement("div", {
    className: "comment",
    onClick: e => handleSectionClick(e, 'comment'),
    draggable: state === 0 || annotation.readOnly,
    onDragStart: handleDragStart
  }, /*#__PURE__*/external_React_default.a.createElement(expandable_editor, {
    id: annotation.id,
    clampID: "comment-clamp",
    text: annotation.comment,
    placeholder: intl.formatMessage({
      id: 'pdfReader.addComment'
    }),
    isPlainText: false,
    onChange: handleCommentChange,
    isReadOnly: annotation.readOnly,
    isExpanded: state >= 1,
    isEditable: state === 1 || state === 2 || state === 3,
    onBlur: handleEditorBlur
  }));
  let tags = annotation.tags.length ? annotation.tags.map((tag, index) => /*#__PURE__*/external_React_default.a.createElement("span", {
    className: "tag",
    key: index,
    style: {
      color: tag.color
    }
  }, tag.name)) : /*#__PURE__*/external_React_default.a.createElement(external_ReactIntl_["FormattedMessage"], {
    id: "pdfReader.addTags"
  });
  let expandedState = {};
  expandedState['expanded' + props.state] = true;
  return /*#__PURE__*/external_React_default.a.createElement("div", {
    onPointerDown: handlePointerDown,
    className: classnames_default()('preview', {
      'read-only': annotation.readOnly,
      ...expandedState
    })
  }, /*#__PURE__*/external_React_default.a.createElement("header", {
    title: intl.formatDate(new Date(annotation.dateModified)) + ' ' + intl.formatTime(new Date(annotation.dateModified)) + (annotation.lastModifiedByUser ? ' (' + annotation.lastModifiedByUser + ')' : ''),
    onClick: e => handleSectionClick(e, 'header'),
    draggable: true,
    onDragStart: handleDragStart
  }, /*#__PURE__*/external_React_default.a.createElement("div", {
    className: "left"
  }, /*#__PURE__*/external_React_default.a.createElement("div", {
    className: classnames_default()('icon', 'icon-' + annotation.type),
    style: {
      color: annotation.color
    }
  }, annotation.type === 'highlight' && /*#__PURE__*/external_React_default.a.createElement(IconHighlight, null) || annotation.type === 'note' && /*#__PURE__*/external_React_default.a.createElement(IconNote, null) || annotation.type === 'image' && /*#__PURE__*/external_React_default.a.createElement(IconArea, null) || annotation.type === 'ink' && /*#__PURE__*/external_React_default.a.createElement(IconInk, null)), /*#__PURE__*/external_React_default.a.createElement("div", {
    className: "page",
    onClick: handlePageLabelClick,
    onDoubleClick: handlePageLabelDoubleClick
  }, /*#__PURE__*/external_React_default.a.createElement("div", null, /*#__PURE__*/external_React_default.a.createElement(external_ReactIntl_["FormattedMessage"], {
    id: "pdfReader.page"
  })), /*#__PURE__*/external_React_default.a.createElement("div", {
    className: "label"
  }, annotation.pageLabel))), /*#__PURE__*/external_React_default.a.createElement("div", {
    className: "right"
  }, annotation.authorName && /*#__PURE__*/external_React_default.a.createElement("div", {
    className: classnames_default()('author', {
      'non-authoritative': !annotation.isAuthorNameAuthoritative
    })
  }, annotation.authorName), /*#__PURE__*/external_React_default.a.createElement("button", {
    tabIndex: -1,
    className: "more",
    onClick: handleClickMore,
    title: window.isWeb ? "Annotations can't be edited in Web Library" : null
  }))), annotation.image && /*#__PURE__*/external_React_default.a.createElement("img", {
    className: "image",
    src: annotation.image,
    onClick: e => handleSectionClick(e, 'image'),
    draggable: true,
    onDragStart: handleDragStart
  }), text, comment, (state >= 1 && !annotation.readOnly || annotation.tags.length > 0) && /*#__PURE__*/external_React_default.a.createElement("button", {
    tabIndex: -1,
    className: "tags",
    onClick: e => handleSectionClick(e, 'tags'),
    draggable: true,
    onDragStart: handleDragStart
  }, tags));
}
// CONCATENATED MODULE: ./src/components/ink.js






function Ink({
  annotation,
  isSelected
}) {
  let boundingRect = getPositionBoundingRect(annotation.position);

  if (annotation.position.paths) {
    let {
      width
    } = annotation.position;
    width = width + 5;
    boundingRect = [boundingRect[0] - width, boundingRect[1] - width, boundingRect[2] + width, boundingRect[3] + width];
  }

  return /*#__PURE__*/external_React_default.a.createElement("div", {
    className: classnames_default()('ink-annotation', {
      selected: isSelected
    })
  }, /*#__PURE__*/external_React_default.a.createElement("div", {
    className: "square",
    style: {
      left: boundingRect[0],
      top: boundingRect[1],
      width: boundingRect[2] - boundingRect[0],
      height: boundingRect[3] - boundingRect[1]
    }
  }), /*#__PURE__*/external_React_default.a.createElement("svg", {
    xmlns: "http://www.w3.org/2000/svg"
  }, annotation.position.paths.map((path, index) => {
    let svgPath = `M ${path.slice(0, 2).join(',')} L ${path.join(',')}`;
    return /*#__PURE__*/external_React_default.a.createElement("path", {
      key: index,
      fill: "none",
      strokeLinecap: "round",
      strokeLinejoin: "round",
      strokeWidth: annotation.position.width,
      stroke: annotation.color,
      d: svgPath
    });
  })));
}

/* harmony default export */ var ink = (Ink);
// CONCATENATED MODULE: ./src/components/layer.js
















function PageLayerInk(props) {
  function getContainerNode(viewport) {
    return findOrCreateContainerLayer(viewport.div, 'layer-ink');
  }

  let node = getContainerNode(props.view);
  if (!node) return null;
  return /*#__PURE__*/external_ReactDOM_default.a.createPortal( /*#__PURE__*/external_React_default.a.createElement("div", {
    className: classnames_default()({
      'selecting-annotation': !!props.selectedAnnotationIDs.length
    })
  }, props.annotations.map((annotation, index) => {
    let {
      position,
      ...rest
    } = annotation;
    let viewportAnnotation = {
      position: coordinates_p2v(position, props.view.viewport),
      ...rest
    };
    return /*#__PURE__*/external_React_default.a.createElement("div", {
      key: annotation.id
    }, /*#__PURE__*/external_React_default.a.createElement(ink, {
      annotation: viewportAnnotation,
      isSelected: props.selectedAnnotationIDs.includes(annotation.id)
    }));
  })), node);
}

function PageLayerHighlight(props) {
  function getContainerNode(viewport) {
    return findOrCreateContainerLayer(viewport.div, 'layer-highlight');
  }

  let node = getContainerNode(props.view);
  if (!node) return null;
  return /*#__PURE__*/external_ReactDOM_default.a.createPortal( /*#__PURE__*/external_React_default.a.createElement("div", {
    className: classnames_default()({
      'selecting-annotation': !!props.selectedAnnotationIDs.length
    })
  }, props.annotations.map((annotation, index) => {
    let {
      position,
      ...rest
    } = annotation;
    let viewportAnnotation = {
      position: coordinates_p2v(position, props.view.viewport),
      ...rest
    };
    return /*#__PURE__*/external_React_default.a.createElement("div", {
      key: annotation.id
    }, /*#__PURE__*/external_React_default.a.createElement(highlight, {
      annotation: viewportAnnotation,
      isSelected: props.selectedAnnotationIDs.includes(annotation.id),
      onDragStart: props.onDragStart,
      onDragEnd: props.onDragEnd
    }));
  })), node);
}

function PageLayerNote(props) {
  function getContainerNode(viewport) {
    return findOrCreateContainerLayer(viewport.div, 'layer-note');
  }

  let node = getContainerNode(props.view);
  if (!node) return null;
  return /*#__PURE__*/external_ReactDOM_default.a.createPortal( /*#__PURE__*/external_React_default.a.createElement("div", null, props.annotations.map((annotation, index) => {
    let {
      position,
      ...rest
    } = annotation;
    let viewportAnnotation = {
      position: coordinates_p2v(position, props.view.viewport),
      ...rest
    };
    return /*#__PURE__*/external_React_default.a.createElement("div", {
      key: annotation.id
    }, /*#__PURE__*/external_React_default.a.createElement(components_note, {
      annotation: viewportAnnotation,
      isSelected: props.selectedAnnotationIDs.includes(annotation.id),
      enableMoving: props.selectedAnnotationIDs.length === 1,
      onDragStart: props.onDragStart,
      onDragEnd: props.onDragEnd,
      onChangePosition: position => {
        props.onChangePosition(annotation.id, position);
      }
    }));
  })), node);
}

function PageLayerArea(props) {
  function getContainerNode(viewport) {
    return findOrCreateContainerLayer(viewport.div, 'layer-area');
  }

  let node = getContainerNode(props.view);
  if (!node) return null;
  return /*#__PURE__*/external_ReactDOM_default.a.createPortal( /*#__PURE__*/external_React_default.a.createElement("div", null, props.annotations.map((annotation, index) => {
    let {
      position,
      ...rest
    } = annotation;
    let viewportAnnotation = {
      position: coordinates_p2v(position, props.view.viewport),
      ...rest
    };
    return /*#__PURE__*/external_React_default.a.createElement("div", {
      key: annotation.id
    }, /*#__PURE__*/external_React_default.a.createElement(components_area, {
      annotation: viewportAnnotation,
      isSelected: props.selectedAnnotationIDs.includes(annotation.id),
      move: props.selectedAnnotationIDs.length === 1,
      onResizeStart: props.onResizeStart,
      onDragStart: props.onDragStart,
      onDragEnd: props.onDragEnd,
      onChangePosition: position => {
        props.onChangePosition(annotation.id, position);
      }
    }));
  })), node);
}

function AreaSelectorLayer(props) {
  function getContainerNode() {
    let container = document.getElementById('areaSelectorContainer');

    if (!container) {
      let viewerContainer = document.getElementById('viewerContainer');
      container = document.createElement('div');
      container.id = 'areaSelectorContainer';
      viewerContainer.appendChild(container);
    }

    return container;
  }

  return /*#__PURE__*/external_ReactDOM_default.a.createPortal( /*#__PURE__*/external_React_default.a.createElement(area_selector, {
    color: props.color,
    shouldStart: props.enableAreaSelector,
    onSelectionStart: props.onSelectionStart,
    onSelection: props.onSelection
  }), getContainerNode());
}

function EdgeNoteLayer(props) {
  function getContainerNode(viewport) {
    return findOrCreateContainerLayer(viewport.div, 'layer-edge-note');
  }

  function quickIntersectRect(r1, r2) {
    return !(r2[0] > r1[2] || r2[2] < r1[0] || r2[1] > r1[3] || r2[3] < r1[1]);
  }

  function stackNotes(notes) {
    notes.sort((a, b) => a.rect[0] - b.rect[0]);

    for (let note of notes) {
      for (let note2 of notes) {
        if (note2 === note) break;

        if (quickIntersectRect(note.rect, note2.rect)) {
          let shift = wx(note2.rect) / 3 * 2;
          note.rect[0] = note2.rect[0] + shift;
          note.rect[2] = note2.rect[2] + shift;
        }
      }
    }
  }

  function getNotes(annotations, viewport) {
    let notes = [];
    let scale = PDFViewerApplication.pdfViewer._currentScale;
    let width = 9.6 * scale;
    let height = 9.6 * scale;

    for (let annotation of annotations) {
      let viewportPosition = coordinates_p2v(annotation.position, viewport);
      let left = viewportPosition.rects[0][0] - width / 2;
      let top = viewportPosition.rects[0][1] - height + height / 3;
      notes.push({
        annotation,
        rect: [left, top, left + width, top + height]
      });
    }

    notes.reverse();
    return notes;
  }

  let node = getContainerNode(props.view);
  if (!node) return null;
  let commentedAnnotations = props.annotations.filter(x => x.comment);
  let notes = getNotes(commentedAnnotations, props.view.viewport);
  stackNotes(notes);
  return /*#__PURE__*/external_ReactDOM_default.a.createPortal( /*#__PURE__*/external_React_default.a.createElement("div", null, notes.map(note => {
    let isSelected = props.selectedAnnotationIDs.includes(note.annotation.id);
    return /*#__PURE__*/external_React_default.a.createElement("div", {
      key: note.annotation.id,
      className: classnames_default()('edge-note', {
        selected: isSelected
      }),
      style: {
        left: note.rect[0],
        top: note.rect[1],
        width: wx(note.rect),
        height: hy(note.rect),
        color: note.annotation.color,
        zIndex: isSelected ? 2 : 1
      },
      onClick: e => {
        e.preventDefault();
        e.stopPropagation(); // Call after all other events

        setTimeout(() => {
          props.onClick(note.annotation.id);
        }, 0);
      }
    }, /*#__PURE__*/external_React_default.a.createElement("svg", {
      width: wx(note.rect),
      height: hy(note.rect),
      viewBox: "0 0 12 12"
    }, /*#__PURE__*/external_React_default.a.createElement("path", {
      fill: "currentColor",
      d: "M0,0V6.707L5.293,12H12V0Z"
    }), /*#__PURE__*/external_React_default.a.createElement("path", {
      d: "M0,0V6.707L5.293,12H12V0ZM1.707,7H5v3.293ZM11,11H6V6H1V1H11Z",
      opacity: "0.67"
    }), /*#__PURE__*/external_React_default.a.createElement("polygon", {
      points: "1.707 7 5 10.293 5 7 1.707 7",
      fill: "#fff",
      opacity: "0.4"
    })));
  })), node);
}

function BlinkLayer(props) {
  const intervalRef = Object(external_React_["useRef"])(null);
  const innerRef = Object(external_React_["useRef"])(null);
  Object(external_React_["useLayoutEffect"])(() => {
    fade(innerRef.current);
  }, [props.id]);

  function fade(element) {
    if (intervalRef.current) clearInterval(intervalRef.current);
    let op = 1;
    intervalRef.current = setInterval(() => {
      if (op <= 0.05) {
        clearInterval(intervalRef.current);
        element.style.opacity = 0;
        return;
      }

      element.style.opacity = op;
      op -= op * 0.1;
    }, 100);
  }

  function getContainerNode(viewport) {
    return findOrCreateContainerLayer(viewport.div, 'layer-blink');
  }

  let node = getContainerNode(props.view);
  if (!node) return null;
  return /*#__PURE__*/external_ReactDOM_default.a.createPortal( /*#__PURE__*/external_React_default.a.createElement("div", {
    ref: innerRef
  }, props.position.rects.map((rect, index) => /*#__PURE__*/external_React_default.a.createElement("div", {
    key: index,
    className: "rect",
    style: {
      left: rect[0],
      top: rect[1],
      width: rect[2] - rect[0],
      height: rect[3] - rect[1]
    }
  }))), node);
}

function SelectionLayer({
  positions,
  color
}) {
  Object(external_React_["useEffect"])(() => {
    draw();
    return () => {
      erase();
    };
  }, [positions]);

  function getCtx(pageIndex) {
    let viewport = window.PDFViewerApplication.pdfViewer.getPageView(pageIndex);
    let canvas = viewport.div.querySelector('.canvasWrapper .selectionCanvas');

    if (!canvas) {
      let wrapper = viewport.div.querySelector('.canvasWrapper');
      if (!wrapper) return null;
      canvas = document.createElement('canvas');
      canvas.className = 'selectionCanvas';
      canvas.width = viewport.canvas.width;
      canvas.height = viewport.canvas.height;
      canvas.style.width = viewport.div.style.width;
      canvas.style.height = viewport.div.style.height;
      wrapper.appendChild(canvas);
    }

    let ctx = canvas.getContext('2d');
    ctx.clearRect(0, 0, canvas.width, canvas.height);
    return ctx;
  }

  function erase() {
    for (let i = 0; i < window.PDFViewerApplication.pdfDocument.numPages; i++) {
      let page = window.PDFViewerApplication.pdfViewer.getPageView(i);
      let canvas = page.div.querySelector('.canvasWrapper .selectionCanvas');

      if (canvas) {
        let ctx = canvas.getContext('2d');
        ctx.clearRect(0, 0, canvas.width, canvas.height);
      }
    }
  }

  function draw() {
    for (let position of positions) {
      let ctx = getCtx(position.pageIndex);
      if (!ctx) return null;
      let viewport = window.PDFViewerApplication.pdfViewer.getPageView(position.pageIndex);
      ctx.fillStyle = color;

      for (let rect of position.rects) {
        let {
          sx,
          sy
        } = viewport.outputScale;
        ctx.fillRect(rect[0] * sx, rect[1] * sy, (rect[2] - rect[0]) * sx, (rect[3] - rect[1]) * sy);
      }
    }
  }

  return null;
}

function Layer(props) {
  const [initialized, setInitialized] = Object(external_React_["useState"])(false);
  const [render, setRender] = Object(external_React_["useState"])({});
  let viewer = window.PDFViewerApplication.pdfViewer;
  let containerNode = document.getElementById('viewerContainer');
  let selectionPositions = Object(external_React_["useMemo"])(() => props.selectionPositions.map(p => p2v(p)), [props.selectionPositions]);
  const handlePointerDownCallback = Object(external_React_["useCallback"])(handlePointerDown, []);
  const handlePointerMoveCallback = Object(external_React_["useMemo"])(() => throttle(handlePointerMove, 50), []);
  const handlePointerUpDownCallback = Object(external_React_["useCallback"])(handlePointerUp, []);
  const handlePageRenderCallback = Object(external_React_["useCallback"])(handlePageRender, []);
  Object(external_React_["useEffect"])(() => {
    containerNode = document.getElementById('viewerContainer'); // event.detail doesn't work with pointerdown

    containerNode.addEventListener('mousedown', handlePointerDownCallback);
    containerNode.addEventListener('mousemove', handlePointerMoveCallback);
    containerNode.addEventListener('pointerup', handlePointerUpDownCallback);
    viewer = window.PDFViewerApplication.pdfViewer;
    viewer.eventBus.on('pagerendered', handlePageRenderCallback);
    return () => {
      containerNode.removeEventListener('mousedown', handlePointerDownCallback);
      containerNode.removeEventListener('mousemove', handlePointerMoveCallback);
      containerNode.removeEventListener('pointerup', handlePointerUpDownCallback);
      viewer.eventBus.off('pagerendered', handlePageRenderCallback);
    };
  }, []);

  function handlePointerDown(event) {
    let position = pointerEventToPosition(event);

    if (!position) {
      return;
    }

    props.onPointerDown(v2p(position), event);
  }

  function handlePointerMove(event) {
    let position = pointerEventToPosition(event);

    if (!position) {
      return;
    }

    if (viewer.pdfDocument.uninitialized) {
      return;
    }

    props.onPointerMove(v2p(position), event);
  }

  function handlePointerUp(event) {
    if (event.target.classList.contains('edge-note')) {
      return;
    }

    let position = pointerEventToPosition(event);

    if (!position) {
      return;
    } // Shoot the event after all other events are emitted.
    // Otherwise the resize updating in the area annotation is emitted too late
    // setTimeout(() => {


    props.onPointerUp(v2p(position), event); // }, 0);
  }

  function handlePageRender(event) {
    // console.log(`pdf.js rendered pageIndex ${event.pageNumber - 1}`);
    setRender({});
    setInitialized(true);
  }

  function groupAnnotationsByPage(annotations) {
    return [...annotations].reduce((res, annotation) => {
      let {
        pageIndex
      } = annotation.position;
      res[pageIndex] = res[pageIndex] || [];
      res[pageIndex].push(annotation);
      return res;
    }, {});
  }

  function v2p(position) {
    let viewport = viewer.getPageView(position.pageIndex).viewport;
    return coordinates_v2p(position, viewport);
  }

  function p2v(position) {
    let viewport = viewer.getPageView(position.pageIndex).viewport;
    return coordinates_p2v(position, viewport);
  }

  let {
    annotations,
    color,
    selectedAnnotationIDs,
    popupAnnotation,
    blink,
    onChange,
    onClickTags,
    onClickEdgeNote
  } = props;
  if (!initialized) return null;
  let pageLayers = [];
  let annotationsByPage = groupAnnotationsByPage(annotations);

  for (let pageIndex = 0; pageIndex < viewer.pdfDocument.numPages; pageIndex++) {
    if (!annotationsByPage[pageIndex] || viewer._pages[pageIndex].renderingState === 0) {
      continue;
    }

    let view = viewer.getPageView(pageIndex);
    pageLayers.push( /*#__PURE__*/external_React_default.a.createElement(PageLayerInk, {
      key: 'i_' + pageIndex,
      view: view,
      selectedAnnotationIDs: selectedAnnotationIDs,
      annotations: annotationsByPage[pageIndex].filter(x => x.type === 'ink') || []
    }), /*#__PURE__*/external_React_default.a.createElement(PageLayerHighlight, {
      key: 'h_' + pageIndex,
      view: view,
      selectedAnnotationIDs: selectedAnnotationIDs,
      annotations: annotationsByPage[pageIndex].filter(x => x.type === 'highlight') || [],
      onDragStart: props.onDragStart,
      onDragEnd: props.onDragEnd
    }), /*#__PURE__*/external_React_default.a.createElement(PageLayerNote, {
      key: 'n_' + pageIndex,
      view: view,
      selectedAnnotationIDs: selectedAnnotationIDs,
      annotations: annotationsByPage[pageIndex].filter(x => x.type === 'note') || [],
      onChangePosition: (id, position) => {
        onChange({
          id,
          position: v2p(position)
        });
      },
      onDragStart: props.onDragStart,
      onDragEnd: props.onDragEnd
    }), /*#__PURE__*/external_React_default.a.createElement(PageLayerArea, {
      key: 'a_' + pageIndex,
      view: view,
      selectedAnnotationIDs: selectedAnnotationIDs,
      annotations: annotationsByPage[pageIndex].filter(x => x.type === 'image') || [],
      onResizeStart: props.onAreaResizeStart,
      onChangePosition: (id, position) => {
        onChange({
          id,
          position: v2p(position)
        });
      },
      onDragStart: props.onDragStart,
      onDragEnd: props.onDragEnd
    }));

    if (props.enableEdgeNotes) {
      pageLayers.push( /*#__PURE__*/external_React_default.a.createElement(EdgeNoteLayer, {
        key: 'm_' + pageIndex,
        view: view,
        selectedAnnotationIDs: selectedAnnotationIDs,
        annotations: annotationsByPage[pageIndex].filter(x => ['highlight', 'image'].includes(x.type)) || [],
        onClick: onClickEdgeNote
      }));
    }
  }

  if (popupAnnotation) {
    let {
      position,
      ...rest
    } = popupAnnotation;
    popupAnnotation = {
      position: p2v(position),
      ...rest
    };
  }

  let blinkLayer = null;

  if (blink) {
    let view = viewer.getPageView(blink.position.pageIndex);

    if (view && view.renderingState !== 0) {
      let id = blink.id;
      let position = p2v(blink.position);
      blinkLayer = /*#__PURE__*/external_React_default.a.createElement(BlinkLayer, {
        view: view,
        id: id,
        position: position
      });
    }
  }

  return /*#__PURE__*/external_React_default.a.createElement(external_React_default.a.Fragment, null, blinkLayer, /*#__PURE__*/external_React_default.a.createElement(SelectionLayer, {
    positions: selectionPositions,
    color: props.selectionColor
  }), /*#__PURE__*/external_React_default.a.createElement(AreaSelectorLayer, {
    color: color,
    enableAreaSelector: props.enableAreaSelector,
    onSelectionStart: props.onAreaSelectionStart,
    onSelection: position => {
      props.onAreaSelection(v2p(position));
    }
  }), popupAnnotation && /*#__PURE__*/external_React_default.a.createElement(page_popup, {
    id: popupAnnotation.id,
    className: "annotation-popup",
    position: popupAnnotation.position // TODO: After area resize popup still needs to be repositioned
    ,
    updateOnPositionChange: false
  }, /*#__PURE__*/external_React_default.a.createElement(PopupPreview, {
    annotation: popupAnnotation,
    isExpandable: false,
    enableText: false,
    enableImage: false,
    enableComment: !popupAnnotation.readOnly || popupAnnotation.comment,
    enableTags: !popupAnnotation.readOnly || popupAnnotation.tags.length > 0,
    onUpdate: comment => {
      onChange({
        id: popupAnnotation.id,
        comment
      });
    },
    onColorChange: color => {
      onChange({
        id: popupAnnotation.id,
        color
      });
    },
    onDoubleClickPageLabel: props.onDoubleClickPageLabel,
    onClickTags: onClickTags,
    onChange: onChange,
    onPageMenu: props.onPageMenu,
    onMoreMenu: props.onMoreMenu,
    onDragStart: event => {
      setDataTransferAnnotations(event.dataTransfer, [popupAnnotation]);
    }
  })), props.enableSelectionPopup && selectionPositions.length && /*#__PURE__*/external_React_default.a.createElement(page_popup, {
    id: 1,
    className: "selection-popup",
    position: selectionPositions[0],
    updateOnPositionChange: true
  }, /*#__PURE__*/external_React_default.a.createElement(selection_menu, {
    color: color,
    enableAddToNote: props.enableAddToNote,
    onHighlight: props.onHighlightSelection,
    onCopy: props.onCopySelection,
    onAddToNote: props.onAddToNoteSelection
  })), pageLayers);
}

/* harmony default export */ var components_layer = (Layer);
// CONCATENATED MODULE: ./src/components/annotations-view.js










function AnnotationsViewSearch({
  query,
  onInput,
  onClear
}) {
  const intl = Object(external_ReactIntl_["useIntl"])();

  function handleInput(event) {
    onInput(event.target.value);
  }

  function handleClear() {
    onClear();
  }

  function handleKeyDown(event) {
    if (event.key === 'Escape') {
      handleClear();
    }
  }

  return /*#__PURE__*/external_React_default.a.createElement("div", {
    className: "search"
  }, /*#__PURE__*/external_React_default.a.createElement("div", {
    className: "icon icon-search"
  }), /*#__PURE__*/external_React_default.a.createElement("div", {
    className: "input-group"
  }, /*#__PURE__*/external_React_default.a.createElement("input", {
    id: "searchInput",
    tabIndex: -1,
    type: "text",
    placeholder: intl.formatMessage({
      id: 'pdfReader.searchAnnotations'
    }),
    value: query,
    onChange: handleInput,
    onKeyDown: handleKeyDown
  })), query.length !== 0 && /*#__PURE__*/external_React_default.a.createElement("button", {
    className: "clear",
    onClick: handleClear
  }));
}

function Selector({
  tags,
  colors,
  authors,
  onContextMenu,
  onClickTag,
  onClickColor,
  onClickAuthor,
  onChange
}) {
  const intl = Object(external_ReactIntl_["useIntl"])();

  function handleDragOver(event) {
    event.preventDefault();
    event.dataTransfer.dropEffect = "move";
    event.target.closest('button').classList.add('dragged-over');
  }

  function handleDragLeave(event) {
    event.target.closest('button').classList.remove('dragged-over');
  }

  function handleDrop(event, tag, color) {
    event.preventDefault();
    let remove = event.shiftKey || event.metaKey;
    onChange(remove, tag, color);
    event.target.closest('button').classList.remove('dragged-over');
  }

  return /*#__PURE__*/external_React_default.a.createElement("div", {
    id: "selector",
    className: "selector",
    onContextMenu: onContextMenu
  }, colors.length > 1 && /*#__PURE__*/external_React_default.a.createElement("div", {
    className: "colors"
  }, colors.map((color, index) => /*#__PURE__*/external_React_default.a.createElement("button", {
    key: index,
    tabIndex: -1,
    className: classnames_default()('color', {
      selected: color.selected,
      inactive: color.inactive
    }),
    title: color.name ? intl.formatMessage({
      id: color.name
    }) : null,
    onClick: () => onClickColor(color.color),
    onDragOver: handleDragOver,
    onDragLeave: handleDragLeave,
    onDrop: event => handleDrop(event, null, color.color)
  }, /*#__PURE__*/external_React_default.a.createElement(IconColor, {
    color: color.color
  })))), !!tags.length && /*#__PURE__*/external_React_default.a.createElement("div", {
    className: "tags"
  }, tags.map((tag, index) => /*#__PURE__*/external_React_default.a.createElement("button", {
    key: index,
    tabIndex: -1,
    className: classnames_default()('tag', {
      color: !!tag.color,
      selected: tag.selected,
      inactive: tag.inactive
    }),
    style: {
      color: tag.color
    },
    onClick: () => onClickTag(tag.name),
    onDragOver: handleDragOver,
    onDragLeave: handleDragLeave,
    onDrop: event => handleDrop(event, {
      name: tag.name,
      color: tag.color
    })
  }, tag.name))), authors.length > 1 && /*#__PURE__*/external_React_default.a.createElement("div", {
    className: "authors"
  }, authors.map((author, index) => /*#__PURE__*/external_React_default.a.createElement("button", {
    key: index,
    tabIndex: -1,
    className: classnames_default()('author', {
      selected: author.selected,
      inactive: author.inactive
    }),
    onClick: () => onClickAuthor(author.author)
  }, /*#__PURE__*/external_React_default.a.createElement(IconUser, null), author.author))));
} // We get significant performance boost here because `props.annotation`
// reference is updated only when annotation data is updated


const Annotation = /*#__PURE__*/external_React_default.a.memo(props => {
  return /*#__PURE__*/external_React_default.a.createElement("div", {
    tabIndex: -1,
    className: classnames_default()('annotation', {
      selected: props.isSelected
    }),
    "data-sidebar-annotation-id": props.annotation.id
  }, /*#__PURE__*/external_React_default.a.createElement(SidebarPreview, {
    state: props.expansionState,
    annotation: props.annotation,
    selected: props.isSelected,
    onDragStart: props.onDragStart,
    onClickSection: props.onClickAnnotationSection,
    onDoubleClickHighlight: props.onDoubleClickHighlight,
    onDoubleClickPageLabel: props.onDoubleClickPageLabel,
    onMenu: props.onMenu,
    onMoreMenu: props.onMoreMenu,
    onChange: props.onChange,
    onEditorBlur: props.onAnnotationEditorBlur
  }));
});
const AnnotationsView = /*#__PURE__*/Object(external_React_["memo"])(function (props) {
  function getContainerNode() {
    return document.getElementById('annotationsView');
  }

  function handleSearchInput(query) {
    props.onChangeFilter({ ...props.filter,
      query
    });
  }

  function handleSearchClear() {
    props.onChangeFilter({ ...props.filter,
      query: ''
    });
  }

  function handleColorClick(color) {
    let {
      colors
    } = props.filter;

    if (colors.includes(color)) {
      colors = colors.filter(x => x !== color);
    } else {
      colors = [...colors, color];
    }

    props.onChangeFilter({ ...props.filter,
      colors
    });
  }

  function handleTagClick(tag) {
    let {
      tags
    } = props.filter;

    if (tags.includes(tag)) {
      tags = tags.filter(x => x !== tag);
    } else {
      tags = [...tags, tag];
    }

    props.onChangeFilter({ ...props.filter,
      tags
    });
  }

  function handleAuthorClick(author) {
    let {
      authors
    } = props.filter;

    if (authors.includes(author)) {
      authors = authors.filter(x => x !== author);
    } else {
      authors = [...authors, author];
    }

    props.onChangeFilter({ ...props.filter,
      authors
    });
  }

  function handleSelectorContextMenu(event) {
    if (!event.target.classList.contains('colors') && !event.target.classList.contains('tags')) {
      return;
    }

    props.onSelectorMenu({
      x: event.screenX,
      y: event.screenY,
      enableClearSelection: props.filter.colors.length || props.filter.tags.length || props.filter.authors.length
    });
  }

  let containerNode = getContainerNode();

  if (!containerNode) {
    return null;
  }

  let tags = {};
  let colors = {};
  let authors = {};

  for (let annotation of props.allAnnotations) {
    for (let tag of annotation.tags) {
      if (!tags[tag.name]) {
        tags[tag.name] = { ...tag
        };
        tags[tag.name].selected = props.filter.tags.includes(tag.name);
        tags[tag.name].inactive = true;
      }
    }

    let color = annotation.color;

    if (!colors[color]) {
      let predefinedColor = annotationColors.find(x => x[1] === color);
      colors[color] = {
        color,
        selected: props.filter.colors.includes(color),
        inactive: true,
        name: predefinedColor ? predefinedColor[0] : null
      };
    }

    let author = annotation.authorName;

    if (author && !authors[author]) {
      authors[author] = {
        author,
        selected: props.filter.authors.includes(author),
        inactive: true,
        current: author === props.authorName
      };
    }
  }

  for (let annotation of props.annotations) {
    for (let tag of annotation.tags) {
      tags[tag.name].inactive = false;
    }

    colors[annotation.color].inactive = false;
    let author = annotation.authorName;

    if (author) {
      authors[author].inactive = false;
    }
  }

  let coloredTags = [];

  for (let key in tags) {
    let tag = tags[key];

    if (tag.color) {
      coloredTags.push(tag);
      delete tags[key];
    }
  } // Sort colored tags and place at beginning


  coloredTags.sort((a, b) => {
    return a.position - b.position;
  });
  let primaryColors = [];

  for (let annotationColor of annotationColors) {
    if (colors[annotationColor[1]]) {
      primaryColors.push(colors[annotationColor[1]]);
      delete colors[annotationColor[1]];
    }
  }

  tags = Object.values(tags);
  let collator = new Intl.Collator();
  tags.sort(function (a, b) {
    return collator.compare(a.tag, b.tag);
  });
  tags = [...coloredTags, ...tags];
  colors = Object.values(colors);
  colors = [...primaryColors, ...colors];
  authors = Object.values(authors);
  authors.sort(function (a, b) {
    if (a.current) {
      return -1;
    } else if (b.current) {
      return 1;
    }

    return collator.compare(a.author, b.author);
  });
  return /*#__PURE__*/external_ReactDOM_default.a.createPortal( /*#__PURE__*/external_React_default.a.createElement(external_React_default.a.Fragment, null, /*#__PURE__*/external_React_default.a.createElement(AnnotationsViewSearch, {
    query: props.filter.query,
    onInput: handleSearchInput,
    onClear: handleSearchClear
  }), /*#__PURE__*/external_React_default.a.createElement("div", {
    id: "annotations",
    className: "annotations"
  }, props.allAnnotations.length ? props.annotations.map(annotation => /*#__PURE__*/external_React_default.a.createElement(Annotation, {
    key: annotation.id,
    isSelected: props.selectedIDs.includes(annotation.id),
    annotation: annotation,
    expansionState: props.selectedIDs.includes(annotation.id) ? props.expansionState : 0,
    onSelect: props.onSelectAnnotation,
    onChange: props.onChange,
    onClickAnnotationSection: props.onClickAnnotationSection,
    onDoubleClickHighlight: props.onDoubleClickHighlight,
    onDoubleClickPageLabel: props.onDoubleClickPageLabel,
    onMenu: props.onMenu,
    onDragStart: props.onDragStart,
    onAnnotationEditorBlur: props.onAnnotationEditorBlur
  })) : !props.filter.query.length && !props.readOnly && !window.isWeb && /*#__PURE__*/external_React_default.a.createElement("div", null, /*#__PURE__*/external_React_default.a.createElement(external_ReactIntl_["FormattedMessage"], {
    id: "pdfReader.noAnnotations"
  }))), (!!tags.length || colors.length > 1) && /*#__PURE__*/external_React_default.a.createElement(Selector, {
    tags: tags,
    colors: colors,
    authors: authors,
    onContextMenu: handleSelectorContextMenu,
    onClickTag: handleTagClick,
    onClickColor: handleColorClick,
    onClickAuthor: handleAuthorClick,
    onChange: props.onSelectorChange
  })), containerNode);
});
/* harmony default export */ var annotations_view = (AnnotationsView);
// CONCATENATED MODULE: ./src/components/toolbar.js







function Toolbar(props) {
  const intl = Object(external_ReactIntl_["useIntl"])();

  function getContainerNode() {
    return document.getElementById('toolbarViewerMiddle');
  }

  function handleColorPick(event) {
    props.onColorPick(event.currentTarget.id);
  }

  let {
    toggled,
    color,
    onMode
  } = props;
  let containerNode = getContainerNode();
  return /*#__PURE__*/external_ReactDOM_default.a.createPortal( /*#__PURE__*/external_React_default.a.createElement("div", {
    className: "tool-group annotation-tools"
  }, /*#__PURE__*/external_React_default.a.createElement("button", {
    tabIndex: -1,
    "data-l10n-id": "highlight_tool",
    className: classnames_default()('toolbarButton highlight', {
      toggled: toggled === 'highlight'
    }),
    title: intl.formatMessage({
      id: 'pdfReader.highlightText'
    }),
    onClick: () => {
      onMode('highlight');
    }
  }, /*#__PURE__*/external_React_default.a.createElement("span", {
    className: "button-background"
  })), /*#__PURE__*/external_React_default.a.createElement("button", {
    tabIndex: -1,
    className: classnames_default()('toolbarButton note', {
      toggled: toggled === 'note'
    }),
    title: intl.formatMessage({
      id: 'pdfReader.addNote'
    }),
    onClick: () => {
      onMode('note');
    }
  }, /*#__PURE__*/external_React_default.a.createElement("span", {
    className: "button-background"
  })), /*#__PURE__*/external_React_default.a.createElement("button", {
    tabIndex: -1,
    className: classnames_default()('toolbarButton area', {
      toggled: toggled === 'image'
    }),
    title: intl.formatMessage({
      id: 'pdfReader.selectArea'
    }),
    onClick: () => {
      onMode('image');
    }
  }, /*#__PURE__*/external_React_default.a.createElement("span", {
    className: "button-background"
  })), /*#__PURE__*/external_React_default.a.createElement("button", {
    id: "reader-toolbar-button-color-picker",
    tabIndex: -1,
    className: "toolbarButton global-color",
    style: {
      color
    },
    title: intl.formatMessage({
      id: 'pdfReader.pickColor'
    }),
    onClick: handleColorPick
  }, /*#__PURE__*/external_React_default.a.createElement("span", {
    className: "button-background"
  }), /*#__PURE__*/external_React_default.a.createElement("span", {
    className: "dropmarker"
  }))), containerNode);
}

/* harmony default export */ var toolbar = (Toolbar);
// CONCATENATED MODULE: ./src/components/popup.js





const LEFT_OR_RIGHT_TOOLTIP_CENTER = 20;
const VERTICAL_PADDING = 10;

function Popup({
  id,
  data,
  className,
  children,
  onClose
}) {
  const [position, setPosition] = Object(external_React_["useState"])({
    style: {},
    classes: {}
  });
  const [update, setUpdate] = Object(external_React_["useState"])();
  const containerRef = Object(external_React_["useRef"])();
  Object(external_React_["useEffect"])(() => {
    setUpdate({});
  }, [data]);
  Object(external_React_["useLayoutEffect"])(() => {
    if (update) {
      updatePopupPosition();
    }
  }, [update]);

  function handlePointerDown(event) {
    if (event.target.classList.contains('popup-overlay')) {
      onClose();
    }
  }

  function getContainer() {
    let container = document.getElementById('popupContainer');

    if (!container) {
      let outerContainer = document.getElementById('outerContainer');
      container = document.createElement('div');
      container.dir = document.documentElement.dir;
      container.id = 'popupContainer';
      outerContainer.append(container);
    }

    return container;
  }

  function updatePopupPosition() {
    let horizontal = 'center';
    let vertical = 'bottom';
    let popupWidth = containerRef.current.offsetWidth;
    let popupHeight = containerRef.current.offsetHeight;
    let rect = data.rect;
    let top = rect[3] + VERTICAL_PADDING;
    let left = rect[0] + (rect[2] - rect[0]) / 2 - popupWidth / 2;

    if (left < 0) {
      left = rect[0] + (rect[2] - rect[0]) / 2 - LEFT_OR_RIGHT_TOOLTIP_CENTER;
      horizontal = 'left';
    } else if (left + popupWidth > window.innerWidth) {
      left = rect[0] + (rect[2] - rect[0]) / 2 - (popupWidth - LEFT_OR_RIGHT_TOOLTIP_CENTER);
      horizontal = 'right';
    }

    if (top + popupHeight > window.innerHeight) {
      vertical = 'top';
      top = rect[1] - popupHeight - VERTICAL_PADDING;
    } // If still outside of visible screen area


    if (left < 0) {
      left = 0;
      horizontal = 'left';
    } else if (left + popupWidth > window.innerWidth) {
      left = window.innerWidth - popupWidth;
      horizontal = 'right';
    }

    setPosition({
      style: {
        top,
        left
      },
      classes: {
        ['popup-' + vertical]: true,
        ['popup-' + horizontal]: true
      }
    });
  }

  return /*#__PURE__*/external_ReactDOM_default.a.createPortal( /*#__PURE__*/external_React_default.a.createElement("div", {
    className: "popup-overlay",
    onPointerDown: handlePointerDown
  }, /*#__PURE__*/external_React_default.a.createElement("div", {
    id: id,
    ref: containerRef,
    className: classnames_default()('popup', className, position.classes),
    style: position.style
  }, children)), getContainer());
}

/* harmony default export */ var popup = (Popup);
// CONCATENATED MODULE: ./src/components/label-popup.js






function LabelPopup({
  data,
  onUpdate,
  onClose
}) {
  let [label, setLabel] = Object(external_React_["useState"])(data.pageLabel);
  let [checked, setChecked] = Object(external_React_["useState"])(data.checked);
  let [auto, setAuto] = Object(external_React_["useState"])(false);
  let inputRef = Object(external_React_["useRef"])();
  Object(external_React_["useEffect"])(() => {
    inputRef.current.focus();
    inputRef.current.select();
  }, []);

  function handleUpdateClick() {
    if (auto) {
      onUpdate('auto');
    } else {
      onUpdate(checked, label.trim());
    }
  }

  function handleInputKeydown(event) {
    if (event.key === 'Enter') {
      handleUpdateClick();
    }
  }

  function handleChange(event) {
    setLabel(event.target.value);
  }

  function handleCheckboxChange(event) {
    setAuto(event.target.checked);
  }

  function handleRadioChange(event) {
    setChecked(event.target.value);
  }

  let forceSingle = false;

  if (parseInt(label) != label || parseInt(label) < 1) {
    forceSingle = true;

    if (data.single) {
      checked = 'single';
    } else {
      checked = 'selected';
    }
  }

  let disabled = !label.trim().length;

  if (auto) {
    if (data.all) {
      checked = 'all';
    } else if (data.from) {
      checked = 'from';
    } else if (data.page) {
      checked = 'page';
    } else if (data.selected) {
      checked = 'selected';
    } else if (data.single) {
      checked = 'single';
    }
  }

  return /*#__PURE__*/external_React_default.a.createElement(popup, {
    id: "labelPopup",
    data: data,
    onClose: onClose
  }, /*#__PURE__*/external_React_default.a.createElement("div", {
    className: "row label"
  }, /*#__PURE__*/external_React_default.a.createElement("div", {
    className: "column first"
  }, /*#__PURE__*/external_React_default.a.createElement("input", {
    ref: inputRef,
    type: "text",
    tabIndex: -1,
    className: "toolbarField",
    value: auto ? data.autoPageLabel : label,
    disabled: auto,
    maxLength: 16,
    onChange: handleChange,
    onKeyDown: handleInputKeydown
  })), /*#__PURE__*/external_React_default.a.createElement("div", {
    className: "column second"
  }, /*#__PURE__*/external_React_default.a.createElement("input", {
    id: "renumber-auto-detect",
    type: "checkbox",
    tabIndex: -1,
    checked: auto,
    onChange: handleCheckboxChange
  }), /*#__PURE__*/external_React_default.a.createElement("label", {
    htmlFor: "renumber-auto-detect"
  }, /*#__PURE__*/external_React_default.a.createElement(external_ReactIntl_["FormattedMessage"], {
    id: "pdfReader.autoDetect"
  })))), /*#__PURE__*/external_React_default.a.createElement("fieldset", {
    className: "radio row"
  }, /*#__PURE__*/external_React_default.a.createElement("legend", null, /*#__PURE__*/external_React_default.a.createElement(external_ReactIntl_["FormattedMessage"], {
    id: "pdfReader.pageNumberPopupHeader"
  })), data.single && /*#__PURE__*/external_React_default.a.createElement("div", {
    className: "choice"
  }, /*#__PURE__*/external_React_default.a.createElement("input", {
    type: "radio",
    tabIndex: -1,
    id: "renumber-selected",
    name: "renumber",
    value: "single",
    checked: checked === 'single' && !disabled,
    disabled: disabled || auto,
    onChange: handleRadioChange
  }), /*#__PURE__*/external_React_default.a.createElement("label", {
    htmlFor: "renumber-selected"
  }, /*#__PURE__*/external_React_default.a.createElement(external_ReactIntl_["FormattedMessage"], {
    id: "pdfReader.thisAnnotation"
  }))), data.selected && /*#__PURE__*/external_React_default.a.createElement("div", {
    className: "choice"
  }, /*#__PURE__*/external_React_default.a.createElement("input", {
    type: "radio",
    tabIndex: -1,
    id: "renumber-selected",
    name: "renumber",
    value: "selected",
    checked: checked === 'selected' && !disabled,
    disabled: disabled || auto,
    onChange: handleRadioChange
  }), /*#__PURE__*/external_React_default.a.createElement("label", {
    htmlFor: "renumber-selected"
  }, /*#__PURE__*/external_React_default.a.createElement(external_ReactIntl_["FormattedMessage"], {
    id: "pdfReader.selectedAnnotations"
  }))), data.page && /*#__PURE__*/external_React_default.a.createElement("div", {
    className: "choice"
  }, /*#__PURE__*/external_React_default.a.createElement("input", {
    type: "radio",
    tabIndex: -1,
    id: "renumber-page",
    name: "renumber",
    value: "page",
    checked: checked === 'page',
    disabled: forceSingle || disabled || auto,
    onChange: handleRadioChange
  }), /*#__PURE__*/external_React_default.a.createElement("label", {
    htmlFor: "renumber-page"
  }, /*#__PURE__*/external_React_default.a.createElement(external_ReactIntl_["FormattedMessage"], {
    id: "pdfReader.thisPage"
  }))), data.from && /*#__PURE__*/external_React_default.a.createElement("div", {
    className: "choice"
  }, /*#__PURE__*/external_React_default.a.createElement("input", {
    type: "radio",
    tabIndex: -1,
    id: "renumber-from-page",
    name: "renumber",
    value: "from",
    checked: checked === 'from',
    disabled: forceSingle || disabled || auto,
    onChange: handleRadioChange
  }), /*#__PURE__*/external_React_default.a.createElement("label", {
    htmlFor: "renumber-from-page"
  }, /*#__PURE__*/external_React_default.a.createElement(external_ReactIntl_["FormattedMessage"], {
    id: "pdfReader.thisPageAndLaterPages"
  }))), data.all && /*#__PURE__*/external_React_default.a.createElement("div", {
    className: "choice"
  }, /*#__PURE__*/external_React_default.a.createElement("input", {
    type: "radio",
    tabIndex: -1,
    id: "renumber-all",
    name: "renumber",
    value: "all",
    checked: checked === 'all',
    disabled: forceSingle || disabled || auto,
    onChange: handleRadioChange
  }), /*#__PURE__*/external_React_default.a.createElement("label", {
    htmlFor: "renumber-all"
  }, /*#__PURE__*/external_React_default.a.createElement(external_ReactIntl_["FormattedMessage"], {
    id: "pdfReader.allPages"
  })))), /*#__PURE__*/external_React_default.a.createElement("div", {
    className: "row buttons"
  }, /*#__PURE__*/external_React_default.a.createElement("button", {
    tabIndex: -1,
    className: "overlayButton submit",
    disabled: disabled,
    onClick: handleUpdateClick
  }, /*#__PURE__*/external_React_default.a.createElement(external_ReactIntl_["FormattedMessage"], {
    id: "general.update"
  }))));
}

/* harmony default export */ var label_popup = (LabelPopup);
// CONCATENATED MODULE: ./src/components/drag-preview.js




function getDragCanvas() {
  let node = document.getElementById('drag-canvas');

  if (!node) {
    node = document.createElement('canvas');
    node.id = 'drag-canvas';
    document.body.appendChild(node);
  }

  return {
    canvas: node,
    context: node.getContext('2d')
  };
}

function getDragNoteIcon(rect) {
  let node = document.getElementById('drag-note');

  if (!node) {
    node = document.createElement('div');
    let icon = `
      <svg width="24" height="24" viewBox="0 0 24 24">
        <polygon fill="currentColor" points="0.5 0.5 23.5 0.5 23.5 23.5 11.5 23.5 0.5 12.5 0.5 0.5"/>
        <polygon points="0.5 12.5 11.5 12.5 11.5 23.5 0.5 12.5" fill="#fff" opacity="0.4"/>
        <path d="M0,0V12.707L11.293,24H24V0ZM11,22.293,1.707,13H11ZM23,23H12V12H1V1H23Z"/>
      </svg>`;
    node.id = 'drag-note';
    node.innerHTML = icon;
    document.body.appendChild(node);
  }

  let width = wx(rect);
  let height = hy(rect);
  node.style.width = width + 'px';
  node.style.height = height + 'px';
  return node;
}

function getDragMultiIcon() {
  let node = document.getElementById('drag-multi');

  if (!node) {
    node = document.createElement('div');
    node.id = 'drag-multi';
    document.body.appendChild(node);
  }

  return node;
}

function drawRects(canvas, context, rects, color) {
  let boundingRect = [Math.min(...rects.map(x => x[0])), Math.min(...rects.map(x => x[1])), Math.max(...rects.map(x => x[2])), Math.max(...rects.map(x => x[3]))];
  rects = rects.map(rect => [rect[0] - boundingRect[0], rect[1] - boundingRect[1], rect[2] - boundingRect[0], rect[3] - boundingRect[1]]);
  rects = rects.map(rect => [rect[0], boundingRect[3] - boundingRect[1] - rect[1], rect[2], boundingRect[3] - boundingRect[1] - rect[3]]);
  let width = boundingRect[2] - boundingRect[0];
  let height = boundingRect[3] - boundingRect[1];
  canvas.width = width;
  canvas.height = height;
  context.fillStyle = color;

  for (let rect of rects) {
    context.fillRect(rect[0], rect[1], rect[2] - rect[0], rect[3] - rect[1]);
  }

  return {
    width,
    height
  };
}

function setLayerSelectionDragPreview(event, rects, color, pointerPosition) {
  let {
    canvas,
    context
  } = getDragCanvas();
  drawRects(canvas, context, rects, color);
  let boundingRect = [Math.min(...rects.map(x => x[0])), Math.min(...rects.map(x => x[1])), Math.max(...rects.map(x => x[2])), Math.max(...rects.map(x => x[3]))];
  let x = pointerPosition.rects[0][0] - boundingRect[0];
  let y = pointerPosition.rects[0][1] - boundingRect[1];
  y = boundingRect[3] - boundingRect[1] - y;
  event.dataTransfer.setDragImage(canvas, x, y);
}
function setLayerSingleDragPreview(event, annotation) {
  let br = event.target.getBoundingClientRect();
  let offsetX = event.clientX - br.left;
  let offsetY = event.clientY - br.top;

  if (annotation.type === 'image') {
    let {
      canvas,
      context
    } = getDragCanvas();
    let x = 0;
    let y = 0;
    let img = document.querySelector(`[data-sidebar-annotation-id="${annotation.id}"] img`);

    if (img) {
      let width = 200;
      let height = 200 * img.height / img.width;
      canvas.width = width;
      canvas.height = height;
      context.drawImage(img, 0, 0, width, height);
      let width1 = event.target.offsetWidth;
      let height1 = event.target.offsetHeight;
      x = offsetX * canvas.width / width1;
      y = offsetY * canvas.height / height1;
    } else {
      context.clearRect(0, 0, canvas.width, canvas.height);
    }

    event.dataTransfer.setDragImage(canvas, x, y);
  } else if (annotation.type === 'highlight') {
    let {
      canvas,
      context
    } = getDragCanvas();
    drawRects(canvas, context, annotation.position.rects, annotation.color);
    let width = event.target.offsetWidth - 10;
    let height = event.target.offsetHeight - 10;
    let x = offsetX * canvas.width / width;
    let y = offsetY * canvas.height / height;
    event.dataTransfer.setDragImage(canvas, x, y);
  } else if (annotation.type === 'note') {
    let viewport = window.PDFViewerApplication.pdfViewer.getPageView(annotation.position.pageIndex).viewport;
    let position = coordinates_p2v(annotation.position, viewport);
    let icon = getDragNoteIcon(position.rects[0]);
    let dashedBorderPadding = 5;
    let width = event.target.offsetWidth - dashedBorderPadding * 2;
    let height = event.target.offsetHeight - dashedBorderPadding * 2;
    let x = width / 2;
    let y = height / 2;
    icon.style.color = annotation.color;
    event.dataTransfer.setDragImage(icon, x, y);
  }
}
function setSidebarSingleDragPreview(event) {
  let target = event.target.closest('.preview');
  let br = target.getBoundingClientRect();
  let offsetX = event.clientX - br.left;
  let offsetY = event.clientY - br.top;
  let x = offsetX;
  let y = offsetY;
  event.dataTransfer.setDragImage(event.target.closest('.annotation'), x, y);
}
function setMultiDragPreview(event, num) {
  let icon = getDragMultiIcon();
  event.dataTransfer.setDragImage(icon, 0, 0);
}
// CONCATENATED MODULE: ./src/lib/search.js
/**
 * Approximate string matching in text
 *
 * @param {String} text A text to search for the pattern
 * @param {String} pattern An approximate string to search for
 * @param {Number} maxErrors Maximum errors (Levenshtein distance)
 * @return {Array} An array of matches containing 'start', 'end' and 'errors' parameters
 */
function approximateMatch(text, pattern, maxErrors) {
  /**
   * https://github.com/robertknight/approx-string-match-js
   *
   * Implementation of Myers' online approximate string matching algorithm [1].
   *
   * This has O((k/w) * n) complexity where `n` is the length of the text, `k` is
   * the maximum number of errors allowed (always <= the pattern length) and `w`
   * is the word size. Because JS only supports bitwise operations on 32 bit
   * integers, `w` is 32.
   *
   * As far as I am aware, there aren't any online algorithms which are
   * significantly better for a wide range of input parameters. The problem can be
   * solved faster using "filter then verify" approaches which first filter out
   * regions of the text that cannot match using a "cheap" check and then verify
   * the remaining potential matches. The verify step requires an algorithm such
   * as this one however.
   *
   * The algorithm's approach is essentially to optimize the classic dynamic
   * programming solution to the problem by computing columns of the matrix in
   * word-sized chunks (ie. dealing with 32 chars of the pattern at a time) and
   * avoiding calculating regions of the matrix where the minimum error count is
   * guaranteed to exceed the input threshold.
   *
   * The paper consists of two parts, the first describes the core algorithm for
   * matching patterns <= the size of a word (implemented by `advanceBlock` here).
   * The second uses the core algorithm as part of a larger block-based algorithm
   * to handle longer patterns.
   *
   * [1] G. Myers, “A Fast Bit-Vector Algorithm for Approximate String Matching
   * Based on Dynamic Programming,” vol. 46, no. 3, pp. 395–415, 1999.
   */
  function reverse(s) {
    return s.split('').reverse().join('');
  }

  function fill(ary, x) {
    for (var i = 0; i < ary.length; i += 1) {
      ary[i] = x;
    }

    return ary;
  }
  /**
   * Given the ends of approximate matches for `pattern` in `text`, find
   * the start of the matches.
   *
   * @param findEndFn - Function for finding the end of matches in
   * text.
   * @return Matches with the `start` property set.
   */


  function findMatchStarts(text, pattern, matches, findEndFn) {
    var minCost = Math.min.apply(Math, matches.map(function (m) {
      return m.errors;
    }));
    return matches.filter(function (m) {
      return m.errors === minCost;
    }).map(function (m) {
      // Find start of each match by reversing the pattern and matching segment
      // of text and searching for an approx match with the same number of
      // errors.
      var minStart = Math.max(0, m.end - pattern.length - m.errors);
      var textRev = reverse(text.slice(minStart, m.end));
      var patRev = reverse(pattern); // If there are multiple possible start points, choose the one that
      // maximizes the length of the match.

      var start = findEndFn(textRev, patRev, m.errors).reduce(function (min, rm) {
        if (m.end - rm.end < min) {
          return m.end - rm.end;
        }

        return min;
      }, m.end);
      return {
        start: start,
        end: m.end,
        errors: m.errors
      };
    });
  }
  /**
   * Block calculation step of the algorithm.
   *
   * From Fig 8. on p. 408 of [1].
   *
   * @param b - The block level
   * @param t - Character from the text, represented as
   *        a value in the `ctx.peq` alphabet.
   * @param hIn - Horizontal input delta ∈ {1,0,-1}
   * @return Horizontal output delta
   */


  function advanceBlock(ctx, b, t, hIn) {
    var pV = ctx.P[b];
    var mV = ctx.M[b];
    var eq = ctx.peq[t][b];
    var hOut = 0; // Step 1: Compute horizontal deltas.

    var xV = eq | mV;

    if (hIn < 0) {
      eq |= 1;
    }

    var xH = (eq & pV) + pV ^ pV | eq;
    var pH = mV | ~(xH | pV);
    var mH = pV & xH; // Step 2: Update score (value of last row of this block).

    if (pH & ctx.lastRowMask[b]) {
      hOut += 1;
    } else if (mH & ctx.lastRowMask[b]) {
      hOut -= 1;
    } // Step 3: Update vertical deltas for use when processing next char.


    pH <<= 1;
    mH <<= 1;

    if (hIn < 0) {
      mH |= 1;
    } else if (hIn > 0) {
      pH |= 1;
    }

    pV = mH | ~(xV | pH);
    mV = pH & xV;
    ctx.P[b] = pV;
    ctx.M[b] = mV;
    return hOut;
  }
  /**
   * Find the ends and error counts for matches of `pattern` in `text`.
   *
   * This is the block-based search algorithm from Fig. 9 on p.410 of [1].
   */


  function findMatchEnds(text, pattern, maxErrors) {
    if (pattern.length === 0) {
      return [];
    } // Clamp error count so we can rely on the `maxErrors` and `pattern.length`
    // rows being in the same block below.


    maxErrors = Math.min(maxErrors, pattern.length);
    var matches = []; // Word size.

    var w = 32; // Index of maximum block level.

    var bMax = Math.ceil(pattern.length / w) - 1; // Context used across block calculations.

    var ctx = {
      bMax: bMax,
      P: fill(Array(bMax + 1), 0),
      M: fill(Array(bMax + 1), 0),
      peq: [],
      lastRowMask: fill(Array(bMax + 1), 1 << 31)
    };
    ctx.lastRowMask[bMax] = 1 << (pattern.length - 1) % w; // Calculate `ctx.peq` - the locations of chars within the pattern.

    for (var c = 0; c < text.length; c += 1) {
      var val = text.charCodeAt(c);

      if (ctx.peq[val]) {
        // Duplicate char in text.
        continue;
      } // `ctx.peq[val]` is a bit-array where each int represents a 32-char slice
      // of the pattern.


      ctx.peq[val] = Array(bMax + 1);

      for (var b = 0; b <= bMax; b += 1) {
        ctx.peq[val][b] = 0; // Set all the bits where the pattern matches the current char (ch).
        // For indexes beyond the end of the pattern, always set the bit as if the
        // pattern contained a wildcard char in that position.

        for (var r = 0; r < w; r += 1) {
          var idx = b * w + r;

          if (idx >= pattern.length) {
            continue;
          }

          var match = pattern.charCodeAt(idx) === val;

          if (match) {
            ctx.peq[val][b] |= 1 << r;
          }
        }
      }
    } // Index of last-active block level in the column.


    var y = Math.max(0, Math.ceil(maxErrors / w) - 1); // Initialize maximum error count at bottom of each block.

    var score = [];

    for (var b = 0; b <= y; b += 1) {
      score[b] = (b + 1) * w;
    }

    score[bMax] = pattern.length; // Initialize vertical deltas for each block.

    for (var b = 0; b <= y; b += 1) {
      ctx.P[b] = ~0;
      ctx.M[b] = 0;
    } // Process each char of the text, computing the error count for `w` chars of
    // the pattern at a time.


    for (var j = 0; j < text.length; j += 1) {
      var ch = text.charCodeAt(j); // Calculate error count for blocks that we definitely have to process for
      // this column.

      var carry = 0;

      for (var b = 0; b <= y; b += 1) {
        carry = advanceBlock(ctx, b, ch, carry);
        score[b] += carry;
      } // Check if we also need to compute an additional block, or if we can reduce
      // the number of blocks processed for the next column.


      if (score[y] - carry <= maxErrors && y < ctx.bMax && (ctx.peq[ch][y + 1] & 1 || carry < 0)) {
        // Error count for bottom block is under threshold, increase the number of
        // blocks processed for this column & next by 1.
        y += 1;
        ctx.P[y] = ~0;
        ctx.M[y] = 0;
        var maxBlockScore = y === bMax ? pattern.length % w || w : w;
        score[y] = score[y - 1] + maxBlockScore - carry + advanceBlock(ctx, y, ch, carry);
      } else {
        // Error count for bottom block exceeds threshold, reduce the number of
        // blocks processed for the next column.
        while (y > 0 && score[y] >= maxErrors + w) {
          y -= 1;
        }
      } // If error count is under threshold, report a match.


      if (y === ctx.bMax && score[y] <= maxErrors) {
        matches.push({
          end: j + 1,
          errors: score[y],
          start: -1
        });
      }
    }

    return matches;
  }

  var matches = findMatchEnds(text, pattern, maxErrors);
  return findMatchStarts(text, pattern, matches, findMatchEnds);
}

function searchAnnotations(annotations, query) {
  query = query.toLowerCase();
  let results = [];

  for (let annotation of annotations) {
    let errors = null;
    let match = null;

    if (annotation.text) {
      match = approximateMatch(annotation.text.toLowerCase(), query, Math.floor(query.length / 5));

      if (match.length) {
        errors = Math.min(...match.map(x => x.errors));
      }
    }

    if (annotation.comment) {
      match = approximateMatch(annotation.comment.toLowerCase(), query, Math.floor(query.length / 5));

      if (match.length) {
        let er = Math.min(...match.map(x => x.errors));

        if (errors !== null) {
          errors = Math.min(errors, er);
        } else {
          errors = er;
        }
      }
    }

    if (errors !== null) {
      results.push({
        errors,
        annotation
      });
    }
  }

  results.sort((a, b) => a.errors - b.errors);
  return results.map(x => x.annotation);
}
function filterAnnotations(annotations, filter) {
  let {
    tags,
    colors,
    authors
  } = filter;

  if (tags.length || colors.length || authors.length) {
    annotations = annotations.filter(x => tags && x.tags.some(t => tags.includes(t.name)) || colors && colors.includes(x.color) || authors && authors.includes(x.authorName));
  }

  if (filter.query) {
    annotations = annotations.slice();
    let query = filter.query.toLowerCase();
    let results = [];

    for (let annotation of annotations) {
      let errors = null;
      let match = null;

      if (annotation.text) {
        match = approximateMatch(annotation.text.toLowerCase(), query, Math.floor(query.length / 5));

        if (match.length) {
          errors = Math.min(...match.map(x => x.errors));
        }
      }

      if (annotation.comment) {
        match = approximateMatch(annotation.comment.toLowerCase(), query, Math.floor(query.length / 5));

        if (match.length) {
          let er = Math.min(...match.map(x => x.errors));

          if (errors !== null) {
            errors = Math.min(errors, er);
          } else {
            errors = er;
          }
        }
      }

      if (errors !== null) {
        results.push({
          errors,
          annotation
        });
      }
    }

    annotations = results.sort((a, b) => a.errors - b.errors).map(x => x.annotation);
  }

  return annotations;
}
function cleanFilter(annotations, filter) {
  let {
    query,
    colors,
    tags,
    authors
  } = filter;
  colors = colors.filter(color => annotations.some(a => a.colors.includes(color)));
  tags = tags.filter(tag => annotations.some(a => a.tags.some(x => x.name === tag)));
  authors = authors.filter(author => annotations.some(a => a.authors.includes(author)));
  return {
    query,
    colors,
    tags,
    authors
  };
}
// CONCATENATED MODULE: ./src/components/annotator.js













 // Note: All rects in annotator.js are stored in [left, top, right, bottom] order
// where the Y axis starts from the bottom:
// [231.284, 402.126, 293.107, 410.142]

const NOTE_DIMENSIONS = 22;

function getModifiedSelectionRanges(selectionRanges, modifier) {
  if (!selectionRanges.length) {
    return [];
  }

  let range = selectionRanges.find(x => x.anchor);
  let anchor = {
    pageIndex: range.position.pageIndex,
    offset: range.anchorOffset
  };
  range = selectionRanges.find(x => x.head);
  let head = {
    pageIndex: range.position.pageIndex,
    offset: range.headOffset
  };

  if (modifier === 'left') {
    head.offset--;
  } else if (modifier === 'right') {
    head.offset++;
  } else if (modifier === 'up') {
    head.offset = window.extractor.getPrevLineClosestOffset(head.pageIndex, head.offset);

    if (head.offset === null) {
      return [];
    }
  } else if (modifier === 'down') {
    head.offset = window.extractor.getNextLineClosestOffset(head.pageIndex, head.offset);

    if (head.offset === null) {
      return [];
    }
  } else if (typeof modifier === 'object') {
    let position = modifier;
    head = position;
  }

  return getSelectionRanges(anchor, head);
}

function getWordSelectionRanges(anchorPosition, headPosition) {
  let anchorWord = window.extractor.getClosestWord(anchorPosition);
  let headWord = window.extractor.getClosestWord(headPosition);

  if (!anchorWord || !headWord) {
    return [];
  }

  let anchor = {
    pageIndex: anchorPosition.pageIndex
  };
  let head = {
    pageIndex: headPosition.pageIndex
  };

  if (anchorWord.anchorOffset < headWord.anchorOffset && anchor.pageIndex === head.pageIndex || anchor.pageIndex < head.pageIndex) {
    anchor.offset = anchorWord.anchorOffset;
    head.offset = headWord.headOffset;
  } else {
    anchor.offset = anchorWord.headOffset;
    head.offset = headWord.anchorOffset;
  }

  return getSelectionRanges(anchor, head);
}

function getLineSelectionRanges(anchorPosition, headPosition) {
  let anchorLine = window.extractor.getClosestLine(anchorPosition);
  let headLine = window.extractor.getClosestLine(headPosition);

  if (!anchorLine || !headLine) {
    return [];
  }

  let anchor = {
    pageIndex: anchorPosition.pageIndex
  };
  let head = {
    pageIndex: headPosition.pageIndex
  };

  if (anchorLine.anchorOffset < headLine.anchorOffset && anchor.pageIndex === head.pageIndex || anchor.pageIndex < head.pageIndex) {
    anchor.offset = anchorLine.anchorOffset;
    head.offset = headLine.headOffset;
  } else {
    anchor.offset = anchorLine.headOffset;
    head.offset = headLine.anchorOffset;
  }

  return getSelectionRanges(anchor, head);
}

function getSelectionRanges(anchor, head) {
  let selectionRanges = [];
  let fromPageIndex = Math.min(anchor.pageIndex, head.pageIndex);
  let toPageIndex = Math.max(anchor.pageIndex, head.pageIndex);
  let reverse = anchor.pageIndex > head.pageIndex;

  for (let i = fromPageIndex; i <= toPageIndex; i++) {
    let a, h;

    if (i === anchor.pageIndex) {
      a = anchor.offset !== undefined ? anchor.offset : [anchor.rects[0][0], anchor.rects[0][1]];
    }

    if (i === head.pageIndex) {
      h = head.offset !== undefined ? head.offset : [head.rects[0][0], head.rects[0][1]];
    }

    let selectionRange = window.extractor.extractRange({
      pageIndex: i,
      anchor: a,
      head: h,
      reverse
    });

    if (!selectionRange) {
      return [];
    }

    if (i === anchor.pageIndex) {
      selectionRange.anchor = true;
    }

    if (i === head.pageIndex) {
      selectionRange.head = true;
    }

    if (!selectionRange.collapsed) {
      // We can synchronously get page viewbox from page view, because it's already loaded when selecting
      let pageHeight = PDFViewerApplication.pdfViewer.getPageView(selectionRange.position.pageIndex).viewport.viewBox[3];
      let top = pageHeight - selectionRange.position.rects[0][3];

      if (top < 0) {
        top = 0;
      } // TODO: Unify all annotations sort index calculation


      let offset = Math.min(selectionRange.anchorOffset, selectionRange.headOffset);
      selectionRange.sortIndex = [i.toString().slice(0, 5).padStart(5, '0'), offset.toString().slice(0, 6).padStart(6, '0'), Math.floor(top).toString().slice(0, 5).padStart(5, '0')].join('|');
    }

    selectionRanges.push(selectionRange);
  }

  return selectionRanges;
}

class annotator_FocusManager {
  constructor(options) {
    defineProperty_default()(this, "onFocus", event => {
      if (event.target === window) {
        return;
      }

      this.zone = null;

      if (event.target.id === 'viewerContainer') {
        if (this.options.selectedIDsRef.current.length) {
          this.zone = this.zones.find(x => x.id === 'view-annotation');
        }

        return;
      }

      loop1: for (let zone of this.zones) {
        let nodes = Array.from(document.querySelectorAll(zone.selector)).reverse();

        for (let node of nodes) {
          if (event.target === node) {
            this.zone = zone;
            break loop1;
          }
        }
      }

      if (!['annotations', 'viewerContainer'].includes(event.target.id) && (!this.zone || !this.zone.id.includes('annotation') && !this.zone.id.includes('label-'))) {
        if (event.target.nodeType !== Node.DOCUMENT_NODE) {
          this.options.selectAnnotation();
        }
      }

      if (!this.zone || !['label-popup-input', 'label-popup-checkbox', 'label-popup-radios', 'label-popup-button'].includes(this.zone.id)) {
        this.options.setLabelPopup(null);
      }

      if (this.zone && this.zone.id !== 'popup-selection') {
        this.options.setSelectionRangesRef([]);
      }

      if (event.target.nodeType === Node.ELEMENT_NODE && !event.target.closest('#findbar') && PDFViewerApplication.findBar.opened && !PDFViewerApplication.findBar.findField.value) {
        PDFViewerApplication.findBar.close();
      }
    });

    defineProperty_default()(this, "tabToolbar", reverse => {
      this.zone = this.zones.find(x => x.id === 'toolbar');
      this.tab(reverse);
    });

    defineProperty_default()(this, "focusFirst", () => {
      let zones = this.zones.slice();

      for (let zone of zones) {
        if (PDFViewerApplication.pdfSidebar.isOpen && zone.id === 'view-annotation') {
          continue;
        }

        if (document.querySelector(zone.selector)) {
          this.focus(zone.id);
          return;
        }
      }
    });

    this.options = options;
    this.zone = null;
    this.zones = [{
      id: 'label-popup-input',
      selector: '#labelPopup input[type="text"]'
    }, {
      id: 'label-popup-checkbox',
      selector: '#labelPopup input[type="checkbox"]'
    }, {
      id: 'label-popup-radios',
      selector: '#labelPopup input[type="radio"]'
    }, {
      id: 'label-popup-button',
      selector: '#labelPopup button'
    }, {
      id: 'popup-selection',
      selector: '#selection-menu [tabindex="-1"]'
    }, {
      id: 'toolbar',
      selector: '#toolbarViewer [tabindex="-1"]:not(:disabled)'
    }, {
      id: 'findbar-input',
      selector: '#findbar:not(.hidden) #findInput'
    }, {
      id: 'findbar-navigation',
      selector: '#findbar:not(.hidden) #findbarInputContainer .splitToolbarButton button'
    }, {
      id: 'findbar-options',
      selector: '#findbar:not(.hidden) #findOptions input'
    }, {
      id: 'sidebar-buttons',
      selector: '#outerContainer.sidebarOpen #toolbarSidebar button:not(:disabled)'
    }, {
      id: 'sidebar-search',
      selector: '#outerContainer.sidebarOpen #annotationsView:not(.hidden) #searchInput'
    }, {
      id: 'sidebar-thumbnails',
      selector: '#outerContainer.sidebarOpen #thumbnailView:not(.hidden) a'
    }, {
      id: 'sidebar-outline',
      selector: '#outerContainer.sidebarOpen #outlineView:not(.hidden) > .treeItem > a, #outerContainer.sidebarOpen #outlineView:not(.hidden) .treeItemToggler:not(.treeItemsHidden) ~ .treeItems > .treeItem > a'
    }, {
      id: 'sidebar-annotation',
      selector: '#outerContainer.sidebarOpen #annotationsView:not(.hidden) #annotations .annotation'
    }, {
      id: 'sidebar-annotation-dots',
      selector: '#outerContainer.sidebarOpen #annotationsView:not(.hidden) .annotation.selected .preview:not(.read-only) .more'
    }, {
      id: 'sidebar-annotation-highlight',
      selector: '#outerContainer.sidebarOpen #annotationsView:not(.hidden) .annotation.selected .preview:not(.read-only) .highlight .content[contenteditable="true"]'
    }, {
      id: 'sidebar-annotation-comment',
      selector: '#outerContainer.sidebarOpen #annotationsView:not(.hidden) .annotation.selected .preview:not(.read-only) .comment .content'
    }, {
      id: 'sidebar-annotation-tags',
      selector: '#outerContainer.sidebarOpen #annotationsView:not(.hidden) .annotation.selected .preview:not(.read-only) .tags'
    }, {
      id: 'sidebar-selector',
      selector: '#outerContainer.sidebarOpen #annotationsView:not(.hidden) #selector [tabindex="-1"]'
    }, {
      id: 'view-annotation',
      selector: '#viewerContainer'
    }, {
      id: 'view-annotation-dots',
      selector: '#outerContainer:not(.sidebarOpen) #viewerContainer .preview:not(.read-only) .more'
    }, {
      id: 'view-annotation-comment',
      selector: '#outerContainer:not(.sidebarOpen) #viewerContainer .preview:not(.read-only) .comment .content'
    }, {
      id: 'view-annotation-tags',
      selector: '#outerContainer:not(.sidebarOpen) #viewerContainer .preview:not(.read-only) .tags'
    }];
    window.addEventListener('focus', this.onFocus, true);
  }

  focus(id) {
    if (!id) {
      document.getElementById('viewerContainer').focus();
      this.options.selectAnnotation();
      this.zone = null;
      return;
    }

    let zone = this.zones.find(x => x.id === id);

    if (id === 'view-annotation') {
      let annotation = this.options.getFirstVisibleAnnotation();

      if (annotation) {
        if (!this.options.selectedIDsRef.current.length) {
          this.options.selectAnnotation({
            id: annotation.id
          });
        }

        document.getElementById('viewerContainer').focus();
      } else {
        this.focus();
        return;
      }
    } else if (id === 'sidebar-annotation') {
      let annotationID = this.options.selectedIDsRef.current.slice(-1)[0] || document.querySelector('#annotations .annotation').getAttribute('data-sidebar-annotation-id');

      if (annotationID) {
        this.options.selectAnnotation({
          id: annotationID,
          selectInSidebar: true
        });
        let node = document.querySelector(`[data-sidebar-annotation-id="${annotationID}"]`);

        if (node) {
          node.focus();
        }
      }
    } else if (id === 'sidebar-buttons') {
      Array.from(document.querySelectorAll(zone.selector)).find(x => x.classList.contains('toggled')).focus();
    } else if (id === 'sidebar-thumbnails') {
      document.querySelector(zone.selector).focus();
      document.querySelector(zone.selector).click();
    } else {
      document.querySelector(zone.selector).focus();
    }

    this.zone = zone;
  }

  tab(reverse) {
    let zones = this.zones.slice();

    if (reverse) {
      zones.reverse();
    }

    let idx = zones.indexOf(this.zone);

    for (let i = idx + 1; i < zones.length; i++) {
      let zone = zones[i];

      if (PDFViewerApplication.pdfSidebar.isOpen && zone.id === 'view-annotation') {
        continue;
      }

      if (document.querySelector(zone.selector)) {
        this.focus(zone.id);
        return true;
      }
    }

    this.focus(null);
    return true;
  }

  next(reverse, shift) {
    if (this.zone.id === 'view-annotation') {
      let annotations = this.options.annotationsRef.current;

      if (reverse) {
        annotations = annotations.slice().reverse();
      }

      let lastID = this.options.selectedIDsRef.current.slice(-1)[0];

      if (lastID) {
        let annotationIndex = annotations.findIndex(x => x.id === lastID);

        if (annotations.length > annotationIndex + 1) {
          let nextAnnotation = annotations[annotationIndex + 1];
          let nextID = nextAnnotation.id;
          this.options.selectAnnotation({
            id: nextID,
            shift,
            scrollSidebar: true,
            scrollViewer: true
          });
        }
      }

      return;
    }

    let nodes = Array.from(document.querySelectorAll(this.zone.selector));

    if (reverse) {
      nodes = nodes.reverse();
    }

    let focus = node => {
      node.focus();

      if (node.id === 'pageNumber') {
        setTimeout(() => node.select(), 0);
      }

      if (this.zone.id === 'sidebar-buttons') {
        node.click();
      } else if (this.zone.id === 'sidebar-annotation') {
        let id = node.getAttribute('data-sidebar-annotation-id');
        this.options.selectAnnotation({
          id,
          shift,
          scrollSidebar: true,
          scrollViewer: true,
          selectInSidebar: true
        });
      } else if (this.zone.id === 'sidebar-thumbnails') {
        node.click();
      }
    };

    let canFocus = false;

    for (let node of nodes) {
      if (canFocus) {
        focus(node);
        canFocus = false;
        break;
      }

      if (node === document.activeElement) {
        canFocus = true;
      }
    }
  }

  isFirstZone() {
    let zones = this.zones.slice();

    for (let zone of zones) {
      if (PDFViewerApplication.pdfSidebar.isOpen && zone.id === 'view-annotation') {
        continue;
      }

      if (document.querySelector(zone.selector)) {
        if (this.zone === zone) {
          return true;
        }

        return false;
      }
    }

    return false;
  }

}

const Annotator = /*#__PURE__*/external_React_default.a.forwardRef((props, ref) => {
  // useRefState synchronously sets ref value and asynchronously sets state value.
  // Annotator component uses reference variables everywhere to immediately access
  // the latest value and eliminate the complexity of rebinding custom events.
  // useRefState state variables are used only for rendering
  const [_filter, filterRef, setFilter] = useRefState({
    query: '',
    colors: [],
    tags: [],
    authors: []
  });
  const [_annotations, annotationsRef, setAnnotations] = useRefState([]);
  const [_allAnnotations, allAnnotationsRef, setAllAnnotations] = useRefState([]);
  const [_selectedIDs, selectedIDsRef, setSelectedIDs] = useRefState([]);
  const [_expansionState, expansionStateRef, setExpansionState] = useRefState(0);
  const [_mode, modeRef, setMode] = useRefState(null);
  const [_color, colorRef, setColor] = useRefState(annotationColors[0][1]);
  const [_selectionPositions, selectionPositionsRef, setSelectionPositions] = useRefState([]);
  const [_enableSelection, enableSelectionRef, setEnableSelection] = useRefState(false);
  const [_blink, blinkRef, setBlink] = useRefState(null);
  const [_isSidebarOpen, isSidebarOpenRef, setIsSidebarOpen] = useRefState(window.PDFViewerApplication.pdfSidebar.isOpen);
  const [_isSelectingText, isSelectingTextRef, setIsSelectingText] = useRefState(false);
  const [_draggingAnnotationIDs, draggingAnnotationIDsRef, setDraggingAnnotationIDs] = useRefState([]);
  const [_isPopupDisabled, isPopupDisabledRef, setIsPopupDisabled] = useRefState(false);
  const [_isSelectingArea, isSelectingAreaRef, setIsSelectingArea] = useRefState(false);
  const [_isResizingArea, isResizingAreaRef, setIsResizingArea] = useRefState(false);
  const [_isLastClickRight, isLastClickRightRef, setIsLastClickRight] = useRefState(false);
  const [_isSelectedOnPointerDown, isSelectedOnPointerDownRef, setIsSelectedOnPointerDown] = useRefState(false);
  const [_enableAddToNote, enableAddToNote, setEnableAddToNote] = useRefState(false);
  const [_labelPopup, labelPopup, setLabelPopup] = useRefState(null);
  const lastSelectedAnnotationIDRef = Object(external_React_["useRef"])(null);
  const pointerDownPositionRef = Object(external_React_["useRef"])(null);
  const selectionRangesRef = Object(external_React_["useRef"])([]);
  const selectionMode = Object(external_React_["useRef"])('chars');
  const focusManagerRef = Object(external_React_["useRef"])(null);
  const annotationCommentTouched = Object(external_React_["useRef"])(false);
  Object(external_React_["useEffect"])(() => {
    focusManagerRef.current = new annotator_FocusManager({
      selectedIDsRef,
      selectAnnotation,
      annotationsRef,
      setSelectionRangesRef,
      getFirstVisibleAnnotation,
      setLabelPopup,
      lastSelectedAnnotationIDRef
    });
  }, []);
  Object(external_React_["useImperativeHandle"])(ref, () => ({
    navigate,
    setAnnotations: annotations => {
      external_ReactDOM_default.a.unstable_batchedUpdates(() => {
        setAllAnnotations(annotations);
        let filter = cleanFilter(annotations, filterRef.current);
        setFilter(filter);
        let filteredAnnotations = filterAnnotations(annotations, filter);
        setAnnotations(filteredAnnotations);

        if (filteredAnnotations.length !== annotationsRef.current.length) {
          setSelectedIDs([]);
          props.onClosePopup();
        }
      });
    },
    setColor,
    setEnableAddToNote,
    openPageLabelPopup,
    editHighlightedText,
    clearFilter: () => {
      setFilter({ ...filterRef.current,
        colors: [],
        tags: [],
        authors: []
      });
      setAnnotations(allAnnotationsRef.current);
    },
    tabToolbar: reverse => focusManagerRef.current.tabToolbar(reverse),
    focusFirst: () => focusManagerRef.current.focusFirst()
  }));

  function getFirstVisibleAnnotation() {
    for (let annotation of annotationsRef.current) {
      let {
        pageIndex
      } = annotation.position;
      let {
        div,
        viewport
      } = PDFViewerApplication.pdfViewer.getPageView(pageIndex);
      let position = coordinates_p2v(annotation.position, viewport);
      let rectMax = getPositionBoundingRect(position);
      let viewerScrollLeft = PDFViewerApplication.pdfViewer.container.scrollLeft;
      let viewerScrollTop = PDFViewerApplication.pdfViewer.container.scrollTop;
      let viewerWidth = PDFViewerApplication.pdfViewer.container.offsetWidth;
      let viewerHeight = PDFViewerApplication.pdfViewer.container.offsetHeight;
      let visibleRect = [viewerScrollLeft, viewerScrollTop - 10, viewerScrollLeft + viewerWidth, viewerScrollTop + viewerHeight];

      function quickIntersectRect(r1, r2) {
        return !(r2[0] > r1[2] || r2[2] < r1[0] || r2[1] > r1[3] || r2[3] < r1[1]);
      }

      rectMax = [div.offsetLeft + rectMax[0], div.offsetTop + rectMax[1], div.offsetLeft + rectMax[2], div.offsetTop + rectMax[3]];

      if (quickIntersectRect(visibleRect, rectMax)) {
        return annotation;
        break;
      }
    }
  }

  window.getFirstVisibleAnnotation = getFirstVisibleAnnotation;

  function setSelectionRangesRef(ranges) {
    setSelectionPositions(ranges.filter(x => !x.collapsed).map(x => x.position));
    selectionRangesRef.current = ranges;
  }

  function hasSelection() {
    return !!selectionRangesRef.current.filter(x => !x.collapsed).length;
  }

  function scrollSidebarTo(id) {
    let sidebarItem = document.querySelector(`[data-sidebar-annotation-id="${id}"]`);
    let container = document.getElementById('annotationsView');

    if (sidebarItem && container) {
      if (window.PDFViewerApplication.pdfSidebar.isOpen && window.PDFViewerApplication.pdfSidebar.active !== 9) {
        window.PDFViewerApplication.pdfSidebar.switchView(9);
      }

      setTimeout(() => {
        sidebarItem.scrollIntoView({
          behavior: 'smooth',
          block: 'nearest',
          inline: 'nearest'
        });
      }, 50);
    }
  }

  function scrollViewerTo(position) {
    let rect = getPositionBoundingRect(position);
    let spacing = 30;
    rect = [rect[0] - spacing, rect[1] - spacing, rect[2] + spacing, rect[3] + spacing];
    window.PDFViewerApplication.pdfLinkService.goToDestination([position.pageIndex, {
      name: 'FitR'
    }, ...rect]);
  }

  function scrollTo(location, sidebar, viewer) {
    if (sidebar && location.id) {
      scrollSidebarTo(location.id);
    }

    if (viewer && location.position) {
      scrollViewerTo(location.position);
    }
  }

  let navigate = location => {
    let id = location.id || location.annotationKey;
    let annotation = id && annotationsRef.current.find(x => x.id === id);

    if (annotation) {
      makeBlink(annotation.position);
      scrollTo({
        id,
        position: annotation.position
      }, true, true);
      return;
    }

    if (Number.isInteger(location.pageIndex)) {
      window.PDFViewerApplication.pdfViewer.scrollPageIntoView({
        pageNumber: location.pageIndex + 1
      });
      return;
    }

    if (location.pageLabel) {
      (async function () {
        let pageIndex = await window.extractor.getPageIndexByLabel(location.pageLabel);

        if (pageIndex !== null) {
          window.PDFViewerApplication.pdfViewer.scrollPageIntoView({
            pageNumber: pageIndex + 1
          });
        }
      })();

      return;
    }

    makeBlink(location.position);
    scrollTo(location, true, true);
  };

  function makeBlink(position) {
    setBlink({
      id: Math.random(),
      position: position
    });
  }

  Object(external_React_["useEffect"])(() => {
    document.getElementById('viewer').setAttribute('draggable', true); // viewer.eventBus.off('pagesinit', onDocumentReady);

    window.addEventListener('keydown', handleKeyDown, true);
    window.addEventListener('pointerup', handlePointerUp);
    window.addEventListener('pointerdown', handlePointerDown);
    window.addEventListener('dragend', handleDragEnd);
    window.addEventListener('dragstart', handleDragStart);
    window.addEventListener('copy', handleCopy);
    window.PDFViewerApplication.eventBus.on('sidebarviewchanged', handleSidebarViewChange);
    window.PDFViewerApplication.eventBus.on('pagerendered', handlePageRendered);
    return () => {
      window.removeEventListener('keydown', handleKeyDown);
      window.removeEventListener('pointerup', handlePointerUp);
      window.removeEventListener('pointerdown', handlePointerDown);
      window.removeEventListener('dragend', handleDragEnd);
      window.removeEventListener('dragstart', handleDragStart);
      window.removeEventListener('copy', handleCopy);
      window.PDFViewerApplication.eventBus.off('sidebarviewchanged', handleSidebarViewChange);
      window.PDFViewerApplication.eventBus.off('pagerendered', handlePageRendered);
    };
  }, []);

  let focusSidebarHighlight = annotationID => {
    setTimeout(function () {
      let content = document.querySelector(`[data-sidebar-annotation-id="${annotationID}"] .highlight .content`);

      if (content) {
        setCaretToEnd(content);
      }
    }, 100);
  };

  let focusComment = annotationID => {
    setTimeout(function () {
      let content;

      if (PDFViewerApplication.pdfSidebar.isOpen) {
        content = document.querySelector(`[data-sidebar-annotation-id="${annotationID}"] .comment .content`);
      } else {
        content = document.querySelector(`#pagePopupContainer .comment .content`);
      }

      if (content) {
        setCaretToEnd(content);
      }
    }, 100);
  };

  const handleKeyDown = Object(external_React_["useCallback"])(e => {
    let isMod = e.ctrlKey || e.metaKey;
    let isCtrl = e.ctrlKey;
    let isCmd = e.metaKey && isMac();
    let isAlt = e.altKey;
    let isShift = e.shiftKey; // Pass through hand/select tool shortcuts

    if (['h', 's'].includes(e.key)) {
      // PDF.js skips h and s keys if they were pressed when focused an input,
      // but we have to allow this when selectionBox is focused
      if (e.target === window.selectionBox) {
        e.target.blur();
      }

      return;
    } // Allow 'copy' event to be triggered


    if (isMod && e.key === 'c' && focusManagerRef.current.zone && ['sidebar-annotation', 'view-annotation'].includes(focusManagerRef.current.zone.id)) {
      return;
    }

    if (isMod && e.key === 'i' && focusManagerRef.current.zone && ['sidebar-annotation-highlight', 'sidebar-annotation-comment', 'view-annotation-comment'].includes(focusManagerRef.current.zone.id)) {
      document.execCommand('italic', false, null);
      return;
    }

    if (isMod && e.key === 'b' && focusManagerRef.current.zone && ['sidebar-annotation-highlight', 'sidebar-annotation-comment', 'view-annotation-comment'].includes(focusManagerRef.current.zone.id)) {
      document.execCommand('bold', false, null);
      return;
    } // Tab, Shift-Tab, Escape work everywhere and allow to switch between focus zones and PDF view


    if (isShift && e.key === 'Tab') {
      if (focusManagerRef.current.isFirstZone()) {
        props.onFocusContextPane();
        e.preventDefault();
        return;
      }

      focusManagerRef.current.tab(true);
      e.preventDefault();
    } else if (e.key === 'Tab') {
      if (!focusManagerRef.current.zone) {
        props.onFocusContextPane();
        e.preventDefault();
        return;
      }

      focusManagerRef.current.tab();
      e.preventDefault();
    } else if (e.key === 'Escape') {
      PDFViewerApplication.pdfCursorTools.switchTool(0);
      PDFViewerApplication.findBar.close();
      PDFViewerApplication.findBar.findField.value = ''; // Focus PDF view

      focusManagerRef.current.focus();

      if (selectedIDsRef.current.length) {
        selectAnnotation();
      } else if (modeRef.current) {
        setMode(null);
      }

      setSelectionRangesRef([]);
      setEnableSelection(false);
      setLabelPopup(null);
      document.getElementById('viewerContainer').focus();
      focusManagerRef.current.zone = null; // Sometimes everything gets selected on Firefox when pressing escape here

      clearSelection();
    }

    if (!focusManagerRef.current.zone || ['sidebar-annotation', 'view-annotation'].includes(focusManagerRef.current.zone.id)) {
      if (isAlt && e.code === 'Digit1') {
        toggleMode('highlight');
      } else if (isAlt && e.code === 'Digit2') {
        toggleMode('note');
      } else if (isAlt && e.code === 'Digit3') {
        toggleMode('image');
      } else if (isAlt && e.code === 'Digit4') {
        let idx = annotationColors.findIndex(x => x[1] === colorRef.current);

        if (idx === annotationColors.length - 1) {
          idx = 0;
        } else {
          idx++;
        }

        setColor(annotationColors[idx][1]);
      }
    } // Focused any zone that is not PDF view


    let lastSelectedAnnotation = annotationsRef.current.find(x => x.id === lastSelectedAnnotationIDRef.current);

    if (focusManagerRef.current.zone) {
      if (['sidebar-annotation-comment', 'view-annotation-comment'].includes(focusManagerRef.current.zone.id) && !['Backspace', 'Delete', 'ArrowUp', 'ArrowDown'].includes(e.key)) {
        annotationCommentTouched.current = true;
      }

      if (!window.rtl && e.key === 'ArrowRight' || window.rtl && e.key === 'ArrowLeft' || e.key === 'ArrowDown') {
        let findButton = document.getElementById('viewFind');

        if (focusManagerRef.current.zone.id === 'toolbar' && document.activeElement === findButton) {
          props.onFocusSplitButton();
          e.preventDefault();
          e.stopPropagation();
          return;
        } // Allow navigating to next/previous annotation if empty comment was just automatically focused


        if (['sidebar-annotation-comment'].includes(focusManagerRef.current.zone.id) && !annotationCommentTouched.current && lastSelectedAnnotation && !lastSelectedAnnotation.comment) {
          let node = document.querySelector(`[data-sidebar-annotation-id="${lastSelectedAnnotationIDRef.current}"]`);

          if (node) {
            node.focus();
          }
        }

        if (['view-annotation-comment'].includes(focusManagerRef.current.zone.id) && !annotationCommentTouched.current) {
          focusManagerRef.current.zone = focusManagerRef.current.zones.find(x => x.id === 'view-annotation');
        }

        focusManagerRef.current.next(false, isShift);
      } else if (!window.rtl && e.key === 'ArrowLeft' || window.rtl && e.key === 'ArrowRight' || e.key === 'ArrowUp') {
        // Allow to navigate to next/previous annotation if empty comment was just automatically focused
        if (['sidebar-annotation-comment'].includes(focusManagerRef.current.zone.id) && !annotationCommentTouched.current && lastSelectedAnnotation && !lastSelectedAnnotation.comment) {
          let node = document.querySelector(`[data-sidebar-annotation-id="${lastSelectedAnnotationIDRef.current}"]`);

          if (node) {
            node.focus();
          }
        }

        if (['view-annotation-comment'].includes(focusManagerRef.current.zone.id) && !annotationCommentTouched.current) {
          focusManagerRef.current.zone = focusManagerRef.current.zones.find(x => x.id === 'view-annotation');
        }

        focusManagerRef.current.next(true, isShift);
      } else if ((e.key === ' ' || e.key === 'Enter') && document.activeElement && document.activeElement.nodeName === 'A') {
        let prev = document.activeElement.previousElementSibling;

        if (e.key === 'Enter' && prev.classList.contains('treeItemToggler')) {
          prev.click();
        } else {
          document.activeElement.click();
        }
      } else if ((e.key === 'Delete' || e.key === 'Backspace') && !e.repeat) {
        // TODO: Auto-select the next annotation after deletion in sidebar
        let id = selectedIDsRef.current[0];
        let annotation = annotationsRef.current.find(x => x.id === id);
        let hasReadOnly = !!annotationsRef.current.find(x => selectedIDsRef.current.includes(x.id) && x.readOnly);

        if (!hasReadOnly) {
          if (['sidebar-annotation', 'view-annotation'].includes(focusManagerRef.current.zone.id)) {
            props.onDeleteAnnotations(selectedIDsRef.current);
          } else if (['sidebar-annotation-comment', 'view-annotation-comment'].includes(focusManagerRef.current.zone.id) && annotation && !annotation.comment && !annotationCommentTouched.current) {
            props.onDeleteAnnotations([id]);
          }
        }
      } else if (['sidebar-annotation', 'sidebar-selector', 'sidebar-search', 'view-annotation'].includes(focusManagerRef.current.zone.id) && isMod && e.key === 'a') {
        setSelectedIDs(annotationsRef.current.map(x => x.id));
        e.preventDefault();
      } // Don't bypass keys if focus isn't on an input, contenteditable or button (only for Space),
      // and isn't a modifier, and isn't SHIFT or if it is, then at least it's not an arrow key


      if (!(document.activeElement.nodeName === 'INPUT' && ['text', 'number'].includes(document.activeElement.type) || document.activeElement.getAttribute('contenteditable') || e.key === ' ' && document.activeElement.nodeName === 'BUTTON') && !isMod && !isAlt && (!isShift || ['ArrowUp', 'ArrowDown', 'ArrowLeft', 'ArrowRight'].includes(e.key))) {
        e.preventDefault();
        e.stopPropagation();
      } // Prevent up/down page switching when cursor in page number input


      if (document.activeElement.id === 'pageNumber' && ['ArrowUp', 'ArrowDown'].includes(e.key)) {
        e.preventDefault();
        e.stopPropagation();
      }
    } // PDF view is focused
    else {
      // This is not ideal, but the goal is to keep focus on `selectionBox`
      // when a speak out keyboard shortcut is pressed, and focus to
      // `viewerContainer` when other keys are pressed
      if (document.activeElement === window.selectionBox && !isMod && !isAlt && !isShift) {
        document.getElementById('viewerContainer').focus();
      } // Prevent Mod + A, as it selects random things in viewer container and makes them draggable


      if (isMod && !isShift && e.key === 'a') {
        setSelectedIDs(annotationsRef.current.map(x => x.id));
        e.preventDefault();
      } // Prevent "open file", "download file" PDF.js keyboard shortcuts
      // https://github.com/mozilla/pdf.js/wiki/Frequently-Asked-Questions#faq-shortcuts
      else if (isMod && ['o', 's'].includes(e.key)) {
        e.stopPropagation();
        e.preventDefault();
      } else if (isMod && isAlt && e.key === 'p') {
        e.stopPropagation();
      } else if ((isCmd || isCtrl && isLinux()) && e.key === '[' || (isAlt && !isMac() || isCmd) && e.key === 'ArrowLeft') {
        window.history.back();
      } else if ((isCmd || isCtrl && isLinux()) && e.key === ']' || (isAlt && !isMac() || isCmd) && e.key === 'ArrowRight') {
        window.history.forward();
      } else if (isShift && selectionRangesRef.current.length) {
        if (e.key === 'ArrowLeft') {
          let selectionRanges = getModifiedSelectionRanges(selectionRangesRef.current, 'left');
          setSelectionRangesRef(selectionRanges);
        } else if (e.key === 'ArrowRight') {
          let selectionRanges = getModifiedSelectionRanges(selectionRangesRef.current, 'right');
          setSelectionRangesRef(selectionRanges);
        } else if (e.key === 'ArrowUp') {
          let selectionRanges = getModifiedSelectionRanges(selectionRangesRef.current, 'up');
          setSelectionRangesRef(selectionRanges);
        } else if (e.key === 'ArrowDown') {
          let selectionRanges = getModifiedSelectionRanges(selectionRangesRef.current, 'down');
          setSelectionRangesRef(selectionRanges);
        }
      }
    }
  }, []);
  const handleCopy = Object(external_React_["useCallback"])(event => {
    if (!focusManagerRef.current.zone || ['sidebar-annotation', 'view-annotation'].includes(focusManagerRef.current.zone.id) // Allow copying an annotation when comment text box is focused, but it's empty
    || ['sidebar-annotation-comment', 'view-annotation-comment'].includes(focusManagerRef.current.zone.id) && selectedIDsRef.current.length === 1 && annotationsRef.current.filter(x => selectedIDsRef.current.includes(x.id)).some(x => !x.comment)) {
      let annotations = [];

      if (hasSelection()) {
        annotations = getAnnotationsFromSelectionRanges(selectionRangesRef.current);
      } else if (selectedIDsRef.current.length) {
        annotations = annotationsRef.current.filter(x => selectedIDsRef.current.includes(x.id));
      }

      if (annotations.length) {
        setDataTransferAnnotations(event.clipboardData, annotations);
      }

      event.preventDefault();
    }
  }, []);
  const handleDragEnd = Object(external_React_["useCallback"])(event => {
    setEnableSelection(false);
    setDraggingAnnotationIDs([]);
  }, []);
  const handleSidebarViewChange = Object(external_React_["useCallback"])(event => {
    // Delay until sidebar finishes transitioning
    // and allows us to properly position page popup
    if (event.view === 0) {
      setTimeout(() => {
        setIsSidebarOpen(window.PDFViewerApplication.pdfSidebar.isOpen);
      }, 300);
    } else {
      setIsSidebarOpen(window.PDFViewerApplication.pdfSidebar.isOpen);
    }
  }, []);
  const handlePageRendered = Object(external_React_["useCallback"])(event => {
    // For now just deselect text when page is re-rendered
    // TODO: Figure out what to do when multiple pages are selected and some of them are unloaded
    setTimeout(() => {
      setSelectionPositions([...selectionPositionsRef.current]);
    });
  }, []);
  const handleDragStart = Object(external_React_["useCallback"])(event => {
    let isShift = event.shiftKey;
    setIsSelectedOnPointerDown(false);

    if (!pointerDownPositionRef.current) {
      // Prevent dragging the gray area of #viewer
      if (event.target === document.getElementById('viewer')) {
        event.preventDefault();
      }

      return;
    }

    if (event.target === document.getElementById('viewer')) {
      let pointerInSelection = false;

      for (let range of selectionRangesRef.current) {
        if (intersectAnnotationWithPoint(range.position, pointerDownPositionRef.current)) {
          pointerInSelection = true;
          break;
        }
      }

      let selectID = getAnnotationToSelectID(pointerDownPositionRef.current);

      if (selectID && !isShift && !pointerInSelection) {
        let selectAnnotation = annotationsRef.current.find(x => x.id === selectID);

        if (selectAnnotation.type !== 'note' || !selectedIDsRef.current.includes(selectID)) {
          handleLayerAnnotationDragStart(event);
          return;
        }
      }

      if (enableSelectionRef.current || !hasSelection() || !pointerInSelection) {
        event.preventDefault();
        return;
      }
    } else {
      return;
    }

    handleSelectionDragStart(event, pointerDownPositionRef.current);
  }, []);
  const handleSelectionDragStart = Object(external_React_["useCallback"])((event, pointerPosition) => {
    let annotations = getAnnotationsFromSelectionRanges(selectionRangesRef.current);

    if (annotations.length > 1) {
      setMultiDragPreview(event, annotations.length);
    } else {
      setLayerSelectionDragPreview(event, annotations[0].position.rects, selectionColor, pointerPosition);
    }

    setDataTransferAnnotations(event.dataTransfer, annotations);
  }, []);

  function toggleMode(m) {
    if (modeRef.current === m) {
      setMode(null);
    } else {
      setMode(m);
    }

    selectAnnotation();
  }

  function getAnnotationToSelectID(position, hasModifier) {
    let found = annotationsRef.current.filter(x => intersectAnnotationWithPoint(x.position, position));

    if (!found.length) {
      return;
    }

    let selectedID = null;

    function getAnnotationAreaSize(annotation) {
      let areaSize = 0;

      for (let rect of annotation.position.rects) {
        areaSize += (rect[2] - rect[0]) * (rect[3] - rect[1]);
      }

      return areaSize;
    }

    found.sort((a, b) => {
      let aSize, bSize;

      if (a.position.rects) {
        aSize = getAnnotationAreaSize(a);
      } else if (a.position.paths) {
        aSize = 0;
      }

      if (b.position.rects) {
        bSize = getAnnotationAreaSize(b);
      } else if (b.position.paths) {
        bSize = 0;
      }

      return aSize - bSize;
    });

    if (hasModifier) {
      return found[0].id;
    }

    let indexOfCurrentID = found.indexOf(found.find(annotation => selectedIDsRef.current.slice(-1)[0] === annotation.id));

    if (indexOfCurrentID >= 0) {
      if (indexOfCurrentID < found.length - 1) {
        selectedID = found[indexOfCurrentID + 1].id;
      } else {
        if (found.length) {
          selectedID = found[0].id;
        } // selectedID = null;

      }
    } else if (found.length) {
      selectedID = found[0].id;
    }

    return selectedID;
  }

  function selectAnnotation({
    id,
    ctrl,
    shift,
    selectInSidebar,
    scrollSidebar,
    scrollViewer
  } = {}) {
    annotationCommentTouched.current = false;

    if (!id) {
      setSelectedIDs([]);
      return 0;
    }

    let selectedIDs = selectedIDsRef.current.slice();
    let annotations = annotationsRef.current;

    if (shift && selectedIDs.length) {
      let annotationIndex = annotations.findIndex(x => x.id === id);
      let lastSelectedIndex = annotations.findIndex(x => x.id === selectedIDs.slice(-1)[0]);
      let selectedIndices = selectedIDs.map(id => annotations.findIndex(annotation => annotation.id === id));
      let minSelectedIndex = Math.min(...selectedIndices);
      let maxSelectedIndex = Math.max(...selectedIndices);

      if (annotationIndex < minSelectedIndex) {
        for (let i = annotationIndex; i < minSelectedIndex; i++) {
          selectedIDs.push(annotations[i].id);
        }
      } else if (annotationIndex > maxSelectedIndex) {
        for (let i = maxSelectedIndex + 1; i <= annotationIndex; i++) {
          selectedIDs.push(annotations[i].id);
        }
      } else {
        for (let i = Math.min(annotationIndex, lastSelectedIndex); i <= Math.max(annotationIndex, lastSelectedIndex); i++) {
          if (i === lastSelectedIndex) {
            continue;
          }

          let id = annotations[i].id;

          if (!selectedIDs.includes(id)) {
            selectedIDs.push(id);
          }
        }
      }
    } else if (ctrl && selectedIDs.length) {
      let existingIndex = selectedIDs.indexOf(id);

      if (existingIndex >= 0) {
        selectedIDs.splice(existingIndex, 1);
      } else {
        selectedIDs.push(id);
      }
    } else {
      selectedIDs = [id];
    }

    if (JSON.stringify(selectedIDsRef.current) === JSON.stringify(selectedIDs)) {
      return 0;
    }

    setSelectedIDs(selectedIDs);

    if (selectedIDs.length >= 2) {
      setExpansionState(0);
    } else {
      setExpansionState(1);
    }

    lastSelectedAnnotationIDRef.current = selectedIDs.slice(-1)[0];
    let annotation = annotations.find(x => x.id === lastSelectedAnnotationIDRef.current);

    if (annotation) {
      scrollTo(annotation, scrollSidebar, scrollViewer);
    }

    if (selectInSidebar) {
      focusManagerRef.current.zone = focusManagerRef.current.zones.find(x => x.id === 'sidebar-annotation');
    } else {
      focusManagerRef.current.zone = focusManagerRef.current.zones.find(x => x.id === 'view-annotation');
    }

    return selectedIDs.length;
  }

  const handleLayerAnnotationDragStart = Object(external_React_["useCallback"])(event => {
    let annotations = annotationsRef.current.filter(x => selectedIDsRef.current.includes(x.id));

    if (!annotations.length) {
      event.preventDefault();
    } // If some annotations are ink and some not, filter only ink annotations
    // and allow dragging, otherwise cancel


    let forceMulti = false;

    if (annotations.some(x => x.type === 'ink')) {
      if (annotations.some(x => x.type !== 'ink')) {
        annotations = annotations.filter(x => x.type !== 'ink');
        forceMulti = true;
      } else {
        event.preventDefault();
        return;
      }
    }

    if (annotations.length > 1 || forceMulti) {
      setMultiDragPreview(event, selectedIDsRef.current.length);
    } else if (annotations.length) {
      setLayerSingleDragPreview(event, annotations[0]);
    }

    if (annotations.length) {
      setDraggingAnnotationIDs(annotations.map(x => x.id));
      setIsPopupDisabled(true);
      setEnableSelection(false);
      setDataTransferAnnotations(event.dataTransfer, annotations);
    }
  }, []);
  const handleSidebarAnnotationDragStart = Object(external_React_["useCallback"])((event, id) => {
    let annotations;

    if (selectedIDsRef.current.includes(id) && selectedIDsRef.current.length > 1) {
      annotations = annotationsRef.current.filter(x => selectedIDsRef.current.includes(x.id));
    } else {
      annotations = [annotationsRef.current.find(x => x.id === id)];
    }

    setDraggingAnnotationIDs(annotations.map(x => x.id)); // If some annotations are ink and some not, filter only ink annotations
    // and allow to drag, otherwise cancel

    let forceMulti = false;

    if (annotations.some(x => x.type === 'ink')) {
      if (annotations.some(x => x.type !== 'ink')) {
        annotations = annotations.filter(x => x.type !== 'ink');
        forceMulti = true;
      } else {
        event.preventDefault();
        return;
      }
    }

    if (annotations.length > 1 || forceMulti) {
      setMultiDragPreview(event, annotations.length);
    } else {
      setSidebarSingleDragPreview(event);
    }

    setDataTransferAnnotations(event.dataTransfer, annotations);
  }, []);
  const handleAnnotationDragEnd = Object(external_React_["useCallback"])(() => {}, []);
  const handleToolbarModeChange = Object(external_React_["useCallback"])(mode => {
    PDFViewerApplication.pdfCursorTools.switchTool(0);
    toggleMode(mode);
  }, []);
  const handleToolbarColorClick = Object(external_React_["useCallback"])(elementID => {
    props.onPopup('openColorPopup', {
      elementID,
      colors: annotationColors,
      selectedColor: colorRef.current
    });
  }, []);
  const handleSidebarAnnotationSectionClick = Object(external_React_["useCallback"])((id, section, event) => {
    let ctrl = event.ctrlKey || event.metaKey;
    let shift = event.shiftKey;
    let annotation = annotationsRef.current.find(x => x.id === id);

    if (section === 'tags' && !ctrl && !shift && !annotation.readOnly) {
      return props.onClickTags(id, event);
    }

    if (section === 'highlight' && selectedIDsRef.current.length === 1 && selectedIDsRef.current[0] === id) {
      if (expansionStateRef.current >= 1 && expansionStateRef.current <= 2) {
        setExpansionState(2);
      }
    } else {
      if (section === 'comment' && expansionStateRef.current === 3) {
        setExpansionState(2);
      }

      let selected = selectAnnotation({
        id,
        ctrl,
        shift,
        scrollSidebar: true,
        scrollViewer: true,
        selectInSidebar: true
      });

      if (selected === 1) {
        scrollTo(annotationsRef.current.find(x => x.id === id), true, true); // if (section !== 'header') this.focusSidebarComment(id);
      }
    }
  }, []);
  const handleSidebarAnnotationEditorBlur = Object(external_React_["useCallback"])(() => {
    setExpansionState(1); // document.getElementById('annotationsView').focus();
  }, []);
  const handleSidebarAnnotationDoubleClick = Object(external_React_["useCallback"])(id => {
    if (selectedIDsRef.current.length === 1 && selectedIDsRef.current[0] === id) {
      if (expansionStateRef.current >= 1 && expansionStateRef.current <= 2) {
        setExpansionState(3);
        focusSidebarHighlight(id);
      }
    }
  }, []);
  const handleSidebarAnnotationChange = Object(external_React_["useCallback"])(annotation => {
    props.onUpdateAnnotations([annotation]);
  }, []);
  const handleSidebarAnnotationMenuOpen = Object(external_React_["useCallback"])(({
    id,
    button,
    screenX,
    screenY,
    selector
  }) => {
    let selectedColor;
    let ids = [id];

    if (button || selectedIDsRef.current.length === 1) {
      selectedColor = annotationsRef.current.find(x => x.id === id).color;
    }

    if (!button && selectedIDsRef.current.includes(id)) {
      ids = selectedIDsRef.current;
    }

    let readOnly = annotationsRef.current.some(x => ids.includes(x.id) && x.readOnly);
    let enableAddToNote = !annotationsRef.current.some(x => ids.includes(x.id) && x.type === 'ink');
    let enableEditHighlightedText = ids.length === 1 && annotationsRef.current.find(x => x.id === ids[0] && x.type === 'highlight');
    let enableImageOptions = ids.length === 1 && annotationsRef.current.find(x => x.id === ids[0] && x.type === 'image');
    props.onPopup('openAnnotationPopup', {
      x: screenX,
      y: screenY,
      selector,
      standalone: button,
      currentID: id,
      inPage: false,
      ids,
      colors: annotationColors,
      selectedColor,
      readOnly,
      enableAddToNote,
      enableEditPageNumber: true,
      enableEditHighlightedText,
      enableImageOptions
    });
  }, []);
  const handleLayerAreaSelectionStart = Object(external_React_["useCallback"])(() => {
    setIsSelectingArea(true);
  }, []);
  const handleLayerAreaCreation = Object(external_React_["useCallback"])(position => {
    props.onAddAnnotation({
      type: 'image',
      color: colorRef.current,
      position: position
    });
  }, []);
  const handleLayerAreaResizeStart = Object(external_React_["useCallback"])(() => {
    setIsResizingArea(true);
  }, []);
  const handleLayerAnnotationChange = Object(external_React_["useCallback"])(annotation => {
    props.onUpdateAnnotations([annotation]);
  }, []);
  const handleLayerAnnotationMoreMenu = Object(external_React_["useCallback"])(({
    id,
    screenX,
    screenY,
    selector
  }) => {
    let annotation = annotationsRef.current.find(x => x.id === id);
    let selectedColor = annotation.color;
    let enableAddToNote = annotation.type !== 'ink';
    let enableImageOptions = annotation.type === 'image';
    props.onPopup('openAnnotationPopup', {
      x: screenX,
      y: screenY,
      selector,
      standalone: true,
      inPage: true,
      currentID: id,
      ids: [id],
      colors: annotationColors,
      selectedColor,
      enableAddToNote,
      enableEditPageNumber: true,
      enableImageOptions
    });
  }, []);

  function openPagePopup(hasSelection, event) {
    props.onPopup('openPagePopup', {
      x: event.screenX,
      y: event.screenY,
      text: hasSelection && selectionRangesRef.current.map(range => range.text).join('\n'),
      isZoomAuto: PDFViewerApplication.pdfViewer.currentScaleValue === 'auto',
      isZoomPageWidth: PDFViewerApplication.pdfViewer.currentScaleValue === 'page-width',
      isZoomPageHeight: PDFViewerApplication.pdfViewer.currentScaleValue === 'page-fit',
      enablePrevPage: PDFViewerApplication.pdfViewer.currentPageNumber > 1,
      enableNextPage: PDFViewerApplication.pdfViewer.currentPageNumber < PDFViewerApplication.pdfViewer.pagesCount
    });
  }

  function intersectsWithSelectedAnnotations(position) {
    return !!annotationsRef.current.filter(x => selectedIDsRef.current.includes(x.id)).find(x => intersectAnnotationWithPoint(x.position, position));
  }

  function intersectsWithSelectedText(position) {
    for (let range of selectionRangesRef.current) {
      if (intersectAnnotationWithPoint(range.position, position)) {
        return true;
      }
    }

    return false;
  }

  const handleLayerPointerDown = Object(external_React_["useCallback"])((position, event) => {
    let isRight = event.button === 2;
    let isLeft = event.button === 0;
    let isCtrl = event.ctrlKey || event.metaKey;
    let isShift = event.shiftKey;
    pointerDownPositionRef.current = position;
    setIsPopupDisabled(false);

    if (event.detail === 2) {
      setIsSelectingText(true);
      setEnableSelection(true);
      let selectionRanges = getWordSelectionRanges(position, position);
      setSelectionRangesRef(selectionRanges);
      selectionMode.current = 'words';
      return;
    } else if (event.detail === 3) {
      setIsSelectingText(true);
      setEnableSelection(true);
      let selectionRanges = getLineSelectionRanges(position, position);
      setSelectionRangesRef(selectionRanges);
      selectionMode.current = 'lines';
      return;
    }

    selectionMode.current = 'chars';

    if (isShift && selectionRangesRef.current.length) {
      setIsSelectingText(true);
      setEnableSelection(true);
      let selectionRanges = getModifiedSelectionRanges(selectionRangesRef.current, position);
      setSelectionRangesRef(selectionRanges);
      return;
    }

    if (PDFViewerApplication.pdfCursorTools.activeTool === 1) {
      return true;
    }

    if (!event.target.closest('.page') && !event.target.closest('.note-annotation')) {
      return;
    }

    if (event.target.classList.contains('internalLink')) {
      setIsSelectedOnPointerDown(true);
      return;
    }

    setIsLastClickRight(isRight);

    if (isLeft && modeRef.current === 'note') {
      (async () => {
        position.rects[0][0] -= NOTE_DIMENSIONS / 2;
        position.rects[0][1] -= NOTE_DIMENSIONS / 2;
        position.rects[0][2] += NOTE_DIMENSIONS / 2;
        position.rects[0][3] += NOTE_DIMENSIONS / 2;
        let annotation = await props.onAddAnnotation({
          type: 'note',
          position: position,
          color: colorRef.current
        }); // TODO: Fix delay between annotation creation and comment focus

        selectAnnotation({
          id: annotation.id,
          scrollSidebar: true
        });
        focusComment(annotation.id);
      })();

      setMode(null);
      return;
    }

    if (intersectsWithSelectedText(position)) {
      if (isRight) {
        openPagePopup(true, event);
      }

      return;
    }

    let selectID = getAnnotationToSelectID(position, isCtrl || isShift);

    if ((isLeft || isRight) && selectID && (!isShift || selectedIDsRef.current.length) && (isCtrl || !intersectsWithSelectedAnnotations(position))) {
      let selected = selectAnnotation({
        id: selectID,
        ctrl: isCtrl,
        shift: isShift,
        scrollSidebar: true
      });

      if (selected === 1) {
        let annotation = annotationsRef.current.find(x => x.id === selectedIDsRef.current[0]);

        if (!annotation.comment) {
          focusComment(annotation.id);
        }
      }

      setIsSelectedOnPointerDown(true);
    }

    if (!isCtrl && !selectID) {
      selectAnnotation();
    }

    if (isRight && selectID) {
      let readOnly = !!annotationsRef.current.find(x => selectedIDsRef.current.includes(x.id) && x.readOnly);
      let enableAddToNote = !annotationsRef.current.some(x => selectedIDsRef.current.includes(x.id) && x.type === 'ink');
      let enableImageOptions = selectedIDsRef.current.length === 1 && annotationsRef.current.find(x => x.id === selectedIDsRef.current[0] && x.type === 'image');
      let selectedColor;

      if (annotationsRef.current.length === 1) {
        selectedColor = annotationsRef.current[0].color;
      }

      props.onPopup('openAnnotationPopup', {
        x: event.screenX,
        y: event.screenY,
        clientX: event.clientX,
        clientY: event.clientY,
        standalone: false,
        inPage: true,
        currentID: selectID,
        ids: selectedIDsRef.current,
        readOnly,
        colors: annotationColors,
        selectedColor,
        enableAddToNote,
        enableImageOptions
      });
    }

    if (isRight && !selectedIDsRef.current.length) {
      openPagePopup(false, event);
    }

    if (isLeft && !isCtrl && !['note', 'image'].includes(modeRef.current) && (!selectedIDsRef.current.length || isShift)) {
      setEnableSelection(true);
    }

    if (!selectedIDsRef.current.length) {
      focusManagerRef.current.zone = null;
    }

    setSelectionRangesRef([]);
  }, []);
  const handlePointerUp = Object(external_React_["useCallback"])(event => {
    if (event.target.nodeType === Node.ELEMENT_NODE && !event.target.closest('#findbar') && PDFViewerApplication.findBar.opened && !PDFViewerApplication.findBar.findField.value) {
      PDFViewerApplication.findBar.close();
    }

    if (modeRef.current === 'highlight') {
      let ranges = selectionRangesRef.current.filter(x => !x.collapsed);

      for (let range of ranges) {
        props.onAddAnnotation({
          type: 'highlight',
          color: colorRef.current,
          sortIndex: range.sortIndex,
          position: range.position,
          text: range.text
        });
      }

      setSelectionRangesRef([]);
    }

    if (event.target === document.getElementById('viewer')) {
      selectAnnotation();
      setSelectionRangesRef([]);
    }

    setIsSelectingText(false);
    setIsResizingArea(false);
    setIsSelectingArea(false);
    setEnableSelection(false);
    setIsSelectedOnPointerDown(false);
    pointerDownPositionRef.current = null;
  }, []);
  const handlePointerDown = Object(external_React_["useCallback"])(event => {
    if (event.button === 3) {
      window.history.back();
      event.preventDefault();
      return;
    } else if (event.button === 4) {
      window.history.forward();
      event.preventDefault();
      return;
    }

    if (event.target === document.getElementById('viewer')) {
      selectAnnotation();
      setSelectionRangesRef([]);
      setIsSelectingText(false);
      setIsResizingArea(false);
      setIsSelectingArea(false);
      setEnableSelection(false);
      setIsSelectedOnPointerDown(false);
      pointerDownPositionRef.current = null;
      focusManagerRef.current.zone = null;
    }
  }, []); // Layer PointerUp is called before Window PointerUp

  const handleLayerPointerUp = Object(external_React_["useCallback"])((position, event) => {
    let isLeft = event.button === 0;
    let isRight = event.button === 2;
    let isCtrl = event.ctrlKey || event.metaKey;
    let isShift = event.shiftKey;

    if (isLeft && !isShift && !selectedIDsRef.current.length && (!selectionRangesRef.current.length || selectionRangesRef.current[0].text === '') && event.target.nodeName !== 'A') {
      let link = window.extractor.getPageLinks(position.pageIndex).find(x => intersectAnnotationWithPoint(x.position, position));

      if (link && intersectAnnotationWithPoint(link.position, pointerDownPositionRef.current)) {
        props.onExternalLink(link.url);
      }
    } // Make selected text available for screen readers


    let text = '';

    for (let selectionRange of selectionRangesRef.current) {
      text += selectionRange.text + '\n';
    }

    window.selectionBox.value = text;

    if (text) {
      window.selectionBox.select();
    } // Trigger async page label extraction to already have the label in case
    // dragging would be initiated


    window.extractor.getPageLabel(position.pageIndex);

    if (isSelectingAreaRef.current || isResizingAreaRef.current || isSelectingTextRef.current || isSelectedOnPointerDownRef.current) {
      return;
    } // This does annotation selection (or switches to the next overlapped annotation)
    // when it can be done on pointer down because we don't know yet whether
    // the current annotation or text selection will be dragged or just clicked


    let selectID = getAnnotationToSelectID(position, isCtrl || isShift);

    if (isLeft && selectID) {
      setSelectionRangesRef([]);
      selectAnnotation({
        id: selectID,
        ctrl: isCtrl,
        shift: isShift,
        scrollSidebar: true
      });
    }
  }, []);
  const handleLayerPointerMove = Object(external_React_["useCallback"])((position, event) => {
    let isShift = event.shiftKey;
    let overLink = (!isShift || selectedIDsRef.current.length) && window.extractor.getPageLinks(position.pageIndex).find(x => intersectAnnotationWithPoint(x.position, position));
    let overAnnotation = (!isShift || selectedIDsRef.current.length) && annotationsRef.current.find(x => intersectAnnotationWithPoint(x.position, position));
    let textPosition = window.pageTextPositions[position.pageIndex];
    let overText = !['note', 'image'].includes(modeRef.current) && (!intersectsWithSelectedText(position) || isShift) && textPosition && intersectAnnotationWithPoint(textPosition, position) || isSelectingTextRef.current;
    let viewer = document.getElementById('viewer');

    if (overAnnotation || overLink) {
      viewer.classList.add('cursor-pointer');
      viewer.classList.remove('cursor-text');
      viewer.classList.remove('cursor-text-selecting');
    } else if (overText) {
      viewer.classList.add('cursor-text');

      if (isSelectingTextRef.current) {
        viewer.classList.add('cursor-text-selecting');
      }

      viewer.classList.remove('cursor-pointer');
    } else {
      viewer.classList.remove('cursor-pointer');
      viewer.classList.remove('cursor-text');
      viewer.classList.remove('cursor-text-selecting');
    }

    if (pointerDownPositionRef.current && enableSelectionRef.current) {
      setIsSelectingText(true);

      if (selectionRangesRef.current.length) {
        let selectionRanges;

        if (selectionMode.current === 'chars') {
          selectionRanges = getModifiedSelectionRanges(selectionRangesRef.current, position, 'word');
        } else if (selectionMode.current === 'words') {
          selectionRanges = getWordSelectionRanges(pointerDownPositionRef.current, position);
        } else if (selectionMode.current === 'lines') {
          selectionRanges = getLineSelectionRanges(pointerDownPositionRef.current, position);
        }

        setSelectionRangesRef(selectionRanges);
      } else {
        let selectionRanges = getSelectionRanges(pointerDownPositionRef.current, position);
        setSelectionRangesRef(selectionRanges);
      }
    }
  }, []);
  const handleLayerEdgeNoteClick = Object(external_React_["useCallback"])(id => {
    selectAnnotation({
      id,
      scrollSidebar: true
    });
  }, []);
  const handleLayerSelectionPopupHighlight = Object(external_React_["useCallback"])(color => {
    let ranges = selectionRangesRef.current.filter(x => !x.collapsed);

    for (let range of ranges) {
      props.onAddAnnotation({
        type: 'highlight',
        color,
        sortIndex: range.sortIndex,
        position: range.position,
        text: range.text
      });
    }

    setSelectionRangesRef([]);
  }, []);
  const handleLayerSelectionPopupCopy = Object(external_React_["useCallback"])(() => {
    let text = '';

    for (let selectionRange of selectionRangesRef.current) {
      text += selectionRange.text + '\n';
    }

    copyToClipboard(text);
  }, []);
  const handleLayerSelectionPopupAddToNote = Object(external_React_["useCallback"])(() => {
    let partialAnnotations = getAnnotationsFromSelectionRanges(selectionRangesRef.current);
    let annotations = partialAnnotations.map(annotation => ({ ...annotation,
      attachmentItemID: window.itemID,
      type: 'highlight'
    }));

    if (annotations.length) {
      props.onAddToNote(annotations);
      setSelectionRangesRef([]);
    }
  }, []);
  const handlePageLabelDoubleClick = Object(external_React_["useCallback"])(id => {
    openPageLabelPopup({
      standalone: true,
      currentID: id,
      inPage: !isSidebarOpenRef.current
    });
  }, []);
  const handlePageLabelPopupClose = Object(external_React_["useCallback"])(() => {
    setLabelPopup(null);
  }, []);
  const handlePageLabelPopupUpdate = Object(external_React_["useCallback"])(async (type, pageLabel) => {
    window.extractor.clearLabelsCache();
    let annotationsToUpdate = [];

    if (type === 'auto') {
      // TODO: Don't reset page labels if they can't be reliably extracted from text
      setLabelPopup(null);
      let annotations = annotationsRef.current.filter(x => !x.readOnly);

      for (let annotation of annotations) {
        annotationsToUpdate.push({
          id: annotation.id,
          pageLabel: await window.extractor.getPageLabel(annotation.position.pageIndex)
        });
      }

      props.onUpdateAnnotations(annotationsToUpdate);
      return;
    }

    if (!pageLabel) {
      return;
    }

    let annotation = annotationsRef.current.find(x => x.id === labelPopup.current.currentID);

    if (!annotation) {
      return;
    }

    let pageIndex = annotation.position.pageIndex;
    let isNumeric = parseInt(pageLabel) == pageLabel;

    if (type === 'single' || !isNumeric && type !== 'selected') {
      if (!annotation.readOnly) {
        annotation.pageLabel = pageLabel;
        annotationsToUpdate = [annotation];
      }
    } else if (type === 'selected' && !isNumeric) {
      let annotations = annotationsRef.current.filter(x => !x.readOnly);
      annotationsToUpdate = annotations.filter(x => selectedIDsRef.current.includes(x.id));

      for (let annotation of annotationsToUpdate) {
        annotation.pageLabel = pageLabel;
      }
    } else {
      let annotations = annotationsRef.current.filter(x => !x.readOnly);

      switch (type) {
        case 'selected':
          annotationsToUpdate = annotations.filter(x => selectedIDsRef.current.includes(x.id));
          break;

        case 'page':
          annotationsToUpdate = annotations.filter(x => x.position.pageIndex === pageIndex);
          break;

        case 'from':
          annotationsToUpdate = annotations.filter(x => x.position.pageIndex >= pageIndex);
          break;

        case 'all':
          annotationsToUpdate = annotations;
          break;
      }

      pageLabel = parseInt(pageLabel);

      for (let annotation of annotationsToUpdate) {
        let newPageLabel = pageLabel + (annotation.position.pageIndex - pageIndex);

        if (newPageLabel < 1) {
          continue;
        }

        annotation.pageLabel = newPageLabel.toString();
      }
    }

    setLabelPopup(null);
    props.onUpdateAnnotations(annotationsToUpdate);
  }, []);

  async function openPageLabelPopup({
    currentID,
    standalone,
    clientX,
    clientY,
    inPage
  }) {
    let annotations = [];
    let annotation = annotationsRef.current.find(x => x.id === currentID);

    if (!annotation) {
      return;
    }

    if (standalone || !selectedIDsRef.current.length) {
      annotations = [annotation];
    } else {
      annotations = annotationsRef.current.filter(x => selectedIDsRef.current.includes(x.id));
    }

    if (annotations.some(x => x.readOnly)) {
      return;
    }

    annotations.sort((a, b) => a.position.pageIndex - b.position.pageIndex);
    let single = annotations.length === 1;
    let selected = annotations.length > 1;
    let currentPageAnnotations = annotationsRef.current.filter(x => x.position.pageIndex === annotations[0].position.pageIndex);
    let fromCurrentPageAnnotations = annotationsRef.current.filter(x => x.position.pageIndex >= annotations[0].position.pageIndex);
    let page = currentPageAnnotations.some(x => !annotations.includes(x));
    let from = fromCurrentPageAnnotations.some(x => !annotations.includes(x));
    let all = annotationsRef.current.length !== currentPageAnnotations.length && annotationsRef.current.length !== fromCurrentPageAnnotations.length;
    let checked;

    if (from) {
      checked = 'from';
    } else if (all) {
      checked = 'all';
    } else if (page) {
      checked = 'page';
    } else if (selected) {
      checked = 'selected';
    } else {
      checked = 'single';
    }

    let rect;

    if (inPage) {
      let anchorNode = document.querySelector(`.annotation-popup .page .label`);

      if (annotations.length > 1 || !anchorNode) {
        rect = [clientX, clientY, clientX, clientY];
      } else {
        rect = anchorNode.getBoundingClientRect();
        rect = [rect.left, rect.top, rect.right, rect.bottom];
      }
    } else if (isSidebarOpenRef.current) {
      let anchorNode = document.querySelector(`[data-sidebar-annotation-id="${currentID}"] .page .label`);
      rect = anchorNode.getBoundingClientRect();
      rect = [rect.left, rect.top, rect.right, rect.bottom];
    }

    let autoPageLabel = await window.extractor.getPageLabel(annotation.position.pageIndex);
    setLabelPopup({
      rect,
      currentID,
      standalone,
      checked,
      pageLabel: annotation.pageLabel,
      autoPageLabel,
      single,
      selected,
      page,
      from,
      all
    });
  }

  function editHighlightedText({
    currentID
  }) {
    selectAnnotation({
      id: currentID,
      scrollSidebar: true,
      scrollViewer: true,
      selectInSidebar: true
    });
    setTimeout(() => {
      let node = document.querySelector(`[data-sidebar-annotation-id="${currentID}"] .content`);
      var clickEvent = document.createEvent('MouseEvents');
      clickEvent.initEvent('dblclick', true, true);
      node.dispatchEvent(clickEvent);
      node.focus();
    }, 50);
  }

  const handleSelectorMenuOpen = Object(external_React_["useCallback"])(data => {
    props.onPopup('openSelectorPopup', data);
  }, []);
  const handleSelectorChange = Object(external_React_["useCallback"])((remove, tag, color) => {
    let selectedAnnotations = annotationsRef.current.filter(x => draggingAnnotationIDsRef.current.includes(x.id));
    selectedAnnotations = selectedAnnotations.filter(x => !x.readOnly);
    let annotations = [];

    for (let annotation of selectedAnnotations) {
      if (tag) {
        if (remove) {
          if (annotation.tags.find(x => x.name === tag.name)) {
            annotation.tags = annotation.tags.filter(x => x.name !== tag.name);
            annotations.push(annotation);
          }
        } else {
          if (!annotation.tags.find(x => x.name === tag.name)) {
            annotation.tags.push(tag);
            annotations.push(annotation);
          }
        }
      } else if (color) {
        if (annotation.color !== color) {
          annotation.color = color;
          annotations.push(annotation);
        }
      }
    }

    props.onUpdateAnnotations(annotations);
  }, []);
  const handleFilterChange = Object(external_React_["useCallback"])(filter => {
    setFilter(filter);
    setAnnotations(filterAnnotations(allAnnotationsRef.current, filter));
  }, []);
  return /*#__PURE__*/external_React_default.a.createElement("div", null, !props.readOnly && /*#__PURE__*/external_React_default.a.createElement(toolbar, {
    toggled: _mode,
    onMode: handleToolbarModeChange,
    color: _color,
    onColorPick: handleToolbarColorClick
  }), /*#__PURE__*/external_React_default.a.createElement(annotations_view, {
    readOnly: props.readOnly,
    filter: _filter,
    allAnnotations: _allAnnotations,
    annotations: _annotations,
    selectedIDs: _selectedIDs,
    expansionState: _expansionState,
    authorName: props.authorName,
    onClickAnnotationSection: handleSidebarAnnotationSectionClick,
    onAnnotationEditorBlur: handleSidebarAnnotationEditorBlur,
    onDoubleClickHighlight: handleSidebarAnnotationDoubleClick,
    onDoubleClickPageLabel: handlePageLabelDoubleClick,
    onChange: handleSidebarAnnotationChange,
    onDragStart: handleSidebarAnnotationDragStart,
    onMenu: handleSidebarAnnotationMenuOpen,
    onSelectorMenu: handleSelectorMenuOpen,
    onSelectorChange: handleSelectorChange,
    onChangeFilter: handleFilterChange
  }), /*#__PURE__*/external_React_default.a.createElement(components_layer, {
    selectionColor: _mode === 'highlight' ? _color : selectionColor,
    selectionPositions: _selectionPositions,
    enableSelectionPopup: !props.readOnly && !_isSelectingText && !_mode && !_isLastClickRight,
    enableAddToNote: _enableAddToNote,
    popupAnnotation: !_isPopupDisabled && !_isSelectingText && !_draggingAnnotationIDs.length && !_isSelectingArea && !_isResizingArea && !_isLastClickRight && !_isSidebarOpen && _selectedIDs.length < 2 && _selectedIDs.length && _annotations.find(x => _selectedIDs.includes(x.id)),
    annotations: _annotations,
    color: _color,
    selectedAnnotationIDs: _selectedIDs,
    blink: _blink,
    enableEdgeNotes: !_isResizingArea // TODO: disable only for the current note
    ,
    enableAreaSelector: _mode === 'image' && !_selectedIDs.length,
    onAreaSelectionStart: handleLayerAreaSelectionStart,
    onAreaSelection: handleLayerAreaCreation,
    onAreaResizeStart: handleLayerAreaResizeStart,
    onChange: handleLayerAnnotationChange,
    onMoreMenu: handleLayerAnnotationMoreMenu,
    onPointerDown: handleLayerPointerDown,
    onPointerUp: handleLayerPointerUp,
    onPointerMove: handleLayerPointerMove,
    onClickTags: props.onClickTags,
    onDoubleClickPageLabel: handlePageLabelDoubleClick,
    onClickEdgeNote: handleLayerEdgeNoteClick,
    onDragStart: handleLayerAnnotationDragStart,
    onDragEnd: handleAnnotationDragEnd,
    onHighlightSelection: handleLayerSelectionPopupHighlight,
    onCopySelection: handleLayerSelectionPopupCopy,
    onAddToNoteSelection: handleLayerSelectionPopupAddToNote
  }), _labelPopup && /*#__PURE__*/external_React_default.a.createElement(label_popup, {
    data: _labelPopup,
    onClose: handlePageLabelPopupClose,
    onUpdate: handlePageLabelPopupUpdate
  }));
});
/* harmony default export */ var annotator = (Annotator);
// EXTERNAL MODULE: ./node_modules/queue/index.js
var queue = __webpack_require__(6);
var queue_default = /*#__PURE__*/__webpack_require__.n(queue);

// CONCATENATED MODULE: ./src/lib/render.js




const SCALE = 4;
const PATH_BOX_PADDING = 10; // pt

const MIN_PATH_BOX_SIZE = 30; // pt

async function renderAreaImage(annotation) {
  let {
    position,
    color
  } = annotation;
  let page = await PDFViewerApplication.pdfDocument.getPage(position.pageIndex + 1); // Create a new position that just contains single rect that is a bounding
  // box of image or ink annotations

  let expandedPosition = {
    pageIndex: position.pageIndex
  };

  if (position.rects) {
    // Image annotations have only one rect
    expandedPosition.rects = position.rects;
  } // paths
  else {
    let rect = getPositionBoundingRect(position);
    rect = [rect[0] - PATH_BOX_PADDING, rect[1] - PATH_BOX_PADDING, rect[2] + PATH_BOX_PADDING, rect[3] + PATH_BOX_PADDING];

    if (rect[2] - rect[0] < MIN_PATH_BOX_SIZE) {
      let x = rect[0] + (rect[2] - rect[0]) / 2;
      rect[0] = x - MIN_PATH_BOX_SIZE;
      rect[2] = x + MIN_PATH_BOX_SIZE;
    }

    if (rect[3] - rect[1] < MIN_PATH_BOX_SIZE) {
      let y = rect[1] + (rect[3] - rect[1]) / 2;
      rect[1] = y - MIN_PATH_BOX_SIZE;
      rect[3] = y + MIN_PATH_BOX_SIZE;
    }

    expandedPosition.rects = [fitRectIntoRect(rect, page.view)];
  }

  let rect = expandedPosition.rects[0];
  let maxScale = Math.sqrt(PDFViewerApplication.pdfViewer.maxCanvasPixels / ((rect[2] - rect[0]) * (rect[3] - rect[1])));
  let scale = Math.min(SCALE, maxScale);
  expandedPosition = coordinates_p2v(expandedPosition, page.getViewport({
    scale
  }));
  rect = expandedPosition.rects[0];
  let viewport = page.getViewport({
    scale,
    offsetX: -rect[0],
    offsetY: -rect[1]
  });
  position = coordinates_p2v(position, viewport);
  let canvasWidth = rect[2] - rect[0];
  let canvasHeight = rect[3] - rect[1];
  let canvas = document.createElement('canvas');
  let ctx = canvas.getContext('2d', {
    alpha: false
  });

  if (!canvasWidth || !canvasHeight) {
    return '';
  }

  canvas.width = canvasWidth;
  canvas.height = canvasHeight;
  canvas.style.width = canvasWidth + 'px';
  canvas.style.height = canvasHeight + 'px';
  let renderContext = {
    canvasContext: ctx,
    viewport: viewport
  };
  await page.render(renderContext).promise;

  if (position.paths) {
    ctx.lineCap = 'round';
    ctx.lineJoin = 'round';
    ctx.lineWidth = position.width;
    ctx.beginPath();
    ctx.strokeStyle = color;

    for (let path of position.paths) {
      for (let i = 0; i < path.length - 1; i += 2) {
        let x = path[i];
        let y = path[i + 1];

        if (i === 0) {
          ctx.moveTo(x, y);
        }

        ctx.lineTo(x, y);
      }
    }

    ctx.stroke();
  }

  return canvas.toDataURL('image/png', 1);
}
function drawAnnotationsOnCanvas(canvas, viewport, annotations) {
  let ctx = canvas.getContext('2d', {
    alpha: false
  });
  let scale = canvas.width / viewport.width;
  ctx.transform(scale, 0, 0, scale, 0, 0);
  ctx.globalCompositeOperation = 'multiply';

  for (let annotation of annotations) {
    let {
      color
    } = annotation;
    let position = coordinates_p2v(annotation.position, viewport);
    ctx.save();

    if (annotation.type === 'highlight') {
      ctx.fillStyle = color + '80';

      for (let rect of position.rects) {
        ctx.fillRect(rect[0], rect[1], rect[2] - rect[0], rect[3] - rect[1]);
      }
    } else if (annotation.type === 'note') {
      let [x, y] = position.rects[0];
      ctx.transform(1, 0, 0, 1, x, y);
      ctx.fillStyle = '#000';
      var path = new Path2D('M0,0V12.707L11.293,24H24V0ZM11,22.293,1.707,13H11ZM23,23H12V12H1V1H23Z');
      ctx.fill(path);
      ctx.fillStyle = color;
      ctx.beginPath();
      ctx.moveTo(0.5, 0.5);
      ctx.lineTo(23.5, 0.5);
      ctx.lineTo(23.5, 23.5);
      ctx.lineTo(11.5, 23.5);
      ctx.lineTo(0.5, 12.5);
      ctx.closePath();
      ctx.fill();
      ctx.fillStyle = 'rgba(255, 255, 255, 0.4)';
      ctx.beginPath();
      ctx.moveTo(0.5, 12.5);
      ctx.lineTo(11.5, 12.5);
      ctx.lineTo(11.5, 23.5);
      ctx.closePath();
      ctx.fill();
    } else if (annotation.type === 'image') {
      let rect = position.rects[0];
      ctx.lineWidth = 2;
      ctx.strokeStyle = color;
      ctx.strokeRect(rect[0], rect[1], rect[2] - rect[0], rect[3] - rect[1]);
    } else if (annotation.type === 'ink') {
      ctx.lineCap = 'round';
      ctx.lineJoin = 'round';
      ctx.lineWidth = position.width;
      ctx.beginPath();
      ctx.strokeStyle = color;

      for (let path of position.paths) {
        for (let i = 0; i < path.length - 1; i += 2) {
          let x = path[i];
          let y = path[i + 1];

          if (i === 0) {
            ctx.moveTo(x, y);
          }

          ctx.lineTo(x, y);
        }
      }

      ctx.stroke();
    }

    ctx.restore();
  }
}
// CONCATENATED MODULE: ./src/annotations-store.js






 // TODO: Debounce image annotation resizing to reduce useless intermediate images

class annotations_store_AnnotationsStore {
  constructor(options) {
    this._readOnly = options.readOnly;
    this._authorName = options.authorName;
    this._annotations = options.annotations;
    this._onSave = options.onSave;
    this._onDelete = options.onDelete;

    this.render = () => {
      this._annotations.sort((a, b) => (a.sortIndex > b.sortIndex) - (a.sortIndex < b.sortIndex));

      options.onRender(this._annotations);
    };

    this._renderQueue = queue_default()({
      concurrency: 1,
      autostart: true
    });
    this._unsavedAnnotations = []; // Debounce for 1s but no more than 10s

    this._debounceSave = debounce(() => {
      if (!this._unsavedAnnotations.length) {
        return;
      } // Image is sent in instant mode only


      let annotations = this._unsavedAnnotations.map(x => ({ ...x,
        image: undefined
      }));

      this._onSave(annotations);

      for (let annotation of this._unsavedAnnotations) {
        delete annotation.onlyTextOrComment;
      }

      this._unsavedAnnotations = [];
    }, 1000, {
      maxWait: 10000
    });
    window.PDFViewerApplication.eventBus.on('pagerendered', e => {
      setTimeout(() => {
        this._renderMissingImages();
      }, 2000);
    });
  } // Called when changes come from the client side


  async setAnnotations(annotations) {
    if (this._readOnly) {
      annotations.forEach(x => x.readOnly = true);
    }

    for (let annotation of annotations) {
      this._annotations = this._annotations.filter(x => x.id !== annotation.id);

      this._annotations.push(annotation);
    }

    this.render();

    for (let annotation of annotations) {
      if (['image', 'ink'].includes(annotation.type) && !annotation.image) {
        annotation.image = await this.getAnnotationImage(annotation.id);

        this._save(annotation, true);

        this.render();
      }
    }
  } // Called when deletions come from the client side


  unsetAnnotations(ids) {
    this._annotations = this._annotations.filter(x => !ids.includes(x.id));
    this.render();
  } //


  async addAnnotation(annotation) {
    if (this._readOnly) {
      return;
    } // Those properties can be set on creation


    annotation.color = annotation.color || annotationColors[0];
    annotation.text = annotation.text || '';
    annotation.comment = annotation.comment || '';
    annotation.tags = annotation.tags || []; // annotation.sortIndex
    // All others are set automatically

    annotation.id = this._generateObjectKey();
    annotation.dateCreated = new Date().toISOString();
    annotation.dateModified = annotation.dateCreated;
    annotation.authorName = this._authorName;
    annotation.pageLabel = '-';

    if (!annotation.sortIndex) {
      annotation.sortIndex = '00000|000000|00000';
    }

    if (annotation.position.rects) {
      annotation.position.rects = annotation.position.rects.map(rect => rect.map(value => parseFloat(value.toFixed(3))));
    } // Immediately render the annotation to prevent
    // delay from further async calls


    this._save(annotation);

    this.render();
    annotation.pageLabel = await window.extractor.getPageLabel(annotation.position.pageIndex, true);

    if (annotation.type === 'note' || annotation.type === 'image') {
      annotation.sortIndex = await window.extractor.getSortIndex(annotation.position);
    }

    this._save(annotation);

    this.render();

    if (['image', 'ink'].includes(annotation.type)) {
      annotation.image = await this.getAnnotationImage(annotation.id);

      this._save(annotation, true);

      this.render();
    }

    return annotation;
  }

  async updateAnnotations(annotations) {
    let updateSortIndex = [];
    let updateImage = [];

    for (let annotation of annotations) {
      if (annotation.readOnly || this._readOnly) {
        continue;
      }

      let existingAnnotation = this._getAnnotationByID(annotation.id);

      if (!annotation.onlyTextOrComment) {
        delete existingAnnotation.onlyTextOrComment;
      }

      annotation = { ...existingAnnotation,
        ...annotation,
        position: { ...existingAnnotation.position,
          ...annotation.position
        }
      };
      annotation.dateModified = new Date().toISOString();

      if (annotation.rects) {
        annotation.position.rects = annotation.position.rects.map(rect => rect.map(value => parseFloat(value.toFixed(3))));
      }

      this._save(annotation);

      if (['note', 'image'].includes(annotation.type) && !positionsEqual(existingAnnotation.position, annotation.position)) {
        updateSortIndex.push(annotation);
      }

      if (['image', 'ink'].includes(annotation.type) && !positionsEqual(existingAnnotation.position, annotation.position) || annotation.type === 'ink' && existingAnnotation.color.toLowerCase() !== annotation.color.toLowerCase()) {
        updateImage.push(annotation);
      }
    }

    this.render();

    for (let annotation of updateSortIndex) {
      annotation.sortIndex = await window.extractor.getSortIndex(annotation.position);

      this._save(annotation);
    }

    for (let annotation of updateImage) {
      annotation.image = await this.getAnnotationImage(annotation.id);

      this._save(annotation, true);
    }

    if (updateSortIndex.length || updateImage.length) {
      this.render();
    }
  }

  deleteAnnotations(ids) {
    let someExternal = this._annotations.some(annotation => ids.includes(annotation.id) && annotation.isExternal); // Don't delete anything if the PDF file is read-only, or at least one provided annotation is external


    if (this._readOnly || someExternal) {
      return;
    }

    if (!ids.length || ids.length > 1 && !zoteroConfirmDeletion(ids.length > 1)) {
      return;
    }

    this._annotations = this._annotations.filter(annotation => !ids.includes(annotation.id));
    this._unsavedAnnotations = this._unsavedAnnotations.filter(x => !ids.includes(x.id));

    this._onDelete(ids);

    this.render();
  }

  async getAnnotationImage(annotationID) {
    return new Promise(resolve => {
      this._renderQueue.push(async () => {
        let image = '';

        try {
          let annotation = this._getAnnotationByID(annotationID);

          if (annotation) {
            image = await renderAreaImage(annotation);
          }
        } catch (e) {}

        resolve(image);
      });
    });
  } // Note: Keep in sync with Zotero client


  _generateObjectKey() {
    let len = 8;
    let allowedKeyChars = '23456789ABCDEFGHIJKLMNPQRSTUVWXYZ';
    var randomstring = '';

    for (var i = 0; i < len; i++) {
      var rnum = Math.floor(Math.random() * allowedKeyChars.length);
      randomstring += allowedKeyChars.substring(rnum, rnum + 1);
    }

    return randomstring;
  }

  _save(annotation, instant) {
    let oldIndex = this._annotations.findIndex(x => x.id === annotation.id);

    if (oldIndex !== -1) {
      annotation = { ...annotation
      };

      this._annotations.splice(oldIndex, 1, annotation);
    } else {
      this._annotations.push(annotation);
    }

    this._unsavedAnnotations = this._unsavedAnnotations.filter(x => x.id !== annotation.id);

    if (instant) {
      this._onSave([annotation]);
    } else {
      this._unsavedAnnotations.push(annotation);

      this._debounceSave();
    }
  }

  _getAnnotationByID(id) {
    return this._annotations.find(annotation => annotation.id === id);
  }

  async _renderMissingImages() {
    for (let annotation of this._annotations) {
      if (['image', 'ink'].includes(annotation.type) && !annotation.image) {
        annotation.image = await this.getAnnotationImage(annotation.id);

        this._save(annotation, true);

        this.render();
      }
    }
  }

}

/* harmony default export */ var annotations_store = (annotations_store_AnnotationsStore);
// CONCATENATED MODULE: ./src/lib/text.js
// *** bidi.js starts here ***
// This is taken from PDF.js source https://github.com/mozilla/pdf.js/blob/9416b14e8b06a39a1a57f2baf22aebab2370edeb/src/core/bidi.js

/* Copyright 2012 Mozilla Foundation
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Character types for symbols from 0000 to 00FF.
// Source: ftp://ftp.unicode.org/Public/UNIDATA/UnicodeData.txt
// prettier-ignore
const baseTypes = ["BN", "BN", "BN", "BN", "BN", "BN", "BN", "BN", "BN", "S", "B", "S", "WS", "B", "BN", "BN", "BN", "BN", "BN", "BN", "BN", "BN", "BN", "BN", "BN", "BN", "BN", "BN", "B", "B", "B", "S", "WS", "ON", "ON", "ET", "ET", "ET", "ON", "ON", "ON", "ON", "ON", "ES", "CS", "ES", "CS", "CS", "EN", "EN", "EN", "EN", "EN", "EN", "EN", "EN", "EN", "EN", "CS", "ON", "ON", "ON", "ON", "ON", "ON", "L", "L", "L", "L", "L", "L", "L", "L", "L", "L", "L", "L", "L", "L", "L", "L", "L", "L", "L", "L", "L", "L", "L", "L", "L", "L", "ON", "ON", "ON", "ON", "ON", "ON", "L", "L", "L", "L", "L", "L", "L", "L", "L", "L", "L", "L", "L", "L", "L", "L", "L", "L", "L", "L", "L", "L", "L", "L", "L", "L", "ON", "ON", "ON", "ON", "BN", "BN", "BN", "BN", "BN", "BN", "B", "BN", "BN", "BN", "BN", "BN", "BN", "BN", "BN", "BN", "BN", "BN", "BN", "BN", "BN", "BN", "BN", "BN", "BN", "BN", "BN", "BN", "BN", "BN", "BN", "BN", "BN", "CS", "ON", "ET", "ET", "ET", "ET", "ON", "ON", "ON", "ON", "L", "ON", "ON", "BN", "ON", "ON", "ET", "ET", "EN", "EN", "ON", "L", "ON", "ON", "ON", "EN", "L", "ON", "ON", "ON", "ON", "ON", "L", "L", "L", "L", "L", "L", "L", "L", "L", "L", "L", "L", "L", "L", "L", "L", "L", "L", "L", "L", "L", "L", "L", "ON", "L", "L", "L", "L", "L", "L", "L", "L", "L", "L", "L", "L", "L", "L", "L", "L", "L", "L", "L", "L", "L", "L", "L", "L", "L", "L", "L", "L", "L", "L", "L", "ON", "L", "L", "L", "L", "L", "L", "L", "L"]; // Character types for symbols from 0600 to 06FF.
// Source: ftp://ftp.unicode.org/Public/UNIDATA/UnicodeData.txt
// Note that 061D does not exist in the Unicode standard (see
// http://unicode.org/charts/PDF/U0600.pdf), so we replace it with an
// empty string and issue a warning if we encounter this character. The
// empty string is required to properly index the items after it.
// prettier-ignore

const arabicTypes = ["AN", "AN", "AN", "AN", "AN", "AN", "ON", "ON", "AL", "ET", "ET", "AL", "CS", "AL", "ON", "ON", "NSM", "NSM", "NSM", "NSM", "NSM", "NSM", "NSM", "NSM", "NSM", "NSM", "NSM", "AL", "AL", "", "AL", "AL", "AL", "AL", "AL", "AL", "AL", "AL", "AL", "AL", "AL", "AL", "AL", "AL", "AL", "AL", "AL", "AL", "AL", "AL", "AL", "AL", "AL", "AL", "AL", "AL", "AL", "AL", "AL", "AL", "AL", "AL", "AL", "AL", "AL", "AL", "AL", "AL", "AL", "AL", "AL", "AL", "AL", "AL", "AL", "NSM", "NSM", "NSM", "NSM", "NSM", "NSM", "NSM", "NSM", "NSM", "NSM", "NSM", "NSM", "NSM", "NSM", "NSM", "NSM", "NSM", "NSM", "NSM", "NSM", "NSM", "AN", "AN", "AN", "AN", "AN", "AN", "AN", "AN", "AN", "AN", "ET", "AN", "AN", "AL", "AL", "AL", "NSM", "AL", "AL", "AL", "AL", "AL", "AL", "AL", "AL", "AL", "AL", "AL", "AL", "AL", "AL", "AL", "AL", "AL", "AL", "AL", "AL", "AL", "AL", "AL", "AL", "AL", "AL", "AL", "AL", "AL", "AL", "AL", "AL", "AL", "AL", "AL", "AL", "AL", "AL", "AL", "AL", "AL", "AL", "AL", "AL", "AL", "AL", "AL", "AL", "AL", "AL", "AL", "AL", "AL", "AL", "AL", "AL", "AL", "AL", "AL", "AL", "AL", "AL", "AL", "AL", "AL", "AL", "AL", "AL", "AL", "AL", "AL", "AL", "AL", "AL", "AL", "AL", "AL", "AL", "AL", "AL", "AL", "AL", "AL", "AL", "AL", "AL", "AL", "AL", "AL", "AL", "AL", "AL", "AL", "AL", "AL", "AL", "AL", "AL", "AL", "AL", "AL", "NSM", "NSM", "NSM", "NSM", "NSM", "NSM", "NSM", "AN", "ON", "NSM", "NSM", "NSM", "NSM", "NSM", "NSM", "AL", "AL", "NSM", "NSM", "ON", "NSM", "NSM", "NSM", "NSM", "AL", "AL", "EN", "EN", "EN", "EN", "EN", "EN", "EN", "EN", "EN", "EN", "AL", "AL", "AL", "AL", "AL", "AL"];

function isOdd(i) {
  return (i & 1) !== 0;
}

function isEven(i) {
  return (i & 1) === 0;
}

function findUnequal(arr, start, value) {
  let j, jj;

  for (j = start, jj = arr.length; j < jj; ++j) {
    if (arr[j] !== value) {
      return j;
    }
  }

  return j;
}

function setValues(arr, start, end, value) {
  for (let j = start; j < end; ++j) {
    arr[j] = value;
  }
}

function reverseValues(arr, start, end) {
  for (let i = start, j = end - 1; i < j; ++i, --j) {
    const temp = arr[i];
    arr[i] = arr[j];
    arr[j] = temp;
  }
}

function createBidiText(chars, isLTR, vertical = false) {
  let dir = "ltr";

  if (vertical) {
    dir = "ttb";
  } else if (!isLTR) {
    dir = "rtl";
  }

  return {
    chars,
    dir
  };
} // These are used in bidi(), which is called frequently. We re-use them on
// each call to avoid unnecessary allocations.


const text_chars = [];
const types = [];

function bidi(chars, startLevel = -1, vertical = false) {
  let isLTR = true;
  const strLength = chars.length;

  if (strLength === 0 || vertical) {
    return createBidiText(chars, isLTR, vertical);
  } // Get types and fill arrays


  types.length = strLength;
  let numBidi = 0;
  let i, ii;

  for (i = 0; i < strLength; ++i) {
    const charCode = chars[i].c.charCodeAt(0);
    let charType = "L";

    if (charCode <= 0x00ff) {
      charType = baseTypes[charCode];
    } else if (0x0590 <= charCode && charCode <= 0x05f4) {
      charType = "R";
    } else if (0x0600 <= charCode && charCode <= 0x06ff) {
      charType = arabicTypes[charCode & 0xff];

      if (!charType) {
        console.log("Bidi: invalid Unicode character " + charCode.toString(16));
      }
    } else if (0x0700 <= charCode && charCode <= 0x08ac) {
      charType = "AL";
    }

    if (charType === "R" || charType === "AL" || charType === "AN") {
      numBidi++;
    }

    types[i] = charType;
  } // Detect the bidi method
  // - If there are no rtl characters then no bidi needed
  // - If less than 30% chars are rtl then string is primarily ltr,
  //   unless the string is very short.
  // - If more than 30% chars are rtl then string is primarily rtl


  if (numBidi === 0) {
    isLTR = true;
    return createBidiText(chars, isLTR);
  }

  if (startLevel === -1) {
    if (numBidi / strLength < 0.3 && strLength > 4) {
      isLTR = true;
      startLevel = 0;
    } else {
      isLTR = false;
      startLevel = 1;
    }
  }

  const levels = [];

  for (i = 0; i < strLength; ++i) {
    levels[i] = startLevel;
  }
  /*
   X1-X10: skip most of this, since we are NOT doing the embeddings.
   */


  const e = isOdd(startLevel) ? "R" : "L";
  const sor = e;
  const eor = sor;
  /*
   W1. Examine each non-spacing mark (NSM) in the level run, and change the
   type of the NSM to the type of the previous character. If the NSM is at the
   start of the level run, it will get the type of sor.
   */

  let lastType = sor;

  for (i = 0; i < strLength; ++i) {
    if (types[i] === "NSM") {
      types[i] = lastType;
    } else {
      lastType = types[i];
    }
  }
  /*
   W2. Search backwards from each instance of a European number until the
   first strong type (R, L, AL, or sor) is found.  If an AL is found, change
   the type of the European number to Arabic number.
   */


  lastType = sor;
  let t;

  for (i = 0; i < strLength; ++i) {
    t = types[i];

    if (t === "EN") {
      types[i] = lastType === "AL" ? "AN" : "EN";
    } else if (t === "R" || t === "L" || t === "AL") {
      lastType = t;
    }
  }
  /*
   W3. Change all ALs to R.
   */


  for (i = 0; i < strLength; ++i) {
    t = types[i];

    if (t === "AL") {
      types[i] = "R";
    }
  }
  /*
   W4. A single European separator between two European numbers changes to a
   European number. A single common separator between two numbers of the same
   type changes to that type:
   */


  for (i = 1; i < strLength - 1; ++i) {
    if (types[i] === "ES" && types[i - 1] === "EN" && types[i + 1] === "EN") {
      types[i] = "EN";
    }

    if (types[i] === "CS" && (types[i - 1] === "EN" || types[i - 1] === "AN") && types[i + 1] === types[i - 1]) {
      types[i] = types[i - 1];
    }
  }
  /*
   W5. A sequence of European terminators adjacent to European numbers changes
   to all European numbers:
   */


  for (i = 0; i < strLength; ++i) {
    if (types[i] === "EN") {
      // do before
      for (let j = i - 1; j >= 0; --j) {
        if (types[j] !== "ET") {
          break;
        }

        types[j] = "EN";
      } // do after


      for (let j = i + 1; j < strLength; ++j) {
        if (types[j] !== "ET") {
          break;
        }

        types[j] = "EN";
      }
    }
  }
  /*
   W6. Otherwise, separators and terminators change to Other Neutral:
   */


  for (i = 0; i < strLength; ++i) {
    t = types[i];

    if (t === "WS" || t === "ES" || t === "ET" || t === "CS") {
      types[i] = "ON";
    }
  }
  /*
   W7. Search backwards from each instance of a European number until the
   first strong type (R, L, or sor) is found. If an L is found,  then change
   the type of the European number to L.
   */


  lastType = sor;

  for (i = 0; i < strLength; ++i) {
    t = types[i];

    if (t === "EN") {
      types[i] = lastType === "L" ? "L" : "EN";
    } else if (t === "R" || t === "L") {
      lastType = t;
    }
  }
  /*
   N1. A sequence of neutrals takes the direction of the surrounding strong
   text if the text on both sides has the same direction. European and Arabic
   numbers are treated as though they were R. Start-of-level-run (sor) and
   end-of-level-run (eor) are used at level run boundaries.
   */


  for (i = 0; i < strLength; ++i) {
    if (types[i] === "ON") {
      const end = findUnequal(types, i + 1, "ON");
      let before = sor;

      if (i > 0) {
        before = types[i - 1];
      }

      let after = eor;

      if (end + 1 < strLength) {
        after = types[end + 1];
      }

      if (before !== "L") {
        before = "R";
      }

      if (after !== "L") {
        after = "R";
      }

      if (before === after) {
        setValues(types, i, end, before);
      }

      i = end - 1; // reset to end (-1 so next iteration is ok)
    }
  }
  /*
   N2. Any remaining neutrals take the embedding direction.
   */


  for (i = 0; i < strLength; ++i) {
    if (types[i] === "ON") {
      types[i] = e;
    }
  }
  /*
   I1. For all characters with an even (left-to-right) embedding direction,
   those of type R go up one level and those of type AN or EN go up two
   levels.
   I2. For all characters with an odd (right-to-left) embedding direction,
   those of type L, EN or AN go up one level.
   */


  for (i = 0; i < strLength; ++i) {
    t = types[i];

    if (isEven(levels[i])) {
      if (t === "R") {
        levels[i] += 1;
      } else if (t === "AN" || t === "EN") {
        levels[i] += 2;
      }
    } else {
      // isOdd
      if (t === "L" || t === "AN" || t === "EN") {
        levels[i] += 1;
      }
    }
  }
  /*
   L1. On each line, reset the embedding level of the following characters to
   the paragraph embedding level:
  	 segment separators,
   paragraph separators,
   any sequence of whitespace characters preceding a segment separator or
   paragraph separator, and any sequence of white space characters at the end
   of the line.
   */
  // don't bother as text is only single line

  /*
   L2. From the highest level found in the text to the lowest odd level on
   each line, reverse any contiguous sequence of characters that are at that
   level or higher.
   */
  // find highest level & lowest odd level


  let highestLevel = -1;
  let lowestOddLevel = 99;
  let level;

  for (i = 0, ii = levels.length; i < ii; ++i) {
    level = levels[i];

    if (highestLevel < level) {
      highestLevel = level;
    }

    if (lowestOddLevel > level && isOdd(level)) {
      lowestOddLevel = level;
    }
  } // now reverse between those limits


  for (level = highestLevel; level >= lowestOddLevel; --level) {
    // find segments to reverse
    let start = -1;

    for (i = 0, ii = levels.length; i < ii; ++i) {
      if (levels[i] < level) {
        if (start >= 0) {
          reverseValues(chars, start, i);
          start = -1;
        }
      } else if (start < 0) {
        start = i;
      }
    }

    if (start >= 0) {
      reverseValues(chars, start, levels.length);
    }
  }
  /*
   L3. Combining marks applied to a right-to-left base character will at this
   point precede their base character. If the rendering engine expects them to
   follow the base characters in the final display process, then the ordering
   of the marks and the base character must be reversed.
   */
  // don't bother for now

  /*
   L4. A character that possesses the mirrored property as specified by
   Section 4.7, Mirrored, must be depicted by a mirrored glyph if the resolved
   directionality of that character is R.
   */
  // don't mirror as characters are already mirrored in the pdf
  // Finally, return string


  for (i = 0, ii = chars.length; i < ii; ++i) {
    const ch = chars[i];

    if (ch === "<" || ch === ">") {
      chars[i] = "";
    }
  }

  return createBidiText(chars, isLTR);
}

function isRTL(char) {
  const charCode = char.charCodeAt(0);
  let charType = "L";

  if (charCode <= 0x00ff) {
    charType = baseTypes[charCode];
  } else if (0x0590 <= charCode && charCode <= 0x05f4) {
    charType = "R";
  } else if (0x0600 <= charCode && charCode <= 0x06ff) {
    charType = arabicTypes[charCode & 0xff];

    if (!charType) {
      console.log("Bidi: invalid Unicode character " + charCode.toString(16));
    }
  } else if (0x0700 <= charCode && charCode <= 0x08ac) {
    charType = "AL";
  }

  if (charType === "R" || charType === "AL" || charType === "AN") {
    return true;
  }

  return false;
} // *** bidi.js ends here ***


function rectsDist([ax1, ay1, ax2, ay2], [bx1, by1, bx2, by2]) {
  let left = bx2 < ax1;
  let right = ax2 < bx1;
  let bottom = by2 < ay1;
  let top = ay2 < by1;

  if (top && left) {
    return Math.hypot(ax1 - bx2, ay2 - by1);
  } else if (left && bottom) {
    return Math.hypot(ax1 - bx2, ay1 - by2);
  } else if (bottom && right) {
    return Math.hypot(ax2 - bx1, ay1 - by2);
  } else if (right && top) {
    return Math.hypot(ax2 - bx1, ay2 - by1);
  } else if (left) {
    return ax1 - bx2;
  } else if (right) {
    return bx1 - ax2;
  } else if (bottom) {
    return ay1 - by2;
  } else if (top) {
    return by1 - ay2;
  }

  return 0;
}

function getClosestOffset(chars, rect) {
  let dist = Infinity;
  let idx = 0;

  for (let i = 0; i < chars.length; i++) {
    let ch = chars[i];
    let distance = rectsDist(ch.rect, rect);

    if (distance < dist) {
      dist = distance;
      idx = i;
    }
  }

  return idx;
}

let isNum = c => c >= '0' && c <= '9';

function getSurroundedNumber(chars, idx) {
  while (idx > 0 && isNum(chars[idx - 1].c) && Math.abs(chars[idx].rect[0] - chars[idx - 1].rect[2]) < chars[idx].rect[2] - chars[idx].rect[0] && Math.abs(chars[idx - 1].rect[1] - chars[idx].rect[1]) < 2) {
    idx--;
  }

  let str = chars[idx].c;

  while (idx < chars.length - 1 && isNum(chars[idx + 1].c) && Math.abs(chars[idx + 1].rect[0] - chars[idx].rect[2]) < chars[idx + 1].rect[2] - chars[idx + 1].rect[0] && Math.abs(chars[idx].rect[1] - chars[idx + 1].rect[1]) < 2) {
    idx++;
    str += chars[idx].c;
  }

  return parseInt(str);
}

function getSurroundedNumberAtPos(chars, x, y) {
  for (let i = 0; i < chars.length; i++) {
    let ch = chars[i];
    let {
      x: x2,
      y: y2
    } = getRectCenter(ch.rect);

    if (isNum(ch.c) && Math.abs(x - x2) < 10 && Math.abs(y - y2) < 5) {
      return getSurroundedNumber(chars, i);
    }
  }

  return null;
}

function getRectCenter(rect) {
  return {
    x: rect[0] + (rect[2] - rect[0]) / 2,
    y: rect[1] + (rect[3] - rect[1]) / 2
  };
}

function filterNums(chars, pageHeight) {
  return chars.filter(x => x.c >= '0' && x.c <= '9' && (x.rect[3] < pageHeight * 1 / 5 || x.rect[1] > pageHeight * 4 / 5));
}

function getPageLabelPoints(pageIndex, chars1, chars2, chars3, chars4, pageHeight) {
  let charsNum1 = filterNums(chars1, pageHeight);
  let charsNum2 = filterNums(chars2, pageHeight);
  let charsNum3 = filterNums(chars3, pageHeight);
  let charsNum4 = filterNums(chars4, pageHeight); // Cut off the logic if one of the pages has too many digits

  if ([charsNum1, charsNum2, charsNum3, charsNum4].find(x => x.length > 500)) {
    return null;
  }

  for (let c1 = 0; c1 < charsNum1.length; c1++) {
    let ch1 = charsNum1[c1];

    for (let c3 = 0; c3 < charsNum3.length; c3++) {
      let ch3 = charsNum3[c3];
      let {
        x: x1,
        y: y1
      } = getRectCenter(ch1.rect);
      let {
        x: x2,
        y: y2
      } = getRectCenter(ch3.rect);

      if (Math.abs(x1 - x2) < 10 && Math.abs(y1 - y2) < 5) {
        let num1 = getSurroundedNumber(charsNum1, c1);
        let num3 = getSurroundedNumber(charsNum3, c3);

        if (num1 && num1 + 2 === num3) {
          let pos1 = {
            x: x1,
            y: y1,
            num: num1,
            idx: pageIndex
          };
          let extractedNum2 = getSurroundedNumberAtPos(chars2, x1, y1);

          if (num1 + 1 === extractedNum2) {
            return [pos1];
          }

          for (let c2 = 0; c2 < charsNum2.length; c2++) {
            let ch2 = charsNum2[c2];

            for (let c4 = 0; c4 < charsNum4.length; c4++) {
              let ch4 = charsNum4[c4];
              let {
                x: x1,
                y: y1
              } = getRectCenter(ch2.rect);
              let {
                x: x2,
                y: y2
              } = getRectCenter(ch4.rect);

              if (Math.abs(x1 - x2) < 10 && Math.abs(y1 - y2) < 5) {
                let num2 = getSurroundedNumber(charsNum2, c2);
                let num4 = getSurroundedNumber(charsNum4, c4);

                if (num1 + 1 === num2 && num2 + 2 === num4) {
                  let pos2 = {
                    x: x1,
                    y: y1,
                    num: num2,
                    idx: pageIndex + 2
                  };
                  return [pos1, pos2];
                }
              }
            }
          }
        }
      }
    }
  }

  return null;
}

function getPageLabel(pageIndex, charsPrev, charsCur, charsNext, points) {
  let numPrev, numCur, numNext; // TODO: Instead of trying to extract from two positions, try to
  //  guess the right position by determining whether the page is even or odd
  // TODO: Take into account font parameters when comparing extracted numbers

  let getNum = (charsNext, points) => points.length > 0 && getSurroundedNumberAtPos(charsNext, points[0].x, points[0].y) || points.length > 1 && getSurroundedNumberAtPos(charsNext, points[1].x, points[1].y);

  if (charsPrev) {
    numPrev = getNum(charsPrev, points);
  }

  numCur = getNum(charsCur, points);

  if (charsNext) {
    numNext = getNum(charsNext, points);
  }

  if (numCur && (numCur - 1 === numPrev || numCur + 1 === numNext)) {
    return numCur.toString();
  }

  if (pageIndex < points[0].idx) {
    return (points[0].num - (points[0].idx - pageIndex)).toString();
  }

  return null;
} // The function is adapted from Xpdf https://www.xpdfreader.com/opensource.html
// Original copyright: 1996-2019 Glyph & Cog, LLC.


function computeWordSpacingThreshold(chars, vertical) {
  // Inter-character spacing that varies by less than this multiple of
  // font size is assumed to be equivalent.
  const uniformSpacing = 0.07; // Typical word spacing, as a fraction of font size.  This will be
  // added to the minimum inter-character spacing, to account for wide
  // character spacing.

  const wordSpacing = 0.1; // Compute the inter-word spacing threshold for a line of chars.
  // Spaces greater than this threshold will be considered inter-word
  // spaces.

  let char, char2;
  let avgFontSize;
  let minAdjGap, maxAdjGap, minSpGap, maxSpGap, minGap, maxGap, gap, gap2;
  let i;
  avgFontSize = 0;
  minGap = maxGap = 0;
  minAdjGap = minSpGap = 1;
  maxAdjGap = maxSpGap = 0;

  for (i = 0; i < chars.length; ++i) {
    char = chars[i];
    avgFontSize += char.fontSize;

    if (i < chars.length - 1) {
      char2 = chars[i + 1];
      gap = vertical ? char2.rect[1] - char.rect[3] : char2.rect[0] - char.rect[2];

      if (char.spaceAfter) {
        if (minSpGap > maxSpGap) {
          minSpGap = maxSpGap = gap;
        } else if (gap < minSpGap) {
          minSpGap = gap;
        } else if (gap > maxSpGap) {
          maxSpGap = gap;
        }
      } else if (minAdjGap > maxAdjGap) {
        minAdjGap = maxAdjGap = gap;
      } else if (gap < minAdjGap) {
        minAdjGap = gap;
      } else if (gap > maxAdjGap) {
        maxAdjGap = gap;
      }

      if (i == 0 || gap < minGap) {
        minGap = gap;
      }

      if (gap > maxGap) {
        maxGap = gap;
      }
    }
  }

  avgFontSize /= chars.length;

  if (minGap < 0) {
    minGap = 0;
  } // if spacing is nearly uniform (minGap is close to maxGap), use the
  // SpGap/AdjGap values if available, otherwise assume it's a single
  // word (technically it could be either "ABC" or "A B C", but it's
  // essentially impossible to tell)


  if (maxGap - minGap < uniformSpacing * avgFontSize) {
    if (minAdjGap <= maxAdjGap && minSpGap <= maxSpGap && minSpGap - maxAdjGap > 0.01) {
      return 0.5 * (maxAdjGap + minSpGap);
    } else {
      return maxGap + 1;
    } // if there is some variation in spacing, but it's small, assume
    // there are some inter-word spaces

  } else if (maxGap - minGap < wordSpacing * avgFontSize) {
    return 0.5 * (minGap + maxGap); // if there is a large variation in spacing, use the SpGap/AdjGap
    // values if they look reasonable, otherwise, assume a reasonable
    // threshold for inter-word spacing (we can't use something like
    // 0.5*(minGap+maxGap) here because there can be outliers at the
    // high end)
  } else if (minAdjGap <= maxAdjGap && minSpGap <= maxSpGap && minSpGap - maxAdjGap > uniformSpacing * avgFontSize) {
    gap = wordSpacing * avgFontSize;
    gap2 = 0.5 * (minSpGap - minGap);
    return minGap + (gap < gap2 ? gap : gap2);
  } else {
    return minGap + wordSpacing * avgFontSize;
  }
}

function overlaps(rect1, rect2, rotation) {
  if ([0, 180].includes(rotation)) {
    return rect1[1] <= rect2[1] && rect2[1] <= rect1[3] || rect2[1] <= rect1[1] && rect1[1] <= rect2[3];
  }

  return rect1[0] <= rect2[0] && rect2[0] <= rect1[2] || rect2[0] <= rect1[0] && rect1[0] <= rect2[2];
}

function charHeight(char) {
  return !char.rotation && char.rect[3] - char.rect[1] || char.rotation === 90 && char.rect[2] - char.rect[0] || char.rotation === 180 && char.rect[1] - char.rect[3] || char.rotation === 270 && char.rect[0] - char.rect[2];
}

function getLines(chars, reflowRTL) {
  if (!chars.length) {
    return [];
  }

  let lines = [];
  let line = {
    from: 0,
    to: 0,
    vertical: [90, 270].includes(chars[0].rotation),
    rect: chars[0].rect.slice(),
    str: ''
  };
  let hasRTL = false;

  for (let char of chars) {
    if (isRTL(char.c)) {
      hasRTL = true;
      break;
    }
  }

  for (let i = 1; i < chars.length; i++) {
    let char = chars[i];
    let prevChar = chars[i - 1];

    if ( // Caret jumps to the next line start
    !hasRTL && (!char.rotation && prevChar.rect[0] > char.rect[0] || char.rotation === 90 && prevChar.rect[1] > char.rect[1] || char.rotation === 180 && prevChar.rect[0] < char.rect[0] || char.rotation === 270 && prevChar.rect[1] < char.rect[1]) || hasRTL && char.baseline !== prevChar.baseline // Rotation changes
    || prevChar.rotation !== char.rotation // Chars aren't in the same line
    || !overlaps(prevChar.rect, char.rect, char.rotation) // Line's first char is more than 2x larger than the following char
    || line.from === line.to && charHeight(prevChar) > charHeight(char) * 2) {
      lines.push(line);

      if (reflowRTL) {
        let lineChars = chars.slice(line.from, line.to + 1);
        lineChars.sort((a, b) => {
          return a.rect[0] + (a.rect[2] - a.rect[0]) / 2 - (b.rect[0] + (b.rect[2] - b.rect[0]) / 2);
        });
        bidi(lineChars, -1, false);
        chars.splice(line.from, line.to - line.from + 1, ...lineChars);
      }

      line = {
        from: i,
        to: i,
        vertical: [90, 270].includes(char.rotation),
        rect: char.rect.slice(),
        str: ''
      };
    } else {
      line.to++; // Update line bounding rect

      line.rect[0] = Math.min(line.rect[0], char.rect[0]);
      line.rect[1] = Math.min(line.rect[1], char.rect[1]);
      line.rect[2] = Math.max(line.rect[2], char.rect[2]);
      line.rect[3] = Math.max(line.rect[3], char.rect[3]);
      line.str += char.c;
    }
  } // Push last line


  lines.push(line);

  for (let line of lines) {
    line.words = [];
    let wordSp = computeWordSpacingThreshold(chars.slice(line.from, line.to + 1), line.vertical);

    for (let i = line.from; i <= line.to; i++) {
      let sp = wordSp - 1;
      let spaceAfter = false;
      let j;

      for (j = i + 1; j <= line.to; ++j) {
        let char = chars[j - 1];
        let char2 = chars[j];
        let rtl = char2.rect[2] < char.rect[2];
        sp = line.vertical ? char2.rect[1] - char.rect[3] : rtl ? char.rect[0] - char2.rect[2] : char2.rect[0] - char.rect[2];

        if (sp > wordSp) {
          spaceAfter = true;
          break;
        }

        let punctuation = '?.,;!¡¿。、·(){}[]/$';

        if (punctuation.includes(char.c) || punctuation.includes(char2.c)) {
          break;
        }
      }

      line.words.push({
        from: i,
        to: j - 1,
        spaceAfter
      });
      i = j - 1;
    }
  }

  return lines;
}

function extractLinks(lines, chars) {
  let spaceBefore = new Set();

  for (let line of lines) {
    for (let word of line.words) {
      if (word.spaceAfter) {
        spaceBefore.add(word.to + 1);
      }
    }
  }

  let sequences = [];
  let sequence = {
    from: 0,
    to: 0,
    lbp: []
  };
  let urlBreakChars = ['&', '.', '#', '?', '/'];

  for (let i = 0; i < chars.length; i++) {
    let char = chars[i];
    let charBefore = chars[i - 1];

    if (spaceBefore.has(i) || charBefore && (char.fontSize !== charBefore.fontSize || char.fontName !== charBefore.fontName || charBefore.rect[0] > char.rect[0] && (charBefore.rect[1] - char.rect[3] > (char.rect[3] - char.rect[1]) / 2 || !(urlBreakChars.includes(charBefore.c) || urlBreakChars.includes(char.c))))) {
      sequences.push(sequence);
      sequence = {
        from: i,
        to: i
      };
    } else {
      sequence.to = i;
    }
  }

  if (sequence.from !== sequence.to) {
    sequences.push(sequence);
  }

  let links = [];
  let urlRegExp = new RegExp(/(https?:\/\/|www\.|10\.)[-a-zA-Z0-9@:%._\+~#=]{1,256}\.[a-zA-Z0-9()]{1,6}\b([-a-zA-Z0-9()@:%_\+.~#?&\/\/=]*)/);
  let doiRegExp = new RegExp(/10(?:\.[0-9]{4,})?\/[^\s]*[^\s\.,]/);

  for (let sequence of sequences) {
    let text = '';

    for (let j = sequence.from; j <= sequence.to; j++) {
      let char = chars[j];
      text += char.c;
    }

    let match = text.match(doiRegExp);

    if (match) {
      let from = sequence.from + match.index;
      let to = from + match[0].length;
      let url = 'http://dx.doi.org/' + encodeURIComponent(match[0]);
      links.push({
        from,
        to,
        text: match[0],
        url
      });
      continue;
    }

    match = text.match(urlRegExp);

    if (match) {
      let url = match[0];

      if (url.includes('@')) {
        continue;
      }

      url = url.replace(/[.)]*$/, '');
      let from = sequence.from + match.index;
      let to = from + url.length;
      links.push({
        from,
        to,
        url
      });
    }
  }

  return links;
}

function isDash(c) {
  let re = /[\x2D\u058A\u05BE\u1400\u1806\u2010-\u2015\u2E17\u2E1A\u2E3A\u2E3B\u301C\u3030\u30A0\uFE31\uFE32\uFE58\uFE63\uFF0D]/;
  return re.test(c);
}

function text_quickIntersectRect(r1, r2) {
  return !(r2[0] > r1[2] || r2[2] < r1[0] || r2[1] > r1[3] || r2[3] < r1[1]);
}

function getCenterRect(r) {
  return [r[0] + (r[2] - r[0]) / 2, r[1] + (r[3] - r[1]) / 2, r[0] + (r[2] - r[0]) / 2, r[1] + (r[3] - r[1]) / 2];
}

function getRangeBySelection({
  chars,
  anchor,
  head,
  reverse
}) {
  // Note: Offsets can be between 0 and chars.length (the cursor can after the last char)
  if (!chars.length) {
    return null;
  }

  let anchorOffset = reverse ? chars.length - 1 : 0;
  let headOffset = reverse ? 0 : chars.length - 1;
  let x1, y1, x2, y2;

  if (Number.isInteger(anchor)) {
    anchorOffset = anchor;
    anchorOffset = anchorOffset < 0 ? 0 : anchorOffset;
    anchorOffset = anchorOffset > chars.length ? chars.length : anchorOffset;
  } else if (Array.isArray(anchor)) {
    [x1, y1] = anchor;
    anchorOffset = getClosestOffset(chars, [x1, y1, x1, y1]);
  }

  if (Number.isInteger(head)) {
    headOffset = head;
    headOffset = headOffset < 0 ? 0 : headOffset;
    headOffset = headOffset > chars.length ? chars.length : headOffset;
  } else if (Array.isArray(head)) {
    [x2, y2] = head;
    headOffset = getClosestOffset(chars, [x2, y2, x2, y2]);
  }

  if (Array.isArray(anchor)) {
    let {
      rotation,
      rect,
      c
    } = chars[anchorOffset];
    let rtl = isRTL(c);

    if (rtl && !rotation && x1 < rect[0] + (rect[2] - rect[0]) / 2 || !rtl && (!rotation && x1 > rect[0] + (rect[2] - rect[0]) / 2 || rotation === 90 && y1 > rect[1] + (rect[3] - rect[1]) / 2 || rotation === 180 && x1 < rect[0] + (rect[2] - rect[0]) / 2 || rotation === 270 && y1 < rect[1] + (rect[3] - rect[1]) / 2)) {
      anchorOffset++;
    }
  }

  if (Array.isArray(head)) {
    let {
      rotation,
      rect,
      c
    } = chars[headOffset];
    let rtl = isRTL(c);

    if (rtl && !rotation && x2 < rect[0] + (rect[2] - rect[0]) / 2 || !rtl && (!rotation && x2 > rect[0] + (rect[2] - rect[0]) / 2 || rotation === 90 && y2 > rect[1] + (rect[3] - rect[1]) / 2 || rotation === 180 && x2 < rect[0] + (rect[2] - rect[0]) / 2 || rotation === 270 && y2 < rect[1] + (rect[3] - rect[1]) / 2)) {
      headOffset++;
    }
  }

  return getRange(chars, anchorOffset, headOffset);
}

function getRangeByHighlight(chars, rects) {
  if (!chars.length) {
    return null;
  }

  let anchorOffset = Infinity;

  for (let i = 0; i < chars.length; i++) {
    let char = chars[i];

    if (text_quickIntersectRect(getCenterRect(char.rect), rects[0])) {
      anchorOffset = i;
      break;
    }
  }

  let headOffset = 0;

  for (let i = chars.length - 1; i >= 0; i--) {
    let char = chars[i];

    if (text_quickIntersectRect(getCenterRect(char.rect), rects[rects.length - 1])) {
      headOffset = i;
      break;
    }
  }

  headOffset++;

  if (anchorOffset > headOffset) {
    return null;
  }

  let range = getRange(chars, anchorOffset, headOffset);
  range.offset = range.anchorOffset;
  delete range.anchorOffset;
  delete range.headOffset;
  return range;
}

function getLineselectionRect(line, charFrom, charTo) {
  if (line.vertical) {
    return [line.rect[0], Math.min(charFrom.rect[1], charTo.rect[1]), line.rect[2], Math.max(charFrom.rect[3], charTo.rect[3])];
  } else {
    return [Math.min(charFrom.rect[0], charTo.rect[0]), line.rect[1], Math.max(charFrom.rect[2], charTo.rect[2]), line.rect[3]];
  }
}

function getRange(chars, anchorOffset, headOffset) {
  let lines = getLines(chars);
  let charStart;
  let charEnd;

  if (anchorOffset < headOffset) {
    charStart = chars[anchorOffset];
    charEnd = chars[headOffset - 1];
  } else if (anchorOffset > headOffset) {
    charStart = chars[headOffset];
    charEnd = chars[anchorOffset - 1];
  } else {
    return {
      collapsed: true,
      anchorOffset,
      headOffset,
      rects: [],
      text: ''
    };
  } // Get text


  let text = '';
  let extracting = false;

  loop1: for (let line of lines) {
    for (let word of line.words) {
      let isLastWord = word === line.words[line.words.length - 1];

      for (let i = word.from; i <= word.to; i++) {
        let char = chars[i];
        let isLastChar = i === word.to;

        if (char === charStart) {
          extracting = true;
        }

        if (!extracting || isLastWord && isLastChar && isDash(char.c) && char !== charEnd) {
          continue;
        }

        text += char.c;

        if (isLastChar && (word.spaceAfter || isLastWord) && text[text.length - 1] !== ' ') {
          text += ' ';
        }

        if (char === charEnd) {
          break loop1;
        }
      }
    }
  }

  text = text.trim(); // Get rects

  extracting = false;
  let rects = [];

  loop2: for (let line of lines) {
    let charFrom = null;
    let charTo = null;

    for (let word of line.words) {
      for (let i = word.from; i <= word.to; i++) {
        let char = chars[i];

        if (char === charStart || extracting && !charFrom) {
          extracting = true;
          charFrom = char;
        }

        if (extracting) {
          charTo = char;

          if (char === charEnd) {
            rects.push(getLineselectionRect(line, charFrom, charTo));
            break loop2;
          }
        }
      }
    }

    if (extracting) {
      rects.push(getLineselectionRect(line, charFrom, charTo));
      charFrom = null;
    }
  }

  rects = rects.map(rect => rect.map(value => parseFloat(value.toFixed(3))));
  return {
    anchorOffset,
    headOffset,
    rects,
    text
  };
}

function getNextLineClosestOffset(chars, offset) {
  if (!chars.length) {
    return null;
  }

  if (offset < 0) {
    offset = 0;
  } else if (offset >= chars.length) {
    offset = chars.length - 1;
  }

  let lines = getLines(chars);
  let char = chars[offset];
  let idx = lines.findIndex(line => line.from <= offset && offset >= line.to);

  if (idx < lines.length - 1) {
    let line = lines[idx + 1];
    let lineChars = chars.slice(line.from, line.to + 1);
    return line.from + getClosestOffset(lineChars, char.rect);
  }

  return chars.length;
}

function getPrevLineClosestOffset(chars, offset) {
  if (!chars.length) {
    return null;
  }

  if (offset < 0) {
    offset = 0;
  } else if (offset >= chars.length) {
    offset = chars.length - 1;
  }

  let lines = getLines(chars);
  let char = chars[offset];
  let idx = lines.findIndex(line => line.from <= offset && offset >= line.to);

  if (idx > 0) {
    let line = lines[idx - 1];
    let lineChars = chars.slice(line.from, line.to + 1);
    return line.from + getClosestOffset(lineChars, char.rect);
  }

  return 0;
}

function getClosestWord(chars, rect) {
  if (!chars.length) {
    return null;
  }

  let lines = getLines(chars);
  let offset = getClosestOffset(chars, rect);
  let line = lines.find(line => line.from <= offset && offset <= line.to);
  let word = line.words.find(word => word.from <= offset && offset <= word.to);
  return {
    anchorOffset: word.from,
    headOffset: word.to + 1
  };
}

function getClosestLine(chars, rect) {
  if (!chars.length) {
    return null;
  }

  let lines = getLines(chars);
  let offset = getClosestOffset(chars, rect);
  let line = lines.find(line => line.from <= offset && offset <= line.to);
  return {
    anchorOffset: line.from,
    headOffset: line.to + 1
  };
}

 // module.exports = {
// 	getLines,
// 	getClosestOffset,
// 	getPageLabelPoints,
// 	getPageLabel,
// 	getRangeByHighlight
// };
// CONCATENATED MODULE: ./src/lib/extract.js



class extract_Extractor {
  constructor(pdfViewer, getAnnotations) {
    this.pdfViewer = pdfViewer;
    this.getAnnotations = getAnnotations;
    this.charsCache = {};
    this.pageLabelsCache = {};
    this.pageLabelPointsCache = undefined;
    this.pageLinks = {};
  }

  async getPageChars(pageIndex) {
    if (this.charsCache[pageIndex]) {
      return this.charsCache[pageIndex];
    }

    let page = await this.pdfViewer.pdfDocument.getPage(pageIndex + 1);
    let textContent = await page.getTextContent();
    let fingerprints = new Set();
    let chars = [];

    for (let item of textContent.items) {
      for (let char of item.chars) {
        // Note: Rotation is rounded in PDF.js
        if (char.rotation % 90 === 0 && char.c !== ' ' // Sometimes char can map to null and break strings
        && char.c.charCodeAt(0)) {
          // Some PDF files have their text layer characters repeated many times, therefore remove them
          let fingerprint = char.c + char.rect.join('');

          if (!fingerprints.has(fingerprint)) {
            fingerprints.add(fingerprint);
            chars.push(char);
          }
        }
      }
    } // Reverse RTL lines


    let lines = getLines(chars, true);
    let links = extractLinks(lines, chars);
    this.pageLinks[pageIndex] = links;
    this.charsCache[pageIndex] = chars;

    for (let link of links) {
      let range = this.extractRange({
        pageIndex,
        anchor: link.from,
        head: link.to
      });
      link.position = range.position;
    }

    return chars;
  }

  getPageCharsSync(pageIndex) {
    let chars = this.charsCache[pageIndex];
    return chars && chars.length ? chars : null;
  }

  getNextLineClosestOffset(pageIndex, offset) {
    let chars = this.getPageCharsSync(pageIndex);
    return chars && getNextLineClosestOffset(chars, offset);
  }

  getPrevLineClosestOffset(pageIndex, offset) {
    let chars = this.getPageCharsSync(pageIndex);
    return chars && getPrevLineClosestOffset(chars, offset);
  }

  getClosestWord(position) {
    let chars = this.getPageCharsSync(position.pageIndex);
    return chars && getClosestWord(chars, position.rects[0]);
  }

  getClosestLine(position) {
    let chars = this.getPageCharsSync(position.pageIndex);
    return chars && getClosestLine(chars, position.rects[0]);
  }

  extractRange({
    pageIndex,
    anchor,
    head,
    reverse
  }) {
    let chars = this.getPageCharsSync(pageIndex);

    if (!chars) {
      return null;
    }

    let range = getRangeBySelection({
      chars,
      anchor,
      head,
      reverse
    });

    if (!range) {
      return null;
    }

    range.position = {
      pageIndex,
      rects: range.rects
    };
    delete range.rects;
    return range;
  }

  async getSortIndex(position) {
    let chars = await this.getPageChars(position.pageIndex);
    let page = position.pageIndex;
    let offset = chars.length && getClosestOffset(chars, position.rects[0]) || 0;
    let pageHeight = (await this.pdfViewer.pdfDocument.getPage(position.pageIndex + 1)).view[3];
    let top = pageHeight - position.rects[0][3];

    if (top < 0) {
      top = 0;
    }

    return [page.toString().slice(0, 5).padStart(5, '0'), offset.toString().slice(0, 6).padStart(6, '0'), Math.floor(top).toString().slice(0, 5).padStart(5, '0')].join('|');
  }

  async extractPageLabelPoints() {
    if (this.pageLabelPointsCache !== undefined) {
      return this.pageLabelPointsCache;
    }

    for (let i = 0; i < 5 && i + 3 < this.pdfViewer.pdfDocument.numPages; i++) {
      let pageHeight = (await this.pdfViewer.pdfDocument.getPage(i + 1)).view[3];
      let chars1 = await this.getPageChars(i);
      let chars2 = await this.getPageChars(i + 1);
      let chars3 = await this.getPageChars(i + 2);
      let chars4 = await this.getPageChars(i + 3);
      let res = getPageLabelPoints(i, chars1, chars2, chars3, chars4, pageHeight);

      if (res) {
        this.pageLabelPointsCache = res;
        return res;
      }
    }

    this.pageLabelPointsCache = null;
    return null;
  }

  async extractPageLabel(pageIndex) {
    let points = await this.extractPageLabelPoints();

    if (!points) {
      return null;
    }

    let charsPrev, charsCur, charsNext;

    if (pageIndex > 0) {
      charsPrev = await this.getPageChars(pageIndex - 1);
    }

    charsCur = await this.getPageChars(pageIndex);

    if (pageIndex < this.pdfViewer.pdfDocument.numPages - 1) {
      charsNext = await this.getPageChars(pageIndex + 1);
    }

    return getPageLabel(pageIndex, charsPrev, charsCur, charsNext, points);
  }

  clearLabelsCache() {
    this.pageLabelsCache = {};
  }

  async getPageLabel(pageIndex, usePrevAnnotation) {
    if (!usePrevAnnotation && this.pageLabelsCache[pageIndex]) {
      return this.pageLabelsCache[pageIndex];
    }

    let extractedPageLabel = await this.extractPageLabel(pageIndex);
    let assignedPageLabel;
    let pageLabels = this.pdfViewer._pageLabels;

    if (pageLabels && pageLabels[pageIndex]) {
      assignedPageLabel = pageLabels[pageIndex];
    }

    let pageLabel = (pageIndex + 1).toString();

    if (extractedPageLabel) {
      pageLabel = extractedPageLabel;
    } else if (assignedPageLabel) {
      pageLabel = assignedPageLabel;
    }

    if (usePrevAnnotation) {
      let annotations = this.getAnnotations().reverse();

      for (let annotation of annotations) {
        // Ignore read-only annotation because user can't fix its page label
        if (!annotation.readOnly && annotation.pageLabel !== '-' && annotation.position.pageIndex <= pageIndex) {
          if (parseInt(annotation.pageLabel) == annotation.pageLabel || /[0-9]+[-\u2013][0-9]+/.test(annotation.pageLabel)) {
            pageLabel = (pageIndex + (parseInt(annotation.pageLabel) - annotation.position.pageIndex)).toString();
          }

          break;
        }
      }
    } else {
      this.pageLabelsCache[pageIndex] = pageLabel;
    }

    return pageLabel;
  }

  getCachedPageLabel(pageIndex) {
    if (this.pageLabelsCache[pageIndex]) {
      return this.pageLabelsCache[pageIndex];
    }

    return null;
  }

  async getPageIndexByLabel(pageLabel) {
    let numericPageLabel = parseInt(pageLabel);
    let points = await this.extractPageLabelPoints();

    if (points && numericPageLabel == pageLabel) {
      let targetPageIndex = points[0].idx + (numericPageLabel - points[0].num);

      if (targetPageIndex >= 0 && targetPageIndex < this.pdfViewer.pdfDocument.numPages) {
        let targetPageLabel = await this.extractPageLabel(targetPageIndex);

        if (targetPageLabel == pageLabel) {
          return targetPageIndex;
        }
      }
    }

    let pageLabels = this.pdfViewer._pageLabels;

    if (pageLabels) {
      let targetPageIndex = pageLabels.indexOf(pageLabel);

      if (targetPageIndex !== -1) {
        return targetPageIndex;
      }
    }

    if (numericPageLabel == pageLabel && numericPageLabel > 0) {
      return numericPageLabel - 1;
    }

    return null;
  }

  getPageLinks(pageIndex) {
    let links = this.pageLinks[pageIndex];

    if (!links) {
      return [];
    }

    return links;
  }

}
// CONCATENATED MODULE: ./src/viewer.js












class viewer_Viewer {
  constructor(options) {
    defineProperty_default()(this, "handleDownloadButtonClick", () => {
      this.options.onDownload();
    });

    defineProperty_default()(this, "handleZoomAutoButtonClick", () => {
      PDFViewerApplication.pdfViewer.currentScaleValue = 'page-width';
    });

    defineProperty_default()(this, "handleNavigateBackButtonClick", () => {
      window.history.back();
    });

    defineProperty_default()(this, "handlePageRender", async event => {
      // Extract all text rects that will be used for showing text cursor
      let pageIndex = event.pageNumber - 1;
      let position = {
        pageIndex,
        rects: []
      };
      await window.extractor.getPageChars(pageIndex);
      let selectionRange = window.extractor.extractRange({
        pageIndex
      });

      if (selectionRange) {
        position = selectionRange.position;
      }

      window.pageTextPositions[pageIndex] = position;
    });

    defineProperty_default()(this, "handleViewAreaUpdate", e => {
      let state = {
        pageIndex: e.location.pageNumber - 1,
        scale: e.location.scale,
        rotation: e.location.rotation,
        top: e.location.top,
        left: e.location.left,
        sidebarView: window.PDFViewerApplication.pdfSidebar.isOpen ? window.PDFViewerApplication.pdfSidebar.active : 0,
        sidebarWidth: window.PDFViewerApplication.pdfSidebarResizer._width || 200,
        scrollMode: PDFViewerApplication.pdfViewer.scrollMode,
        spreadMode: PDFViewerApplication.pdfViewer.spreadMode
      };
      this._lastState = state;

      this._onSetState(state); // Enable/disable navigate back button


      let canNavigateBack = true;

      try {
        let {
          uid
        } = window.history.state;

        if (uid == 0) {
          canNavigateBack = false;
        }
      } catch (e) {}

      document.getElementById('navigateBack').disabled = !canNavigateBack;
    });

    defineProperty_default()(this, "handleSidebarViewChange", e => {
      if (this._lastState) {
        this._lastState.sidebarView = e.view;

        this._onSetState(this._lastState);
      } // Without this context pane in stacked mode is hidden on first tab open


      setTimeout(() => {
        PDFViewerApplication.eventBus.dispatch('resize');
      }, 50);

      if (this._enableSidebarOpenEvent) {
        this.options.onChangeSidebarOpen(!!e.view);
      }
    });

    defineProperty_default()(this, "handleDocumentInit", async () => {
      // PDFViewerApplication.pdfSidebar.switchView(9);
      if (this.options.state) {
        this._setState(this.options.state, !!this.options.location);
      } // Default state
      else {
        PDFViewerApplication.pdfViewer.currentScaleValue = 'page-width';
      }

      await this._annotatorPromise;

      if (this._uninitialized) {
        return;
      }

      if (this.options.location) {
        this.annotatorRef.current.navigate(this.options.location);
      } // Can't be in the constructor because gets triggered by the initial
      // sidebar configuration


      window.PDFViewerApplication.eventBus.on('sidebarviewchanged', this.handleSidebarViewChange);
    });

    defineProperty_default()(this, "handleChangeSidebarWidth", width => {
      this.options.onChangeSidebarWidth(width);
    });

    defineProperty_default()(this, "handlePointerDown", event => {
      let isLeft = event.button === 0;
      let isRight = event.button === 2;
      let isCtrl = event.ctrlKey || event.metaKey;
      let isShift = event.shiftKey;
      let node = event.target.closest('.thumbnail');

      if (!node) {
        return;
      }

      if (isLeft) {
        if (isShift) {
          let allNodes = Array.from(document.querySelectorAll('.thumbnail'));
          let idx = allNodes.indexOf(node);
          let idx2 = allNodes.findIndex(x => x !== node && x.classList.contains('extra-selected'));
          let from = Math.min(idx, idx2);
          let to = Math.max(idx, idx2);
          allNodes.slice(from, to + 1).forEach(x => x.classList.add('extra-selected'));
          return;
        }

        if (!isCtrl) {
          document.querySelectorAll('.thumbnail.extra-selected').forEach(x => x.classList.remove('extra-selected'));
        }

        node.classList.add('extra-selected');
      } else if (isRight) {
        if (!node.classList.contains('extra-selected')) {
          document.querySelectorAll('.thumbnail.extra-selected').forEach(x => x.classList.remove('extra-selected'));
          node.classList.add('extra-selected');
        }

        let pageIndexes = Array.from(document.querySelectorAll('.thumbnail.extra-selected')).map(x => parseInt(x.getAttribute('data-page-number')) - 1);
        this.options.onPopup('openThumbnailPopup', {
          x: event.screenX,
          y: event.screenY,
          pageIndexes
        });
      }
    });

    defineProperty_default()(this, "handleClick", event => {
      if (event.button === 0 // On FF target is document node when mouseup is outside of pdf-reader
      && event.target.nodeType === Node.ELEMENT_NODE && event.target.closest('.annotationLayer') && !event.target.classList.contains('internalLink')) {
        event.preventDefault();
        event.stopPropagation();

        if (!PDFViewerApplication.pdfViewer.isInPresentationMode && event.target.href) {
          this.options.onExternalLink(event.target.href);
        }
      }
    });

    defineProperty_default()(this, "handleDragStart", event => {
      if (event.target.nodeType === Node.ELEMENT_NODE && (event.target.closest('.annotationLayer') || !event.target.closest('#viewer') && !event.target.closest('#annotationsView'))) {
        event.preventDefault();
      }
    });

    defineProperty_default()(this, "setColor", color => {
      this.annotatorRef.current.setColor(color);
    });

    defineProperty_default()(this, "openPageLabelPopup", data => {
      this.annotatorRef.current.openPageLabelPopup(data);
    });

    defineProperty_default()(this, "editHighlightedText", data => {
      this.annotatorRef.current.editHighlightedText(data);
    });

    defineProperty_default()(this, "clearFilter", () => {
      this.annotatorRef.current.clearFilter();
    });

    defineProperty_default()(this, "navigate", async location => {
      await this._annotatorPromise;
      await this._pdfjsPromise;

      if (this._uninitialized) {
        return;
      }

      this.annotatorRef.current.navigate(location);
    });

    defineProperty_default()(this, "setEnableAddToNote", async enable => {
      await this._annotatorPromise;
      await this._pdfjsPromise;

      if (this._uninitialized) {
        return;
      }

      this.annotatorRef.current.setEnableAddToNote(enable);
    });

    this.options = options;
    this._loaded = false;
    this._onSetState = debounce(function (state) {
      options.onSetState(state);
    }, 100);
    this._userID = options.userID;
    this._label = options.label;
    this._lastState = null;
    this._uninitialized = false; // TODO: Find a better way to determine the event origin

    this._enableSidebarOpenEvent = true;
    this.setBottomPlaceholderHeight(this.options.bottomPlaceholderHeight);
    this._annotatorPromise = new Promise(resolve => {
      this._annotatorPromiseResolve = resolve;
    });
    this._pdfjsPromise = new Promise(resolve => {
      this._pdfjsPromiseResolve = resolve;
    });
    this._annotationsStore = new annotations_store({
      readOnly: options.readOnly,
      authorName: options.authorName,
      annotations: options.annotations,
      onSave: options.onSaveAnnotations,
      onDelete: options.onDeleteAnnotations,
      onRender: annotations => {
        this.annotatorRef.current.setAnnotations([...annotations]);
      }
    });
    window.pageTextPositions = {};

    window.drawAnnotations = (canvas, viewport, pageIndex) => {
      let annotations = this._annotationsStore._annotations.filter(x => x.position.pageIndex === pageIndex);

      drawAnnotationsOnCanvas(canvas, viewport, annotations);
    };

    this._initSelectionBox();

    this._applyExtraLocalizations(); // Takeover the download button


    PDFViewerApplication.download = function () {}; // Sidebar configuration must be finished before loading the PDF
    // to avoid the immediate resize and re-render of PDF pages


    if (window.isWeb) {
      PDFViewerApplication.pdfSidebar.switchView(9);
    } else {
      if (this.options.sidebarOpen) {
        PDFViewerApplication.pdfSidebar.setInitialView(9);
      } else {
        PDFViewerApplication.pdfSidebar.switchView(9);
      }
    }

    window.PDFViewerApplication.pdfSidebarResizer._updateWidth(this.options.sidebarWidth);

    document.getElementById('download').addEventListener('click', this.handleDownloadButtonClick);
    document.getElementById('zoomAuto').addEventListener('click', this.handleZoomAutoButtonClick);
    document.getElementById('navigateBack').addEventListener('click', this.handleNavigateBackButtonClick);
    window.PDFViewerApplication.eventBus.on('pagerendered', this.handlePageRender);
    window.PDFViewerApplication.eventBus.on('updateviewarea', this.handleViewAreaUpdate);
    window.PDFViewerApplication.eventBus.on('documentinit', this.handleDocumentInit);
    window.onChangeSidebarWidth = this.handleChangeSidebarWidth; // document.getElementById('back').addEventListener('click', this.handleBackButtonClick);
    // document.getElementById('forward').addEventListener('click', this.handleForwardButtonClick);
    // Override the external link click handling

    window.addEventListener('mousedown', this.handlePointerDown, true);
    window.addEventListener('click', this.handleClick, true); // Prevent dragging for internal links

    window.addEventListener('dragstart', this.handleDragStart); // window.PDFViewerApplication.eventBus.on("pagesinit", () => {
    //   window.PDFViewerApplication.pdfDocument._transport.messageHandler.sendWithPromise("setIgnoredAnnotationIDs", options.ignoredAnnotationIDs);
    // });

    window.PDFViewerApplication.eventBus.on('pagesinit', () => {
      this._pdfjsPromiseResolve(); // For development purposes only, when dropping various test files to the same window


      window.extractor = new extract_Extractor(window.PDFViewerApplication.pdfViewer, () => this._annotationsStore._annotations);
    });
    window.extractor = new extract_Extractor(window.PDFViewerApplication.pdfViewer);
    this.annotatorRef = /*#__PURE__*/external_React_default.a.createRef();
    this.node = document.createElement('div');
    external_ReactDOM_default.a.render( /*#__PURE__*/external_React_default.a.createElement(external_ReactIntl_["IntlProvider"], {
      locale: window.navigator.language,
      messages: this.options.localizedStrings,
      onError: window.development && (() => {})
    }, /*#__PURE__*/external_React_default.a.createElement(annotator, {
      readOnly: options.readOnly,
      authorName: options.authorName,
      onAddAnnotation: this._annotationsStore.addAnnotation.bind(this._annotationsStore),
      onUpdateAnnotations: this._annotationsStore.updateAnnotations.bind(this._annotationsStore),
      onDeleteAnnotations: this._annotationsStore.deleteAnnotations.bind(this._annotationsStore),
      onClickTags: options.onClickTags,
      onDoubleClickPageLabel: options.onDoubleClickPageLabel,
      onPopup: options.onPopup,
      onClosePopup: options.onClosePopup,
      onAddToNote: options.onAddToNote,
      onFocusSplitButton: options.onFocusSplitButton,
      onFocusContextPane: options.onFocusContextPane,
      onExternalLink: options.onExternalLink,
      ref: this.annotatorRef
    })), this.node, () => {
      this._annotationsStore.render();

      this._annotatorPromiseResolve();
    });
    setTimeout(function () {
      window.PDFViewerApplication.open(options.buf);
    }, 0);
  }

  uninit() {
    window.PDFViewerApplication.pdfDocument.uninitialized = true;
    external_ReactDOM_default.a.unmountComponentAtNode(this.node);
    document.getElementById('download').removeEventListener('click', this.handleDownloadButtonClick);
    document.getElementById('zoomAuto').removeEventListener('click', this.handleZoomAutoButtonClick);
    document.getElementById('navigateBack').removeEventListener('click', this.handleNavigateBackButtonClick);
    window.PDFViewerApplication.eventBus.off('pagerendered', this.handlePageRender);
    window.PDFViewerApplication.eventBus.off('updateviewarea', this.handleViewAreaUpdate);
    window.PDFViewerApplication.eventBus.off('sidebarviewchanged', this.handleSidebarViewChange);
    window.PDFViewerApplication.eventBus.off('documentinit', this.handleDocumentInit); // document.getElementById('back').removeEventListener('click', this.handleBackButtonClick);
    // document.getElementById('forward').removeEventListener('click', this.handleForwardButtonClick);

    window.removeEventListener('click', this.handleClick);
    window.removeEventListener('dragstart', this.handleDragStart);
    window.PDFViewerApplication.close();
    this._uninitialized = true;
    window.extractor.charsCache = {};
  }

  _initSelectionBox() {
    let box = document.createElement('textarea');
    box.tabIndex = -1;
    box.style = 'position: absolute;top: 0;left: 0;width: 0;height: 0;z-index: -1;pointer-events: none;';
    document.body.append(box);
    window.selectionBox = box;
  }

  _getLocalizedString(key) {
    let string = this.options.localizedStrings[key];
    return string || key;
  }

  _applyExtraLocalizations() {
    document.getElementById('zoomAuto').setAttribute('title', this._getLocalizedString('pdfReader.zoomPageWidth'));
    document.getElementById('navigateBack').setAttribute('title', this._getLocalizedString('general.back'));
    document.getElementById('viewAnnotations').setAttribute('title', this._getLocalizedString('pdfReader.showAnnotations'));
  }

  setAnnotations(annotation) {
    this._annotationsStore.setAnnotations(annotation);
  }

  unsetAnnotations(ids) {
    this._annotationsStore.unsetAnnotations(ids);
  }

  setSidebarWidth(width) {
    window.PDFViewerApplication.pdfSidebarResizer._updateWidth(width);
  }

  setSidebarOpen(open) {
    this._enableSidebarOpenEvent = false;

    if (open) {
      window.PDFViewerApplication.pdfSidebar.open();
    } else {
      window.PDFViewerApplication.pdfSidebar.close();
    }

    this._enableSidebarOpenEvent = true;
  }

  setBottomPlaceholderHeight(height) {
    let root = document.documentElement;
    root.style.setProperty('--bottomPlaceholderHeight', height + 'px');
  }

  setToolbarPlaceholderWidth(width) {
    let root = document.documentElement;
    root.style.setProperty('--toolbarPlaceholderWidth', width + 'px');
  }

  reload(buf) {
    window.PDFViewerApplication.open(buf);
  } // TODO: Try to scroll into the required page avoiding first pages rendering to speed up navigation


  async _setState(state, skipScroll) {
    // window.PDFViewerApplication.pdfSidebar.switchView(state.sidebarView, true);
    // window.PDFViewerApplication.pdfSidebarResizer._updateWidth(state.sidebarWidth);
    if (Number.isInteger(state.scrollMode)) {
      window.PDFViewerApplication.pdfViewer.scrollMode = state.scrollMode;
    }

    if (Number.isInteger(state.spreadMode)) {
      window.PDFViewerApplication.pdfViewer.spreadMode = state.spreadMode;
    }

    if (Number.isInteger(state.rotation)) {
      window.PDFViewerApplication.pdfViewer.pagesRotation = state.rotation;
    } // Do this now and after pages are fully loaded.
    // For most PDFs the first one is enough and happens immediately,
    // for other PDFs we are repeating the navigation to correct it


    if (!skipScroll) {
      let dest = [null, {
        name: 'XYZ'
      }, // top/left must be null to be ignored
      state.left || null, state.top === undefined ? null : state.top, parseInt(state.scale) ? state.scale / 100 : state.scale];
      window.PDFViewerApplication.pdfViewer.scrollPageIntoView({
        pageNumber: (state.pageIndex || 0) + 1,
        destArray: dest,
        allowNegativeOffset: true
      });
    } // Note: Taken from pdf.js source:
    // For documents with different page sizes, once all pages are
    // resolved, ensure that the correct location becomes visible on load.
    // (To reduce the risk, in very large and/or slow loading documents,
    //  that the location changes *after* the user has started interacting
    //  with the viewer, wait for either `pagesPromise` or a timeout.)


    const FORCE_PAGES_LOADED_TIMEOUT = 10000;
    await Promise.race([window.PDFViewerApplication.pdfViewer.pagesPromise, new Promise(resolve => {
      setTimeout(resolve, FORCE_PAGES_LOADED_TIMEOUT);
    })]);

    if (!skipScroll) {
      let dest = [null, {
        name: 'XYZ'
      }, // top/left must be null to be ignored
      state.left || null, state.top === undefined ? null : state.top, parseInt(state.scale) ? state.scale / 100 : state.scale];
      window.PDFViewerApplication.pdfViewer.scrollPageIntoView({
        pageNumber: (state.pageIndex || 0) + 1,
        destArray: dest,
        allowNegativeOffset: true
      });
    }
  }

}

/* harmony default export */ var src_viewer = (viewer_Viewer);
// CONCATENATED MODULE: ./src/index.zotero.js


let loaded = false;
document.addEventListener('webviewerloaded', e => {
  window.PDFViewerApplicationOptions.set('eventBusDispatchToDOM', true);
  window.PDFViewerApplicationOptions.set('isEvalSupported', false);
  window.PDFViewerApplicationOptions.set('defaultUrl', '');
  window.PDFViewerApplicationOptions.set('cMapUrl', 'cmaps/');
  window.PDFViewerApplicationOptions.set('cMapPacked', true);
  window.PDFViewerApplicationOptions.set('workerSrc', 'pdf.worker.js');
  window.PDFViewerApplicationOptions.set('historyUpdateUrl', false);
  window.PDFViewerApplicationOptions.set('textLayerMode', 1); // Without this PDF.js forces opening outline view when it exists

  window.PDFViewerApplicationOptions.set('sidebarViewOnLoad', 0);
  window.PDFViewerApplicationOptions.set('ignoreDestinationZoom', true); // Disable interactive forms because our PDF saving mechanism can't
  // save then. In addition, we don't have styling for those forms,
  // and they sometimes show popup preventing to leave tab

  window.PDFViewerApplicationOptions.set('renderInteractiveForms', false);
  window.PDFViewerApplicationOptions.set('printResolution', 300);
  window.PDFViewerApplication.preferences = window.PDFViewerApplicationOptions;

  window.PDFViewerApplication.externalServices.createPreferences = function () {
    return window.PDFViewerApplicationOptions;
  };

  PDFViewerApplication.initializedPromise.then(function () {
    window.isReady = true;
    if (!window.PDFViewerApplication.pdfViewer || loaded) return;
    loaded = true;
    window.PDFViewerApplication.eventBus.on('documentinit', e => {});
  });
});

class index_zotero_ViewerInstance {
  constructor(options) {
    defineProperty_default()(this, "handleMessage", event => {
      if (event.source === parent) {
        return;
      }

      let data = event.data;

      if (event.data.itemID !== this._itemID) {
        return;
      }

      let message = data.message;

      switch (message.action) {
        case 'error':
          {
            window.PDFViewerApplication._otherError(message.message, message.moreInfo);

            return;
          }

        case 'navigate':
          {
            let {
              location
            } = message;

            this._viewer.navigate(location);

            return;
          }

        case 'enableAddToNote':
          {
            let {
              enable
            } = message;

            this._viewer.setEnableAddToNote(enable);

            return;
          }

        case 'setAnnotations':
          {
            let {
              annotations
            } = message;

            this._viewer.setAnnotations(annotations);

            return;
          }

        case 'unsetAnnotations':
          {
            let {
              ids
            } = message; // TODO: Handle conflicts when one user modifies and another deletes an annotation

            this._viewer.unsetAnnotations(ids);

            return;
          }

        case 'popupCmd':
          {
            this.handlePopupAction(message);
            return;
          }

        case 'menuCmd':
          {
            let {
              cmd
            } = message;
            this.handleMenuAction(cmd);
            return;
          }

        case 'setSidebarWidth':
          {
            let {
              width
            } = message;

            this._viewer.setSidebarWidth(width);

            return;
          }

        case 'setSidebarOpen':
          {
            let {
              open
            } = message;

            this._viewer.setSidebarOpen(open);

            return;
          }

        case 'setBottomPlaceholderHeight':
          {
            let {
              height
            } = message;

            this._viewer.setBottomPlaceholderHeight(height);

            return;
          }

        case 'setToolbarPlaceholderWidth':
          {
            let {
              width
            } = message;

            this._viewer.setToolbarPlaceholderWidth(width);

            return;
          }

        case 'focusLastToolbarButton':
          {
            document.getElementById('viewFind').focus();
            return;
          }

        case 'tabToolbar':
          {
            let {
              reverse
            } = message;

            this._viewer.annotatorRef.current.tabToolbar(reverse);

            return;
          }

        case 'focusFirst':
          {
            this._viewer.annotatorRef.current.focusFirst();

            return;
          }

        case 'reloading':
          {
            let node = document.getElementById('outerContainer');
            node.classList.add('suspend');
            return;
          }

        case 'reload':
          {
            let {
              buf
            } = message;

            this._viewer.reload(buf);

            let node = document.getElementById('outerContainer');
            node.classList.remove('suspend');
            return;
          }

        case 'setFontSize':
          {
            let {
              fontSize
            } = message;

            this._setFontSize(fontSize);
          }
      }
    });

    this._itemID = options.itemID;
    this._viewer = null;
    let _annotations = options.annotations;

    if (options.readOnly) {
      _annotations.forEach(x => x.readOnly = true);
    }

    window.addEventListener('message', this.handleMessage);
    window.itemID = options.itemID;
    window.rtl = options.rtl;
    this._viewer = new src_viewer({
      onAddToNote: annotations => {
        this._postMessage({
          action: 'addToNote',
          annotations
        });
      },
      onSaveAnnotations: annotations => {
        this._postMessage({
          action: 'saveAnnotations',
          annotations
        });
      },
      onDeleteAnnotations: ids => {
        this._postMessage({
          action: 'deleteAnnotations',
          ids
        });
      },
      onSetState: state => {
        this._postMessage({
          action: 'setState',
          state
        });
      },
      onClickTags: (id, event) => {
        let selector;

        if (event.target.closest('#viewerContainer')) {
          selector = '#viewerContainer .preview .tags';
        } else {
          selector = `[data-sidebar-annotation-id="${id}"] .tags`;
        }

        this._postMessage({
          action: 'openTagsPopup',
          id,
          selector
        });
      },
      onDoubleClickPageLabel: id => {
        this._postMessage({
          action: 'openPageLabelPopup',
          id
        });
      },
      onPopup: (name, data) => {
        this._postMessage({
          action: name,
          data
        });
      },
      onClosePopup: data => {
        this._postMessage({
          action: 'closePopup',
          data
        });
      },
      onExternalLink: url => {
        this._postMessage({
          action: 'openURL',
          url
        });
      },
      onDownload: () => {
        this._postMessage({
          action: 'save'
        });
      },
      onChangeSidebarWidth: width => {
        this._postMessage({
          action: 'changeSidebarWidth',
          width
        });
      },
      onChangeSidebarOpen: open => {
        this._postMessage({
          action: 'changeSidebarOpen',
          open
        });
      },
      onFocusSplitButton: () => {
        this._postMessage({
          action: 'focusSplitButton'
        });
      },
      onFocusContextPane: () => {
        this._postMessage({
          action: 'focusContextPane'
        });
      },
      buf: options.buf,
      annotations: _annotations,
      state: options.state,
      location: options.location,
      sidebarWidth: options.sidebarWidth,
      sidebarOpen: options.sidebarOpen,
      bottomPlaceholderHeight: options.bottomPlaceholderHeight,
      localizedStrings: options.localizedStrings,
      readOnly: options.readOnly,
      authorName: options.authorName
    });

    this._viewer.setBottomPlaceholderHeight(0);

    this._viewer.setToolbarPlaceholderWidth(0);

    this._setFontSize(options.fontSize);
  }

  _postMessage(message) {
    // console.log(message);
    parent.postMessage({
      itemID: this._itemID,
      message
    }, parent.origin);
  }

  uninit() {
    window.removeEventListener('message', this.handleMessage);

    this._viewer.uninit();
  }

  _setFontSize(fontSize) {
    let root = document.documentElement;
    root.style.fontSize = fontSize + 'em';
  }

  handlePopupAction(message) {
    // TODO: Fix multiple
    switch (message.cmd) {
      case 'addToNote':
        {
          let annotations = this._viewer._annotationsStore._annotations.filter(x => message.ids.includes(x.id)).map(x => ({ ...x,
            attachmentItemID: window.itemID
          }));

          if (annotations.length) {
            this._postMessage({
              action: 'addToNote',
              annotations
            });
          }

          return;
        }

      case 'deleteAnnotation':
        {
          this._viewer._annotationsStore.deleteAnnotations(message.ids);

          return;
        }

      case 'setAnnotationColor':
        {
          let annotations = [];

          for (let id of message.ids) {
            annotations.push({
              id,
              color: message.color
            });
          }

          this._viewer._annotationsStore.updateAnnotations(annotations);

          return;
        }

      case 'setColor':
        {
          this._viewer.setColor(message.color);

          return;
        }

      case 'openPageLabelPopup':
        {
          this._viewer.openPageLabelPopup(message.data);

          return;
        }

      case 'editHighlightedText':
        {
          this._viewer.editHighlightedText(message.data);

          return;
        }

      case 'clearSelector':
        {
          this._viewer.clearFilter();

          return;
        }

      case 'copy':
        {
          return;
        }

      case 'zoomIn':
        {
          PDFViewerApplication.zoomIn();
          return;
        }

      case 'zoomOut':
        {
          PDFViewerApplication.zoomOut();
          return;
        }

      case 'zoomAuto':
        {
          PDFViewerApplication.pdfViewer.currentScaleValue = 'auto';
          return;
        }

      case 'zoomPageWidth':
        {
          PDFViewerApplication.pdfViewer.currentScaleValue = 'page-width';
          return;
        }

      case 'zoomPageHeight':
        {
          PDFViewerApplication.pdfViewer.currentScaleValue = 'page-fit';
          return;
        }

      case 'prevPage':
        {
          PDFViewerApplication.pdfViewer.previousPage();
          return;
        }

      case 'nextPage':
        {
          PDFViewerApplication.pdfViewer.nextPage();
          return;
        }

      case 'copyImage':
        {
          let annotation = this._viewer._annotationsStore._annotations.find(x => message.data.ids.includes(x.id));

          if (annotation) {
            zoteroCopyImage(annotation.image);
          }

          return;
        }

      case 'saveImageAs':
        {
          let annotation = this._viewer._annotationsStore._annotations.find(x => message.data.ids.includes(x.id));

          if (annotation) {
            zoteroSaveImageAs(annotation.image);
          }

          return;
        }
    }
  }

  handleMenuAction(cmd) {
    let eb = window.PDFViewerApplication.eventBus;

    switch (cmd) {
      case 'presentationmode':
        {
          eb.dispatch('presentationmode');
          return;
        }

      case 'print':
        {
          eb.dispatch('print');
          return;
        }

      case 'download':
        {
          eb.dispatch('download');
          return;
        }

      case 'firstpage':
        {
          eb.dispatch('firstpage');
          return;
        }

      case 'lastpage':
        {
          eb.dispatch('lastpage');
          return;
        }

      case 'rotatecw':
        {
          eb.dispatch('rotatecw');
          return;
        }

      case 'rotateccw':
        {
          eb.dispatch('rotateccw');
          return;
        }
      // case 'switchcursortool_select': {
      // 	eb.dispatch('switchcursortool', { tool: 0 });
      // 	return;
      // }

      case 'switchcursortool_hand':
        {
          // eb.dispatch('switchcursortool', { tool: 1 });
          if (PDFViewerApplication.pdfCursorTools.activeTool === 0) {
            PDFViewerApplication.pdfCursorTools.switchTool(1);
          } else {
            PDFViewerApplication.pdfCursorTools.switchTool(0);
          }

          return;
        }

      case 'switchscrollmode_vertical':
        {
          eb.dispatch('switchscrollmode', {
            mode: 0
          });
          return;
        }

      case 'switchscrollmode_horizontal':
        {
          eb.dispatch('switchscrollmode', {
            mode: 1
          });
          return;
        }

      case 'switchscrollmode_wrapped':
        {
          eb.dispatch('switchscrollmode', {
            mode: 2
          });
          return;
        }

      case 'switchspreadmode_none':
        {
          eb.dispatch('switchspreadmode', {
            mode: 0
          });
          return;
        }

      case 'switchspreadmode_odd':
        {
          eb.dispatch('switchspreadmode', {
            mode: 1
          });
          return;
        }

      case 'switchspreadmode_even':
        {
          eb.dispatch('switchspreadmode', {
            mode: 2
          });
          return;
        }

      case 'back':
        {
          window.history.back();
          return;
        }

      case 'forward':
        {
          window.history.forward();
          return;
        }

      case 'zoomIn':
        {
          PDFViewerApplication.zoomIn();
          return;
        }

      case 'zoomOut':
        {
          PDFViewerApplication.zoomOut();
          return;
        }

      case 'zoomAuto':
        {
          PDFViewerApplication.pdfViewer.currentScaleValue = 'auto';
          return;
        }

      case 'zoomPageWidth':
        {
          PDFViewerApplication.pdfViewer.currentScaleValue = 'page-width';
          return;
        }

      case 'zoomPageHeight':
        {
          PDFViewerApplication.pdfViewer.currentScaleValue = 'page-fit';
          return;
        }
    }
  }

}

let currentViewerInstance = null;
window.addEventListener('message', function (event) {
  let itemID = event.data.itemID;
  let message = event.data.message;

  if (message.action === 'crash') {
    document.body.style.pointerEvents = 'none';
    let popover = document.createElement('div');
    popover.id = 'crash-popover';
    popover.append(message.message);
    document.body.append(popover);
  }

  if (message.action === 'open') {
    // TODO: Improve error handling here
    if (currentViewerInstance) {
      currentViewerInstance.uninit();
    }

    currentViewerInstance = new index_zotero_ViewerInstance({
      itemID,
      ...message
    });
    parent.postMessage({
      itemID,
      message: {
        action: 'initialized'
      }
    }, parent.origin);
  }
});

/***/ })
/******/ ]);
});