/*
 * Copyright 2010-2020 Gildas Lormeau
 * contact : gildas.lormeau <at> gmail.com
 * 
 * This file is part of SingleFile.
 *
 *   The code in this file is free software: you can redistribute it and/or 
 *   modify it under the terms of the GNU Affero General Public License 
 *   (GNU AGPL) as published by the Free Software Foundation, either version 3
 *   of the License, or (at your option) any later version.
 * 
 *   The code in this file is distributed in the hope that it will be useful, 
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of 
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU Affero 
 *   General Public License for more details.
 *
 *   As additional permission under GNU AGPL version 3 section 7, you may 
 *   distribute UNMODIFIED VERSIONS OF THIS file without the copy of the GNU 
 *   AGPL normally required by section 4, provided you include this license 
 *   notice and a URL through which recipients can access the Corresponding 
 *   Source.
 */

this.singlefile.lib.main = this.singlefile.lib.main || (() => {

	const singlefile = this.singlefile;

	return {
		init(initOptions) {
			const util = singlefile.lib.util.getInstance(initOptions);
			singlefile.lib.SingleFile = singlefile.lib.core.getClass(util, singlefile.lib.vendor.cssTree);
		}
	};

})();

this.singlefile.lib.getFileContent = filename => ({"lib/single-file/processors/hooks/content/content-hooks-web.js":"/*\n * Copyright 2010-2020 Gildas Lormeau\n * contact : gildas.lormeau <at> gmail.com\n * \n * This file is part of SingleFile.\n *\n *   The code in this file is free software: you can redistribute it and/or \n *   modify it under the terms of the GNU Affero General Public License \n *   (GNU AGPL) as published by the Free Software Foundation, either version 3\n *   of the License, or (at your option) any later version.\n * \n *   The code in this file is distributed in the hope that it will be useful, \n *   but WITHOUT ANY WARRANTY; without even the implied warranty of \n *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU Affero \n *   General Public License for more details.\n *\n *   As additional permission under GNU AGPL version 3 section 7, you may \n *   distribute UNMODIFIED VERSIONS OF THIS file without the copy of the GNU \n *   AGPL normally required by section 4, provided you include this license \n *   notice and a URL through which recipients can access the Corresponding \n *   Source.\n */\n\n/* global window */\n\n(() => {\n\n\tconst FETCH_REQUEST_EVENT = \"single-file-request-fetch\";\n\tconst FETCH_RESPONSE_EVENT = \"single-file-response-fetch\";\n\n\tconst CustomEvent = window.CustomEvent;\n\tconst fetch = window.fetch;\n\tconst addEventListener = (type, listener, options) => window.addEventListener(type, listener, options);\n\tconst dispatchEvent = event => window.dispatchEvent(event);\t\n\n\taddEventListener(FETCH_REQUEST_EVENT, async event => {\n\t\tconst url = event.detail;\n\t\tlet detail;\n\t\ttry {\n\t\t\tconst response = await fetch(url, { cache: \"force-cache\" });\n\t\t\tdetail = { url, response: await response.arrayBuffer(), headers: [...response.headers], status: response.status };\n\t\t} catch (error) {\n\t\t\tdetail = { url, error: error.toString() };\n\t\t}\n\t\tdispatchEvent(new CustomEvent(FETCH_RESPONSE_EVENT, { detail }));\n\t});\n\n})();\n","lib/single-file/processors/hooks/content/content-hooks-frames-web.js":"/*\n * Copyright 2010-2020 Gildas Lormeau\n * contact : gildas.lormeau <at> gmail.com\n * \n * This file is part of SingleFile.\n *\n *   The code in this file is free software: you can redistribute it and/or \n *   modify it under the terms of the GNU Affero General Public License \n *   (GNU AGPL) as published by the Free Software Foundation, either version 3\n *   of the License, or (at your option) any later version.\n * \n *   The code in this file is distributed in the hope that it will be useful, \n *   but WITHOUT ANY WARRANTY; without even the implied warranty of \n *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU Affero \n *   General Public License for more details.\n *\n *   As additional permission under GNU AGPL version 3 section 7, you may \n *   distribute UNMODIFIED VERSIONS OF THIS file without the copy of the GNU \n *   AGPL normally required by section 4, provided you include this license \n *   notice and a URL through which recipients can access the Corresponding \n *   Source.\n */\n\n/* global window, Event */\n\n(() => {\n\n\tconst LOAD_DEFERRED_IMAGES_START_EVENT = \"single-file-load-deferred-images-start\";\n\tconst LOAD_DEFERRED_IMAGES_END_EVENT = \"single-file-load-deferred-images-end\";\n\tconst LOAD_DEFERRED_IMAGES_KEEP_ZOOM_LEVEL_START_EVENT = \"single-file-load-deferred-images-keep-zoom-level-start\";\n\tconst LOAD_DEFERRED_IMAGES_KEEP_ZOOM_LEVEL_END_EVENT = \"single-file-load-deferred-images-keep-zoom-level-end\";\n\tconst LOAD_DEFERRED_IMAGES_RESET_ZOOM_LEVEL_END_EVENT = \"single-file-load-deferred-images-keep-zoom-level-reset\";\n\tconst BLOCK_COOKIES_START_EVENT = \"single-file-block-cookies-start\";\n\tconst BLOCK_COOKIES_END_EVENT = \"single-file-block-cookies-end\";\n\tconst BLOCK_STORAGE_START_EVENT = \"single-file-block-storage-start\";\n\tconst BLOCK_STORAGE_END_EVENT = \"single-file-block-storage-end\";\n\tconst LAZY_LOAD_ATTRIBUTE = \"single-file-lazy-load\";\n\tconst LOAD_IMAGE_EVENT = \"single-file-load-image\";\n\tconst IMAGE_LOADED_EVENT = \"single-file-image-loaded\";\n\tconst NEW_FONT_FACE_EVENT = \"single-file-new-font-face\";\n\tconst FONT_STYLE_PROPERTIES = {\n\t\tfamily: \"font-family\",\n\t\tstyle: \"font-style\",\n\t\tweight: \"font-weight\",\n\t\tstretch: \"font-stretch\",\n\t\tunicodeRange: \"unicode-range\",\n\t\tvariant: \"font-variant\",\n\t\tfeatureSettings: \"font-feature-settings\"\n\t};\n\n\tconst addEventListener = (type, listener, options) => window.addEventListener(type, listener, options);\n\tconst dispatchEvent = event => window.dispatchEvent(event);\n\tconst CustomEvent = window.CustomEvent;\n\tconst document = window.document;\n\tconst screen = window.screen;\n\tconst Element = window.Element;\n\tconst UIEvent = window.UIEvent;\n\tconst FileReader = window.FileReader;\n\tconst Blob = window.Blob;\n\tconst console = window.console;\n\tconst warn = (console && console.warn && ((...args) => console.warn(...args))) || (() => { });\n\n\tconst observers = new Map();\n\tconst observedElements = new Map();\n\n\taddEventListener(LOAD_DEFERRED_IMAGES_START_EVENT, () => loadDeferredImagesStart());\n\taddEventListener(LOAD_DEFERRED_IMAGES_KEEP_ZOOM_LEVEL_START_EVENT, () => loadDeferredImagesStart(true));\n\n\tfunction loadDeferredImagesStart(keepZoomLevel) {\n\t\tconst scrollingElement = document.scrollingElement || document.documentElement;\n\t\tconst clientHeight = scrollingElement.clientHeight;\n\t\tconst clientWidth = scrollingElement.clientWidth;\n\t\tconst scrollHeight = Math.max(scrollingElement.scrollHeight - clientHeight, clientHeight);\n\t\tconst scrollWidth = Math.max(scrollingElement.scrollWidth - clientWidth, clientWidth);\n\t\tdocument.querySelectorAll(\"[loading=lazy]\").forEach(element => {\n\t\t\telement.loading = \"eager\";\n\t\t\telement.setAttribute(LAZY_LOAD_ATTRIBUTE, \"\");\n\t\t});\n\t\tif (!keepZoomLevel) {\n\t\t\tscrollingElement.__defineGetter__(\"clientHeight\", () => scrollHeight);\n\t\t\tscrollingElement.__defineGetter__(\"clientWidth\", () => scrollWidth);\n\t\t\tscreen.__defineGetter__(\"height\", () => scrollHeight);\n\t\t\tscreen.__defineGetter__(\"width\", () => scrollWidth);\n\t\t\tif (!window._singleFile_getBoundingClientRect) {\n\t\t\t\twindow._singleFile_getBoundingClientRect = Element.prototype.getBoundingClientRect;\n\t\t\t\tElement.prototype.getBoundingClientRect = function () {\n\t\t\t\t\tconst boundingRect = window._singleFile_getBoundingClientRect.call(this);\n\t\t\t\t\tif (this == scrollingElement) {\n\t\t\t\t\t\tboundingRect.__defineGetter__(\"height\", () => scrollHeight);\n\t\t\t\t\t\tboundingRect.__defineGetter__(\"bottom\", () => scrollHeight + boundingRect.top);\n\t\t\t\t\t\tboundingRect.__defineGetter__(\"width\", () => scrollWidth);\n\t\t\t\t\t\tboundingRect.__defineGetter__(\"right\", () => scrollWidth + boundingRect.left);\n\t\t\t\t\t}\n\t\t\t\t\treturn boundingRect;\n\t\t\t\t};\n\t\t\t\twindow._singleFile_innerHeight = window.innerHeight;\n\t\t\t\twindow._singleFile_innerWidth = window.innerWidth;\n\t\t\t\twindow.__defineGetter__(\"innerHeight\", () => scrollHeight);\n\t\t\t\twindow.__defineGetter__(\"innerWidth\", () => scrollWidth);\n\t\t\t}\n\t\t}\n\t\tif (!window._singleFileImage) {\n\t\t\tconst Image = window.Image;\n\t\t\twindow._singleFileImage = window.Image;\n\t\t\twindow.__defineGetter__(\"Image\", function () {\n\t\t\t\treturn function () {\n\t\t\t\t\tconst image = new Image(...arguments);\n\t\t\t\t\tconst result = new Image(...arguments);\n\t\t\t\t\tresult.__defineSetter__(\"src\", function (value) {\n\t\t\t\t\t\timage.src = value;\n\t\t\t\t\t\tdispatchEvent(new CustomEvent(LOAD_IMAGE_EVENT, { detail: image.src }));\n\t\t\t\t\t});\n\t\t\t\t\tresult.__defineGetter__(\"src\", function () {\n\t\t\t\t\t\treturn image.src;\n\t\t\t\t\t});\n\t\t\t\t\tresult.__defineSetter__(\"srcset\", function (value) {\n\t\t\t\t\t\tdispatchEvent(new CustomEvent(LOAD_IMAGE_EVENT));\n\t\t\t\t\t\timage.srcset = value;\n\t\t\t\t\t});\n\t\t\t\t\tresult.__defineGetter__(\"srcset\", function () {\n\t\t\t\t\t\treturn image.srcset;\n\t\t\t\t\t});\n\t\t\t\t\timage.onload = image.onloadend = image.onerror = event => {\n\t\t\t\t\t\tdispatchEvent(new CustomEvent(IMAGE_LOADED_EVENT, { detail: image.src }));\n\t\t\t\t\t\tresult.dispatchEvent(new UIEvent(event.type, event));\n\t\t\t\t\t};\n\t\t\t\t\tif (image.decode) {\n\t\t\t\t\t\tresult.decode = () => image.decode();\n\t\t\t\t\t}\n\t\t\t\t\treturn result;\n\t\t\t\t};\n\t\t\t});\n\t\t}\n\t\tlet zoomFactorX, zoomFactorY;\n\t\tif (keepZoomLevel) {\n\t\t\tzoomFactorX = clientHeight / scrollHeight;\n\t\t\tzoomFactorY = clientWidth / scrollWidth;\n\t\t} else {\n\t\t\tzoomFactorX = (clientHeight + window.scrollY) / scrollHeight;\n\t\t\tzoomFactorY = (clientWidth + window.scrollX) / scrollWidth;\n\t\t}\n\t\tconst zoomFactor = Math.min(zoomFactorX, zoomFactorY);\n\t\tif (zoomFactor < 1) {\n\t\t\tconst transform = document.documentElement.style.getPropertyValue(\"transform\");\n\t\t\tconst transformPriority = document.documentElement.style.getPropertyPriority(\"transform\");\n\t\t\tconst transformOrigin = document.documentElement.style.getPropertyValue(\"transform-origin\");\n\t\t\tconst transformOriginPriority = document.documentElement.style.getPropertyPriority(\"transform-origin\");\n\t\t\tconst minHeight = document.documentElement.style.getPropertyValue(\"min-height\");\n\t\t\tconst minHeightPriority = document.documentElement.style.getPropertyPriority(\"min-height\");\n\t\t\tdocument.documentElement.style.setProperty(\"transform-origin\", (zoomFactorX < 1 ? \"50%\" : \"0\") + \" \" + (zoomFactorY < 1 ? \"50%\" : \"0\") + \" 0\", \"important\");\n\t\t\tdocument.documentElement.style.setProperty(\"transform\", \"scale3d(\" + zoomFactor + \", \" + zoomFactor + \", 1)\", \"important\");\n\t\t\tdocument.documentElement.style.setProperty(\"min-height\", (100 / zoomFactor) + \"vh\", \"important\");\n\t\t\tdispatchResizeEvent();\n\t\t\tif (keepZoomLevel) {\n\t\t\t\tdocument.documentElement.style.setProperty(\"-sf-transform\", transform, transformPriority);\n\t\t\t\tdocument.documentElement.style.setProperty(\"-sf-transform-origin\", transformOrigin, transformOriginPriority);\n\t\t\t\tdocument.documentElement.style.setProperty(\"-sf-min-height\", minHeight, minHeightPriority);\n\t\t\t} else {\n\t\t\t\tdocument.documentElement.style.setProperty(\"transform\", transform, transformPriority);\n\t\t\t\tdocument.documentElement.style.setProperty(\"transform-origin\", transformOrigin, transformOriginPriority);\n\t\t\t\tdocument.documentElement.style.setProperty(\"min-height\", minHeight, minHeightPriority);\n\t\t\t}\n\t\t}\n\t\tif (!keepZoomLevel) {\n\t\t\tdispatchResizeEvent();\n\t\t\tconst docBoundingRect = scrollingElement.getBoundingClientRect();\n\t\t\t[...observers].forEach(([intersectionObserver, observer]) => {\n\t\t\t\tconst rootBoundingRect = observer.options && observer.options.root && observer.options.root.getBoundingClientRect();\n\t\t\t\tconst targetElements = observedElements.get(intersectionObserver);\n\t\t\t\tif (targetElements) {\n\t\t\t\t\tobserver.callback(targetElements.map(target => {\n\t\t\t\t\t\tconst boundingClientRect = target.getBoundingClientRect();\n\t\t\t\t\t\tconst isIntersecting = true;\n\t\t\t\t\t\tconst intersectionRatio = 1;\n\t\t\t\t\t\tconst rootBounds = observer.options && observer.options.root ? rootBoundingRect : docBoundingRect;\n\t\t\t\t\t\tconst time = 0;\n\t\t\t\t\t\treturn { target, intersectionRatio, boundingClientRect, intersectionRect: boundingClientRect, isIntersecting, rootBounds, time };\n\t\t\t\t\t}), intersectionObserver);\n\t\t\t\t}\n\t\t\t});\n\t\t}\n\t}\n\n\taddEventListener(LOAD_DEFERRED_IMAGES_END_EVENT, () => loadDeferredImagesEnd());\n\taddEventListener(LOAD_DEFERRED_IMAGES_KEEP_ZOOM_LEVEL_END_EVENT, () => loadDeferredImagesEnd(true));\n\taddEventListener(LOAD_DEFERRED_IMAGES_RESET_ZOOM_LEVEL_END_EVENT, () => {\n\t\tconst transform = document.documentElement.style.getPropertyValue(\"-sf-transform\");\n\t\tconst transformPriority = document.documentElement.style.getPropertyPriority(\"-sf-transform\");\n\t\tconst transformOrigin = document.documentElement.style.getPropertyValue(\"-sf-transform-origin\");\n\t\tconst transformOriginPriority = document.documentElement.style.getPropertyPriority(\"-sf-transform-origin\");\n\t\tconst minHeight = document.documentElement.style.getPropertyValue(\"-sf-min-height\");\n\t\tconst minHeightPriority = document.documentElement.style.getPropertyPriority(\"-sf-min-height\");\n\t\tdocument.documentElement.style.setProperty(\"transform\", transform, transformPriority);\n\t\tdocument.documentElement.style.setProperty(\"transform-origin\", transformOrigin, transformOriginPriority);\n\t\tdocument.documentElement.style.setProperty(\"min-height\", minHeight, minHeightPriority);\n\t\tdocument.documentElement.style.removeProperty(\"-sf-transform\");\n\t\tdocument.documentElement.style.removeProperty(\"-sf-transform-origin\");\n\t\tdocument.documentElement.style.removeProperty(\"-sf-min-height\");\n\t});\n\n\tfunction loadDeferredImagesEnd(keepZoomLevel) {\n\t\tconst scrollingElement = document.scrollingElement || document.documentElement;\n\t\tdocument.querySelectorAll(\"[\" + LAZY_LOAD_ATTRIBUTE + \"]\").forEach(element => {\n\t\t\telement.loading = \"lazy\";\n\t\t\telement.removeAttribute(LAZY_LOAD_ATTRIBUTE);\n\t\t});\n\t\tif (!keepZoomLevel) {\n\t\t\tdelete scrollingElement.clientHeight;\n\t\t\tdelete scrollingElement.clientWidth;\n\t\t\tdelete screen.height;\n\t\t\tdelete screen.width;\n\t\t\tif (window._singleFile_getBoundingClientRect) {\n\t\t\t\tElement.prototype.getBoundingClientRect = window._singleFile_getBoundingClientRect;\n\t\t\t\twindow.innerHeight = window._singleFile_innerHeight;\n\t\t\t\twindow.innerWidth = window._singleFile_innerWidth;\n\t\t\t\tdelete window._singleFile_getBoundingClientRect;\n\t\t\t\tdelete window._singleFile_innerHeight;\n\t\t\t\tdelete window._singleFile_innerWidth;\n\t\t\t}\n\t\t}\n\t\tif (window._singleFileImage) {\n\t\t\tdelete window.Image;\n\t\t\twindow.Image = window._singleFileImage;\n\t\t\tdelete window._singleFileImage;\n\t\t}\n\t\tif (!keepZoomLevel) {\n\t\t\tdispatchResizeEvent();\n\t\t}\n\t}\n\n\taddEventListener(BLOCK_COOKIES_START_EVENT, () => {\n\t\ttry {\n\t\t\tdocument.__defineGetter__(\"cookie\", () => { throw new Error(\"document.cookie temporary blocked by SingleFile\"); });\n\t\t} catch (error) {\n\t\t\t// ignored\n\t\t}\n\t});\n\n\taddEventListener(BLOCK_COOKIES_END_EVENT, () => {\n\t\tdelete document.cookie;\n\t});\n\n\taddEventListener(BLOCK_STORAGE_START_EVENT, () => {\n\t\tif (!window._singleFile_localStorage) {\n\t\t\twindow._singleFile_localStorage = window.localStorage;\n\t\t\twindow.__defineGetter__(\"localStorage\", () => { throw new Error(\"localStorage temporary blocked by SingleFile\"); });\n\t\t}\n\t\tif (!window._singleFile_indexedDB) {\n\t\t\twindow._singleFile_indexedDB = window.indexedDB;\n\t\t\twindow.__defineGetter__(\"indexedDB\", () => { throw new Error(\"indexedDB temporary blocked by SingleFile\"); });\n\t\t}\n\t});\n\n\taddEventListener(BLOCK_STORAGE_END_EVENT, () => {\n\t\tif (window._singleFile_localStorage) {\n\t\t\tdelete window.localStorage;\n\t\t\twindow.localStorage = window._singleFile_localStorage;\n\t\t\tdelete window._singleFile_localStorage;\n\t\t}\n\t\tif (!window._singleFile_indexedDB) {\n\t\t\tdelete window.indexedDB;\n\t\t\twindow.indexedDB = window._singleFile_indexedDB;\n\t\t\tdelete window._singleFile_indexedDB;\n\t\t}\n\t});\n\n\tif (window.FontFace) {\n\t\tconst FontFace = window.FontFace;\n\t\tlet warningFontFaceDisplayed;\n\t\twindow.FontFace = function () {\n\t\t\tif (!warningFontFaceDisplayed) {\n\t\t\t\twarn(\"SingleFile is hooking the FontFace constructor to get font URLs.\"); // eslint-disable-line no-console\n\t\t\t\twarningFontFaceDisplayed = true;\n\t\t\t}\n\t\t\tconst detail = {};\n\t\t\tdetail[\"font-family\"] = arguments[0];\n\t\t\tdetail.src = arguments[1];\n\t\t\tconst descriptors = arguments[2];\n\t\t\tif (descriptors) {\n\t\t\t\tObject.keys(descriptors).forEach(descriptor => {\n\t\t\t\t\tif (FONT_STYLE_PROPERTIES[descriptor]) {\n\t\t\t\t\t\tdetail[FONT_STYLE_PROPERTIES[descriptor]] = descriptors[descriptor];\n\t\t\t\t\t}\n\t\t\t\t});\n\t\t\t}\n\t\t\tif (detail.src instanceof ArrayBuffer) {\n\t\t\t\tconst reader = new FileReader();\n\t\t\t\treader.readAsDataURL(new Blob([detail.src]));\n\t\t\t\treader.addEventListener(\"load\", () => {\n\t\t\t\t\tdetail.src = \"url(\" + reader.result + \")\";\n\t\t\t\t\tdispatchEvent(new CustomEvent(NEW_FONT_FACE_EVENT, { detail }));\n\t\t\t\t});\n\t\t\t} else {\n\t\t\t\tdispatchEvent(new CustomEvent(NEW_FONT_FACE_EVENT, { detail }));\n\t\t\t}\n\t\t\treturn new FontFace(...arguments);\n\t\t};\n\t\twindow.FontFace.toString = function () { return \"function FontFace() { [native code] }\"; };\n\t}\n\n\tif (window.IntersectionObserver) {\n\t\tconst IntersectionObserver = window.IntersectionObserver;\n\t\tlet warningIntersectionObserverDisplayed;\n\t\twindow.IntersectionObserver = function () {\n\t\t\tif (!warningIntersectionObserverDisplayed) {\n\t\t\t\twarn(\"SingleFile is hooking the IntersectionObserver API to detect and load deferred images.\"); // eslint-disable-line no-console\n\t\t\t\twarningIntersectionObserverDisplayed = true;\n\t\t\t}\n\t\t\tconst intersectionObserver = new IntersectionObserver(...arguments);\n\t\t\tconst observeIntersection = IntersectionObserver.prototype.observe || intersectionObserver.observe;\n\t\t\tconst unobserveIntersection = IntersectionObserver.prototype.unobserve || intersectionObserver.unobserve;\n\t\t\tconst callback = arguments[0];\n\t\t\tconst options = arguments[1];\n\t\t\tif (observeIntersection) {\n\t\t\t\tintersectionObserver.observe = function (targetElement) {\n\t\t\t\t\tlet targetElements = observedElements.get(intersectionObserver);\n\t\t\t\t\tif (!targetElements) {\n\t\t\t\t\t\ttargetElements = [];\n\t\t\t\t\t\tobservedElements.set(intersectionObserver, targetElements);\n\t\t\t\t\t}\n\t\t\t\t\ttargetElements.push(targetElement);\n\t\t\t\t\treturn observeIntersection.call(intersectionObserver, targetElement);\n\t\t\t\t};\n\t\t\t}\n\t\t\tif (unobserveIntersection) {\n\t\t\t\tintersectionObserver.unobserve = function (targetElement) {\n\t\t\t\t\tlet targetElements = observedElements.get(intersectionObserver);\n\t\t\t\t\tif (targetElements) {\n\t\t\t\t\t\ttargetElements = targetElements.filter(element => element != targetElement);\n\t\t\t\t\t\tif (targetElements.length) {\n\t\t\t\t\t\t\tobservedElements.set(intersectionObserver, targetElements);\n\t\t\t\t\t\t} else {\n\t\t\t\t\t\t\tobservedElements.delete(intersectionObserver);\n\t\t\t\t\t\t\tobservers.delete(intersectionObserver);\n\t\t\t\t\t\t}\n\t\t\t\t\t}\n\t\t\t\t\treturn unobserveIntersection.call(intersectionObserver, targetElement);\n\t\t\t\t};\n\t\t\t}\n\t\t\tobservers.set(intersectionObserver, { callback, options });\n\t\t\treturn intersectionObserver;\n\t\t};\n\t\twindow.IntersectionObserver.prototype = IntersectionObserver.prototype;\n\t\twindow.IntersectionObserver.toString = function () { return \"function IntersectionObserver() { [native code] }\"; };\n\t}\n\n\tfunction dispatchResizeEvent() {\n\t\ttry {\n\t\t\tdispatchEvent(new UIEvent(\"resize\"));\n\t\t\tdocument.dispatchEvent(new Event(\"scroll\", { bubbles: true }));\n\t\t} catch (error) {\n\t\t\t// ignored\n\t\t}\n\t}\n\n})();\n"})[filename];
