Object.defineProperty(exports, "__esModule", { value: true });
























var _react = require("react");var _react2 = _interopRequireDefault(_react);
var _propTypes = require("prop-types");var _propTypes2 = _interopRequireDefault(_propTypes);
var _classnames = require("classnames");var _classnames2 = _interopRequireDefault(_classnames);
var _content = require("./editable/content");var _content2 = _interopRequireDefault(_content);
var _input = require("./form/input");var _input2 = _interopRequireDefault(_input);
var _textArea = require("./form/textArea");var _textArea2 = _interopRequireDefault(_textArea);
var _select = require("./form/select");var _select2 = _interopRequireDefault(_select);
var _utils = require("./utils");function _interopRequireDefault(obj) {return obj && obj.__esModule ? obj : { default: obj };}function _extends() {_extends = Object.assign || function (target) {for (var i = 1; i < arguments.length; i++) {var source = arguments[i];for (var key in source) {if (Object.prototype.hasOwnProperty.call(source, key)) {target[key] = source[key];}}}return target;};return _extends.apply(this, arguments);}function _objectWithoutProperties(source, excluded) {if (source == null) return {};var target = _objectWithoutPropertiesLoose(source, excluded);var key, i;if (Object.getOwnPropertySymbols) {var sourceSymbolKeys = Object.getOwnPropertySymbols(source);for (i = 0; i < sourceSymbolKeys.length; i++) {key = sourceSymbolKeys[i];if (excluded.indexOf(key) >= 0) continue;if (!Object.prototype.propertyIsEnumerable.call(source, key)) continue;target[key] = source[key];}}return target;}function _objectWithoutPropertiesLoose(source, excluded) {if (source == null) return {};var target = {};var sourceKeys = Object.keys(source);var key, i;for (i = 0; i < sourceKeys.length; i++) {key = sourceKeys[i];if (excluded.indexOf(key) >= 0) continue;target[key] = source[key];}return target;}function _defineProperty(obj, key, value) {if (key in obj) {Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true });} else {obj[key] = value;}return obj;}

class Editable extends _react2.default.PureComponent {
  get isActive() {
    return (this.props.isActive || this.props.isBusy) && !this.props.isDisabled;
  }

  get isReadOnly() {
    return this.props.isReadOnly || this.props.isBusy;
  }

  get className() {
    const { input, inputComponent } = this.props;
    return {
      'editable': true,
      'editing': this.isActive,
      'textarea': inputComponent === _textArea2.default || input && input.type === _textArea2.default,
      'select': inputComponent === _select2.default || input && input.type === _select2.default };

  }

  renderContent() {
    const hasChildren = typeof this.props.children !== 'undefined';
    return /*#__PURE__*/(
      _react2.default.createElement(_react2.default.Fragment, null,

      hasChildren ?
      this.props.children : /*#__PURE__*/
      _react2.default.createElement(_content2.default, this.props)));



  }

  renderControls() {
    const { input: InputElement, inputComponent: InputComponent } = this.props;
    if (InputElement) {
      return InputElement;
    } else {
      const _this$props = this.props,{ className, innerRef } = _this$props,props = _objectWithoutProperties(_this$props, ["className", "innerRef"]);
      props.ref = innerRef;

      return /*#__PURE__*/_react2.default.createElement(InputComponent, _extends({
        className: (0, _classnames2.default)(className, "editable-control") },
      props));

    }
  }

  render() {
    const { isDisabled, isReadOnly } = this.props;
    return /*#__PURE__*/(
      _react2.default.createElement("div", {
        tabIndex: isDisabled || isReadOnly ? null : this.isActive ? null : 0,
        onClick: event => this.props.onClick(event),
        onFocus: event => this.props.onFocus(event),
        onMouseDown: event => this.props.onMouseDown(event),
        className: (0, _classnames2.default)(this.className) },

      this.isActive ? this.renderControls() : this.renderContent()));


  }}_defineProperty(Editable, "defaultProps",
{
  inputComponent: _input2.default,
  onClick: _utils.noop,
  onFocus: _utils.noop,
  onMouseDown: _utils.noop });_defineProperty(Editable, "propTypes",


{
  children: _propTypes2.default.oneOfType([_propTypes2.default.element, _propTypes2.default.array]),
  input: _propTypes2.default.element,
  inputComponent: _propTypes2.default.elementType,
  isActive: _propTypes2.default.bool,
  isBusy: _propTypes2.default.bool,
  isDisabled: _propTypes2.default.bool,
  isReadOnly: _propTypes2.default.bool });exports.default = /*#__PURE__*/




_react2.default.forwardRef((props, ref) => /*#__PURE__*/_react2.default.createElement(Editable, _extends({
  innerRef: ref }, props)));