Object.defineProperty(exports, "__esModule", { value: true });
























var _react = require("react");var _react2 = _interopRequireDefault(_react);
var _propTypes = require("prop-types");var _propTypes2 = _interopRequireDefault(_propTypes);
var _classnames = require("classnames");var _classnames2 = _interopRequireDefault(_classnames);
var _utils = require("../utils");
var _immutable = require("@zotero/immutable");

var _reactAutosuggest = require("react-autosuggest");var _reactAutosuggest2 = _interopRequireDefault(_reactAutosuggest);function _interopRequireDefault(obj) {return obj && obj.__esModule ? obj : { default: obj };}function _extends() {_extends = Object.assign || function (target) {for (var i = 1; i < arguments.length; i++) {var source = arguments[i];for (var key in source) {if (Object.prototype.hasOwnProperty.call(source, key)) {target[key] = source[key];}}}return target;};return _extends.apply(this, arguments);}function _objectSpread(target) {for (var i = 1; i < arguments.length; i++) {var source = arguments[i] != null ? arguments[i] : {};var ownKeys = Object.keys(source);if (typeof Object.getOwnPropertySymbols === 'function') {ownKeys = ownKeys.concat(Object.getOwnPropertySymbols(source).filter(function (sym) {return Object.getOwnPropertyDescriptor(source, sym).enumerable;}));}ownKeys.forEach(function (key) {_defineProperty(target, key, source[key]);});}return target;}function _defineProperty(obj, key, value) {if (key in obj) {Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true });} else {obj[key] = value;}return obj;}

class Input extends _react2.default.PureComponent {
  constructor(props) {
    super(props);_defineProperty(this, "handleSuggestionSelected",



















































































































    (event, { suggestion, suggestionValue, suggestionIndex, sectionIndex, method }) => {
      this.selectedSuggestion.current = suggestionValue;
      // focusInputOnSuggestionClick in Autosuggest doesn't work with a custom renderInputComponent,
      // so refocus the textbox manually
      setTimeout(() => this.props.innerRef.current.focus());
    });this.state = { suggestions: [], value: props.value };this.suggestions = _react2.default.createRef();this.showSuggestions = _react2.default.createRef(false);this.preSuggestionValue = _react2.default.createRef();this.selectedSuggestion = _react2.default.createRef();}cancel(event = null) {this.props.onCancel(this.hasChanged, event);this.hasBeenCancelled = true;this.props.innerRef.current && this.props.innerRef.current.blur();}commit(event = null) {this.props.onCommit(this.state.value, this.hasChanged, event);this.hasBeenCommitted = true;}focus() {if (this.props.innerRef.current != null) {this.props.innerRef.current.focus();this.props.selectOnFocus && this.props.innerRef.current.select();}}UNSAFE_componentWillReceiveProps({ value }) {if (value !== this.props.value) {this.setState({ value });}}handleChange({ target }, options) {var newValue = options.newValue || target.value;this.setState({ value: newValue });this.props.onChange(newValue);}handleBlur(event) {if (this.selectedSuggestion.current) {this.selectedSuggestion.current = null;return;}if (this.hasBeenCancelled || this.hasBeenCommitted) {return;}const shouldCancel = this.props.onBlur(event);shouldCancel ? this.cancel(event) : this.commit(event);}handleFocus(event) {!this.focused && this.props.selectOnFocus && event.target.select(); // Only focus the input once so that the entered text doesn't get selected when it matches
    // a suggestion and the input gets rerendered with the suggestions drop-down
    this.focused = true;this.showSuggestions.current = false;this.props.onFocus(event);}handleKeyDown(event) {this.showSuggestions.current = true;switch (event.key) {case 'Escape':this.cancel(event);break;case 'Enter':if (this.selectedSuggestion.current) {let value = this.selectedSuggestion.current;this.selectedSuggestion.current = null;this.setState({ value });} else {this.commit(event);}break;}this.props.onKeyDown(event);}handlePaste(event) {this.props.onPaste && this.props.onPaste(event);} // Autosuggest will call this function every time you need to update suggestions.
  // You already implemented this logic above, so just use it.
  async handleSuggestionsFetchRequested({ value }) {this.setState({ suggestions: await this.props.getSuggestions(value) });} // Autosuggest will call this function every time you need to clear suggestions.
  handleSuggestionsClearRequested() {this.setState({ suggestions: [] });}getSuggestionValue(suggestion) {return suggestion;}shouldRenderSuggestions(value) {return value.length && this.showSuggestions.current;}renderSuggestion(suggestion) {return _react2.default.createElement("span", null, suggestion);}get value() {return this.state.value;}
  get hasChanged() {
    return this.state.value !== this.props.value;
  }

  renderInput() {
    this.hasBeenCancelled = false;
    this.hasBeenCommitted = false;

    const inputProps = _objectSpread({
      disabled: this.props.isDisabled,
      onBlur: this.handleBlur.bind(this),
      onChange: this.handleChange.bind(this),
      onFocus: this.handleFocus.bind(this),
      onKeyDown: this.handleKeyDown.bind(this),
      onPaste: this.handlePaste.bind(this),
      readOnly: this.props.isReadOnly,
      required: this.props.isRequired,
      value: this.state.value },
    (0, _immutable.pickKeys)(this.props, ['autoFocus', 'className', 'form', 'id', 'inputMode', 'max',
    'maxLength', 'min', 'minLength', 'name', 'placeholder', 'type', 'spellCheck',
    'step', 'tabIndex']),
    (0, _immutable.pickKeys)(this.props, key => key.match(/^(aria-|data-).*/)));


    var input = this.props.autoComplete ?
    _react2.default.createElement(_reactAutosuggest2.default, {
      suggestions: this.state.suggestions,
      onSuggestionsFetchRequested: this.handleSuggestionsFetchRequested.bind(this),
      onSuggestionsClearRequested: this.handleSuggestionsClearRequested.bind(this),
      onSuggestionSelected: this.handleSuggestionSelected,
      getSuggestionValue: this.getSuggestionValue.bind(this),
      renderSuggestion: this.renderSuggestion.bind(this)
      // https://github.com/moroshko/react-autosuggest/issues/474
      , renderInputComponent: inputProps => _react2.default.createElement("input", _extends({}, inputProps, { ref: this.props.innerRef })),
      focusInputOnSuggestionClick: false,
      shouldRenderSuggestions: this.shouldRenderSuggestions.bind(this),
      inputProps: inputProps }) :


    _react2.default.createElement("input", inputProps);


    if (this.props.resize) {
      /*input = (
                            	<AutoResizer
                            		content={ this.state.value }
                            		vertical={ this.props.resize === 'vertical' }
                            	>
                            		{ input }
                            	</AutoResizer>
                            );*/
    }

    return input;
  }

  render() {
    const className = (0, _classnames2.default)({
      'input-group': true,
      'input': true,
      'busy': this.props.isBusy },
    this.props.inputGroupClassName);
    return (
      _react2.default.createElement("div", { className: className },
      this.renderInput()));


  }}_defineProperty(Input, "defaultProps",

{
  className: 'form-control',
  onBlur: _utils.noop,
  onCancel: _utils.noop,
  onChange: _utils.noop,
  onCommit: _utils.noop,
  onFocus: _utils.noop,
  onKeyDown: _utils.noop,
  onPaste: _utils.noop,
  tabIndex: -1,
  type: 'text',
  value: '' });_defineProperty(Input, "propTypes",


{
  autoComplete: _propTypes2.default.bool,
  autoFocus: _propTypes2.default.bool,
  className: _propTypes2.default.string,
  form: _propTypes2.default.string,
  getSuggestions: _propTypes2.default.func,
  id: _propTypes2.default.string,
  inputGroupClassName: _propTypes2.default.string,
  inputMode: _propTypes2.default.string,
  isBusy: _propTypes2.default.bool,
  isDisabled: _propTypes2.default.bool,
  isReadOnly: _propTypes2.default.bool,
  isRequired: _propTypes2.default.bool,
  max: _propTypes2.default.number,
  maxLength: _propTypes2.default.number,
  min: _propTypes2.default.number,
  minLength: _propTypes2.default.number,
  name: _propTypes2.default.string,
  onBlur: _propTypes2.default.func.isRequired,
  onCancel: _propTypes2.default.func.isRequired,
  onChange: _propTypes2.default.func.isRequired,
  onCommit: _propTypes2.default.func.isRequired,
  onFocus: _propTypes2.default.func.isRequired,
  onKeyDown: _propTypes2.default.func,
  onPaste: _propTypes2.default.func,
  placeholder: _propTypes2.default.string,
  resize: _propTypes2.default.oneOfType([_propTypes2.default.bool, _propTypes2.default.string]),
  selectOnFocus: _propTypes2.default.bool,
  spellCheck: _propTypes2.default.bool,
  step: _propTypes2.default.number,
  tabIndex: _propTypes2.default.number,
  type: _propTypes2.default.string.isRequired,
  value: _propTypes2.default.string.isRequired });exports.default =



_react2.default.forwardRef((props, ref) => _react2.default.createElement(Input, _extends({
  innerRef: ref }, props)));