'use strict';function _defineProperty(obj, key, value) {if (key in obj) {Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true });} else {obj[key] = value;}return obj;}

const React = require('react');
const PropTypes = require('prop-types');

class Search extends React.PureComponent {
  constructor(props) {
    super(props);_defineProperty(this, "state",



    {
      immediateValue: this.props.value });_defineProperty(this, "handleChange",












    event => {
      var value = event.target.value;
      // Update controlled value and cancel button immediately
      this.setState({
        immediateValue: value });

      // Debounce the search based on the timeout
      if (this._timeout) {
        clearTimeout(this._timeout);
      }
      this._timeout = this.props.timeout &&
      setTimeout(() => this.props.onSearch(value), this.props.timeout);
    });_defineProperty(this, "handleClear",

    () => {
      if (this._timeout) {
        clearTimeout(this._timeout);
      }
      this.setState({
        immediateValue: '' });

      this.props.onSearch('');
    });_defineProperty(this, "handleKeyDown",

    event => {
      if (event.key == 'Escape') {
        this.handleClear();
      }
    });this.inputRef = React.createRef();}static getDerivedStateFromProps(props, state) {var prevProps = state.prevProps || {};return { prevProps: props, immediateValue: prevProps.value !== props.value ? props.value : state.immediateValue };}

  focus() {
    this.inputRef.current.focus();
  }

  render() {
    return (
      React.createElement("div", { className: "search" },
      React.createElement("input", {
        ref: this.inputRef,
        type: "search",
        onChange: this.handleChange,
        onKeyDown: this.handleKeyDown,
        value: this.state.immediateValue }),

      this.state.immediateValue !== '' ?
      React.createElement("div", {
        className: "search-cancel-button",
        onClick: this.handleClear }) :
      ''));


  }}_defineProperty(Search, "propTypes",

{
  inputRef: PropTypes.object,
  onSearch: PropTypes.func,
  timeout: PropTypes.number,
  value: PropTypes.string });_defineProperty(Search, "defaultProps",


{
  onSearch: () => {},
  timeout: 300,
  value: '' });



module.exports = Search;